/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.model.datatype;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDNumeric;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDTypeValue;

@XmlRootElement(name="Numeric")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class NumericType
extends DataType {
    private static final long serialVersionUID = -1778127136791503220L;
    Integer precision = null;
    Integer scale = null;

    public NumericType() {
    }

    public NumericType(int precision) {
        if (precision <= 0) {
            throw new IllegalArgumentException("Precision must be positive");
        }
        this.precision = precision;
    }

    public NumericType(int precision, int scale) {
        if (precision <= 0) {
            throw new IllegalArgumentException("Precision must be positive.");
        }
        if (scale < 0 || scale > precision) {
            throw new IllegalArgumentException("Scale must be 0 or less than precision.");
        }
        this.precision = precision;
        this.scale = scale;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public Integer getScale() {
        return this.scale;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.precision == null ? 0 : this.precision.hashCode());
        result = 31 * result + (this.scale == null ? 0 : this.scale.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NumericType other = (NumericType)obj;
        if (this.precision == null ? other.precision != null : !this.precision.equals(other.precision)) {
            return false;
        }
        return !(this.scale == null ? other.scale != null : !this.scale.equals(other.scale));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Numeric");
        if (this.scale != null) {
            builder.append("(" + this.precision + "," + this.scale + ")");
        } else if (this.precision != null) {
            builder.append("(" + this.precision + ")");
        }
        return builder.toString();
    }

    @Override
    public String getName() {
        return "Numeric";
    }

    @Override
    public TDTypeValue getDefaultValue() {
        return new TDNumeric(0.0);
    }

    @Override
    public TDTypeValue fromString(String value) {
        return new TDNumeric(Double.parseDouble(value));
    }
}

