/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.querybuilder.manager;

import org.sdmxsource.sdmx.api.builder.StructureQueryBuilder;
import org.sdmxsource.sdmx.api.exception.SdmxUnauthorisedException;
import org.sdmxsource.sdmx.api.factory.StructureQueryFactory;
import org.sdmxsource.sdmx.api.manager.query.StructureQueryBuilderManager;
import org.sdmxsource.sdmx.api.model.format.StructureQueryFormat;
import org.sdmxsource.sdmx.api.model.query.RESTStructureQuery;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class StructureQueryBuilderManagerImpl
implements StructureQueryBuilderManager,
ApplicationContextAware {
    private ApplicationContext applicationContext;

    public <T> T buildStructureQuery(RESTStructureQuery structureQuery, StructureQueryFormat<T> structureQueryFormat) {
        for (StructureQueryFactory currentFactory : this.applicationContext.getBeansOfType(StructureQueryFactory.class).values()) {
            StructureQueryBuilder builder = currentFactory.getStructureQueryBuilder(structureQueryFormat);
            if (builder == null) continue;
            return (T)builder.buildStructureQuery(structureQuery);
        }
        throw new SdmxUnauthorisedException("Unsupported StructureQueryFormat: " + structureQueryFormat);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

