/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.parameters.leaves;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.analysis.tabulardata.model.datatype.BooleanType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.DateType;
import org.gcube.data.analysis.tabulardata.model.datatype.GeometryType;
import org.gcube.data.analysis.tabulardata.model.datatype.IntegerType;
import org.gcube.data.analysis.tabulardata.model.datatype.NumericType;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDTypeValue;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TDTypeValueParameter
extends LeafParameter<TDTypeValue> {
    private static final List<DataType> DEFAULT_ALLOWED_DATA_TYPES = new ArrayList<DataType>();
    private List<DataType> allowedDataTypes = DEFAULT_ALLOWED_DATA_TYPES;

    public TDTypeValueParameter() {
    }

    public TDTypeValueParameter(String identifier, String name, String description, Cardinality cardinality) {
        super(identifier, name, description, cardinality);
    }

    public TDTypeValueParameter(String identifier, String name, String description, Cardinality cardinality, List<DataType> allowedDataTypes) {
        super(identifier, name, description, cardinality);
        this.allowedDataTypes = allowedDataTypes;
    }

    public List<DataType> getAllowedDataTypes() {
        return this.allowedDataTypes;
    }

    public void setAllowedDataTypes(List<DataType> allowedDataTypes) {
        this.allowedDataTypes = allowedDataTypes;
    }

    @Override
    public Class<TDTypeValue> getParameterType() {
        return TDTypeValue.class;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TDTypeValueParameter [allowedDataTypes=");
        builder.append(this.allowedDataTypes);
        builder.append(", getIdentifier()=");
        builder.append(this.getIdentifier());
        builder.append(", getName()=");
        builder.append(this.getName());
        builder.append(", getDescription()=");
        builder.append(this.getDescription());
        builder.append(", getCardinality()=");
        builder.append(this.getCardinality());
        builder.append("]");
        return builder.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.allowedDataTypes == null ? 0 : this.allowedDataTypes.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TDTypeValueParameter other = (TDTypeValueParameter)obj;
        return !(this.allowedDataTypes == null ? other.allowedDataTypes != null : !this.allowedDataTypes.equals(other.allowedDataTypes));
    }

    @Override
    public void validateValue(Object valueObject) throws Exception {
        super.validateValue(valueObject);
        TDTypeValue value = (TDTypeValue)valueObject;
        boolean ok = false;
        for (DataType type : this.allowedDataTypes) {
            if (!type.getClass().isInstance(value.getReturnedDataType())) continue;
            ok = true;
        }
        if (!ok) {
            throw new Exception(String.format("Invalid data type %s, allowed types are : %s.", value.getReturnedDataType(), this.allowedDataTypes));
        }
    }

    static {
        DEFAULT_ALLOWED_DATA_TYPES.add((DataType)new BooleanType());
        DEFAULT_ALLOWED_DATA_TYPES.add((DataType)new DateType());
        DEFAULT_ALLOWED_DATA_TYPES.add((DataType)new GeometryType());
        DEFAULT_ALLOWED_DATA_TYPES.add((DataType)new IntegerType());
        DEFAULT_ALLOWED_DATA_TYPES.add((DataType)new NumericType());
        DEFAULT_ALLOWED_DATA_TYPES.add((DataType)new TextType());
    }
}

