/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.operation.parameters.leaves;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.analysis.tabulardata.operation.parameters.Cardinality;
import org.gcube.data.analysis.tabulardata.operation.parameters.LeafParameter;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RegexpStringParameter
extends LeafParameter<String> {
    private String regexp = null;

    private RegexpStringParameter() {
    }

    public RegexpStringParameter(String identifier, String name, String description, Cardinality cardinality, String regexp) {
        super(identifier, name, description, cardinality);
        if (regexp == null || regexp.isEmpty()) {
            throw new IllegalArgumentException("Regexp cannot be null or empty");
        }
        this.regexp = regexp;
    }

    public String getRegexp() {
        return this.regexp;
    }

    @Override
    public Class<String> getParameterType() {
        return String.class;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.regexp == null ? 0 : this.regexp.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegexpStringParameter other = (RegexpStringParameter)obj;
        return !(this.regexp == null ? other.regexp != null : !this.regexp.equals(other.regexp));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RegexpStringParameter [getIdentifier()=");
        builder.append(this.getIdentifier());
        builder.append(", getName()=");
        builder.append(this.getName());
        builder.append(", getDescription()=");
        builder.append(this.getDescription());
        builder.append(", getCardinality()=");
        builder.append(this.getCardinality());
        builder.append(", getRegexp()=");
        builder.append(this.getRegexp());
        builder.append(", getParameterType()=");
        builder.append(this.getParameterType());
        builder.append("]");
        return builder.toString();
    }

    @Override
    public void validateValue(Object valueObj) throws Exception {
        super.validateValue(valueObj);
        String value = (String)valueObj;
        if (!value.matches(this.regexp)) {
            throw new Exception(String.format("Passed argument %s doesn't match regexp constraint %s", value, this.regexp));
        }
    }
}

