/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.sdmx.resources.sdmxml.schemas.v20.common.TextType;
import org.sdmx.resources.sdmxml.schemas.v21.common.DataType;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.TEXT_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxNotImplementedException;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.base.TextTypeWrapper;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.TextTypeWrapperImpl;
import org.sdmxsource.util.ObjectUtil;

public class TextTypeUtil {
    public static TEXT_TYPE getTextType(DataType.Enum txtBean) {
        if (txtBean == null) {
            return null;
        }
        switch (txtBean.intValue()) {
            case 2: {
                return TEXT_TYPE.ALPHA;
            }
            case 3: {
                return TEXT_TYPE.ALPHA_NUMERIC;
            }
            case 20: {
                return TEXT_TYPE.BASIC_TIME_PERIOD;
            }
            case 5: {
                return TEXT_TYPE.BIG_INTEGER;
            }
            case 12: {
                return TEXT_TYPE.BOOLEAN;
            }
            case 14: {
                return TEXT_TYPE.COUNT;
            }
            case 43: {
                return TEXT_TYPE.DATA_SET_REFERENCE;
            }
            case 33: {
                return TEXT_TYPE.DATE_TIME;
            }
            case 37: {
                return TEXT_TYPE.DAY;
            }
            case 9: {
                return TEXT_TYPE.DECIMAL;
            }
            case 11: {
                return TEXT_TYPE.DOUBLE;
            }
            case 39: {
                return TEXT_TYPE.DURATION;
            }
            case 16: {
                return TEXT_TYPE.EXCLUSIVE_VALUE_RANGE;
            }
            case 10: {
                return TEXT_TYPE.FLOAT;
            }
            case 24: {
                return TEXT_TYPE.GREGORIAN_DAY;
            }
            case 21: {
                return TEXT_TYPE.GREGORIAN_TIME_PERIOD;
            }
            case 22: {
                return TEXT_TYPE.GREGORIAN_YEAR;
            }
            case 23: {
                return TEXT_TYPE.GREGORIAN_YEAR_MONTH;
            }
            case 42: {
                return TEXT_TYPE.IDENTIFIABLE_REFERENCE;
            }
            case 15: {
                return TEXT_TYPE.INCLUSIVE_VALUE_RANGE;
            }
            case 17: {
                return TEXT_TYPE.INCREMENTAL;
            }
            case 6: {
                return TEXT_TYPE.INTEGER;
            }
            case 41: {
                return TEXT_TYPE.KEY_VALUES;
            }
            case 7: {
                return TEXT_TYPE.LONG;
            }
            case 35: {
                return TEXT_TYPE.MONTH;
            }
            case 36: {
                return TEXT_TYPE.MONTH_DAY;
            }
            case 4: {
                return TEXT_TYPE.NUMERIC;
            }
            case 18: {
                return TEXT_TYPE.OBSERVATIONAL_TIME_PERIOD;
            }
            case 32: {
                return TEXT_TYPE.REPORTING_DAY;
            }
            case 30: {
                return TEXT_TYPE.REPORTING_MONTH;
            }
            case 29: {
                return TEXT_TYPE.REPORTING_QUARTER;
            }
            case 27: {
                return TEXT_TYPE.REPORTING_SEMESTER;
            }
            case 25: {
                return TEXT_TYPE.REPORTING_TIME_PERIOD;
            }
            case 28: {
                return TEXT_TYPE.REPORTING_TRIMESTER;
            }
            case 31: {
                return TEXT_TYPE.REPORTING_WEEK;
            }
            case 26: {
                return TEXT_TYPE.REPORTING_YEAR;
            }
            case 8: {
                return TEXT_TYPE.SHORT;
            }
            case 19: {
                return TEXT_TYPE.STANDARD_TIME_PERIOD;
            }
            case 1: {
                return TEXT_TYPE.STRING;
            }
            case 38: {
                return TEXT_TYPE.TIME;
            }
            case 34: {
                return TEXT_TYPE.TIMES_RANGE;
            }
            case 13: {
                return TEXT_TYPE.URI;
            }
            case 40: {
                return TEXT_TYPE.XHTML;
            }
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{txtBean});
    }

    public static List<TextTypeWrapper> wrapTextTypeV1(List<org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.common.TextType> textTypeList, SDMXBean parent) {
        ArrayList<TextTypeWrapper> returnList = new ArrayList<TextTypeWrapper>();
        if (textTypeList != null) {
            for (org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.common.TextType currentTextType : textTypeList) {
                if (!ObjectUtil.validString((String[])new String[]{currentTextType.getStringValue()})) continue;
                returnList.add(new TextTypeWrapperImpl(currentTextType, parent));
            }
        }
        return returnList;
    }

    public static List<TextTypeWrapper> wrapTextTypeV21(List<org.sdmx.resources.sdmxml.schemas.v21.common.TextType> textTypeList, SDMXBean parent) {
        ArrayList<TextTypeWrapper> returnList = new ArrayList<TextTypeWrapper>();
        if (textTypeList != null) {
            for (org.sdmx.resources.sdmxml.schemas.v21.common.TextType currentTextType : textTypeList) {
                if (!ObjectUtil.validString((String[])new String[]{currentTextType.getStringValue()})) continue;
                returnList.add(new TextTypeWrapperImpl(currentTextType, parent));
            }
        }
        return returnList;
    }

    public static List<TextTypeWrapper> wrapTextTypeV2(List<TextType> textTypeList, SDMXBean parent) {
        ArrayList<TextTypeWrapper> returnList = new ArrayList<TextTypeWrapper>();
        if (textTypeList != null) {
            for (TextType currentTextType : textTypeList) {
                if (!ObjectUtil.validString((String[])new String[]{currentTextType.getStringValue()})) continue;
                returnList.add(new TextTypeWrapperImpl(currentTextType, parent));
            }
        }
        return returnList;
    }

    public static TextType[] unwrapTextType(List<TextTypeWrapper> text) {
        TextType[] textType = new TextType[text.size()];
        for (int i = 0; i < text.size(); ++i) {
            TextTypeWrapper currentWrapper = text.get(i);
            TextType type = TextType.Factory.newInstance();
            type.setLang(currentWrapper.getLocale());
            type.setStringValue(currentWrapper.getValue());
            textType[i] = type;
        }
        return textType;
    }

    public static TextTypeWrapper getDefaultLocale(List<TextTypeWrapper> textTypes) {
        Iterator<TextTypeWrapper> i$;
        if (ObjectUtil.validCollection(textTypes) && (i$ = textTypes.iterator()).hasNext()) {
            TextTypeWrapper tt = i$.next();
            return tt;
        }
        return null;
    }
}

