/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.util;

import java.util.ArrayList;
import java.util.List;
import org.sdmx.resources.sdmxml.schemas.v20.structure.CategoryIDType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.CategoryRefType;
import org.sdmx.resources.sdmxml.schemas.v21.common.LocalDimensionReferenceType;
import org.sdmx.resources.sdmxml.schemas.v21.common.LocalGroupKeyDescriptorReferenceType;
import org.sdmx.resources.sdmxml.schemas.v21.common.LocalIdentifiableReferenceType;
import org.sdmx.resources.sdmxml.schemas.v21.common.LocalLevelReferenceType;
import org.sdmx.resources.sdmxml.schemas.v21.common.LocalMetadataTargetReferenceType;
import org.sdmx.resources.sdmxml.schemas.v21.common.LocalPrimaryMeasureReferenceType;
import org.sdmx.resources.sdmxml.schemas.v21.common.RefBaseType;
import org.sdmx.resources.sdmxml.schemas.v21.common.ReferenceType;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.util.beans.reference.CrossReferenceBeanImpl;
import org.sdmxsource.sdmx.util.beans.reference.StructureReferenceBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class RefUtil {
    public static String createLocalIdReference(LocalMetadataTargetReferenceType localReference) {
        RefBaseType ref = localReference.getRef();
        return ref.getId();
    }

    public static String createLocalIdReference(LocalLevelReferenceType localReference) {
        RefBaseType ref = localReference.getRef();
        return ref.getId();
    }

    public static String createLocalIdReference(LocalIdentifiableReferenceType localReference) {
        RefBaseType ref = localReference.getRef();
        return ref.getId();
    }

    public static String createLocalIdReference(LocalGroupKeyDescriptorReferenceType localReference) {
        RefBaseType ref = localReference.getRef();
        return ref.getId();
    }

    public static String createLocalIdReference(LocalDimensionReferenceType localReference) {
        RefBaseType ref = localReference.getRef();
        return ref.getId();
    }

    public static String createLocalIdReference(LocalPrimaryMeasureReferenceType localReference) {
        RefBaseType ref = localReference.getRef();
        return ref.getId();
    }

    public static StructureReferenceBean createReference(ReferenceType objectReference) {
        if (objectReference.getURN() != null) {
            return new StructureReferenceBeanImpl(objectReference.getURN());
        }
        if (objectReference.getRef() == null) {
            throw new SdmxSemmanticException("Illegal Reference : ObjectReference does not contain URN or Ref");
        }
        RefBaseType ref = objectReference.getRef();
        SDMX_STRUCTURE_TYPE referencedStructure = SDMX_STRUCTURE_TYPE.parseClass((String)ref.getClass1().toString());
        if (!referencedStructure.getUrnPackage().equals(ref.getPackage().toString())) {
            throw new SdmxSemmanticException(referencedStructure.getType() + " is not in package " + (Object)((Object)ref.getPackage()));
        }
        RefBaseType refBase = objectReference.getRef();
        boolean hasContainer = ObjectUtil.validString((String[])new String[]{refBase.getContainerID()});
        String version = null;
        String maintainableId = null;
        String[] identifiableId = null;
        boolean hasIdentifiable = false;
        if (refBase.getMaintainableParentID() == null) {
            maintainableId = refBase.getId();
            version = refBase.getVersion();
        } else {
            maintainableId = refBase.getMaintainableParentID();
            hasIdentifiable = ObjectUtil.validString((String[])new String[]{refBase.getId()});
            version = refBase.getMaintainableParentVersion();
        }
        if (hasIdentifiable) {
            if (hasContainer) {
                String containerId = refBase.getContainerID();
                String[] id = refBase.getId().split("\\.");
                identifiableId = new String[id.length + 1];
                identifiableId[0] = containerId;
                for (int i = 0; i < id.length; ++i) {
                    identifiableId[i + 1] = id[i];
                }
            } else {
                identifiableId = refBase.getId().split("\\.");
            }
        }
        SDMX_STRUCTURE_TYPE referencedStructure2 = SDMX_STRUCTURE_TYPE.parsePackageAndClass((String)refBase.getPackage().toString(), (String)refBase.getClass1().toString());
        StructureReferenceBeanImpl sRef = new StructureReferenceBeanImpl(refBase.getAgencyID(), maintainableId, version, referencedStructure2, identifiableId);
        return sRef;
    }

    public static CrossReferenceBean createReference(SDMXBean referencedFrom, ReferenceType objectReference) {
        return new CrossReferenceBeanImpl(referencedFrom, RefUtil.createReference(objectReference));
    }

    public static CrossReferenceBean createCategoryRef(SDMXBean referencedFrom, CategoryRefType ref) {
        if (ObjectUtil.validString((String[])new String[]{ref.getURN()})) {
            return new CrossReferenceBeanImpl(referencedFrom, ref.getURN());
        }
        ArrayList<String> catId = new ArrayList<String>();
        String catSchemeAgencyId = ref.getCategorySchemeAgencyID();
        String catSchemeId = ref.getCategorySchemeID();
        String catSchemeVersion = ref.getCategorySchemeVersion();
        if (ref.getCategoryID() != null) {
            RefUtil.getCateogryIds(catId, ref.getCategoryID());
        }
        String[] catIds = new String[catId.size()];
        catId.toArray(catIds);
        return new CrossReferenceBeanImpl(referencedFrom, catSchemeAgencyId, catSchemeId, catSchemeVersion, SDMX_STRUCTURE_TYPE.CATEGORY, catIds);
    }

    private static void getCateogryIds(List<String> list, CategoryIDType idType) {
        list.add(idType.getID());
        if (idType.getCategoryID() != null) {
            RefUtil.getCateogryIds(list, idType.getCategoryID());
        }
    }
}

