/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.mutable.registry;

import java.util.ArrayList;
import java.util.List;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.registry.SubscriptionBean;
import org.sdmxsource.sdmx.api.model.mutable.registry.SubscriptionMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.registry.SubscriptionBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.base.MaintainableMutableBeanImpl;

public class SubscriptionMutableBeanImpl
extends MaintainableMutableBeanImpl
implements SubscriptionMutableBean {
    private static final long serialVersionUID = 1L;
    private StructureReferenceBean owner;
    private List<String> mailTo = new ArrayList<String>();
    private List<String> HTTPPostTo = new ArrayList<String>();
    private List<StructureReferenceBean> references = new ArrayList<StructureReferenceBean>();
    private SubscriptionBean.SUBSCRIPTION_TYPE subscriptionType;

    public SubscriptionMutableBeanImpl() {
        super(SDMX_STRUCTURE_TYPE.SUBSCRIPTION);
    }

    public SubscriptionMutableBeanImpl(SubscriptionBean subscriptionBean) {
        super((MaintainableBean)subscriptionBean);
        if (subscriptionBean.getHTTPPostTo() != null) {
            this.HTTPPostTo = new ArrayList<String>(subscriptionBean.getHTTPPostTo());
        }
        if (subscriptionBean.getMailTo() != null) {
            this.mailTo = new ArrayList<String>(subscriptionBean.getMailTo());
        }
        if (subscriptionBean.getReferences() != null) {
            for (StructureReferenceBean sRef : subscriptionBean.getReferences()) {
                this.references.add(sRef.createCopy());
            }
        }
        this.structureType = subscriptionBean.getStructureType();
        this.owner = subscriptionBean.getOwner().createMutableInstance();
        this.subscriptionType = subscriptionBean.getSubscriptionType();
    }

    public StructureReferenceBean getOwner() {
        return this.owner;
    }

    public void setOwner(StructureReferenceBean owner) {
        this.owner = owner;
    }

    public List<String> getMailTo() {
        return this.mailTo;
    }

    public void setMailTo(List<String> mailTo) {
        this.mailTo = mailTo;
    }

    public List<String> getHTTPPostTo() {
        return this.HTTPPostTo;
    }

    public void setHTTPPostTo(List<String> hTTPPostTo) {
        this.HTTPPostTo = hTTPPostTo;
    }

    public void addReference(StructureReferenceBean reference) {
        if (this.references == null) {
            this.references = new ArrayList<StructureReferenceBean>();
        }
        this.references.add(reference);
    }

    public List<StructureReferenceBean> getReferences() {
        return this.references;
    }

    public void setReferences(List<StructureReferenceBean> references) {
        this.references = references;
    }

    public SubscriptionBean.SUBSCRIPTION_TYPE getSubscriptionType() {
        return this.subscriptionType;
    }

    public void setSubscriptionType(SubscriptionBean.SUBSCRIPTION_TYPE subscriptionType) {
        this.subscriptionType = subscriptionType;
    }

    public SubscriptionBean getImmutableInstance() {
        return new SubscriptionBeanImpl(this);
    }
}

