/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.mutable.registry;

import java.util.ArrayList;
import java.util.List;
import org.sdmx.resources.sdmxml.schemas.v21.common.ComponentValueSetType;
import org.sdmx.resources.sdmxml.schemas.v21.common.SimpleValueType;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.model.beans.registry.KeyValues;
import org.sdmxsource.sdmx.api.model.mutable.base.TimeRangeMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.registry.KeyValuesMutable;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.base.MutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.base.TimeRangeMutableBeanImpl;

public class KeyValuesMutableImpl
extends MutableBeanImpl
implements KeyValuesMutable {
    private static final long serialVersionUID = 1L;
    private String id;
    private List<String> values = new ArrayList<String>();
    private List<String> cascadeList = new ArrayList<String>();
    private TimeRangeMutableBean timeRangeBean;

    public KeyValuesMutableImpl() {
        super(SDMX_STRUCTURE_TYPE.KEY_VALUES);
    }

    public KeyValuesMutableImpl(KeyValues immutable) {
        super(SDMX_STRUCTURE_TYPE.KEY_VALUES);
        this.id = immutable.getId();
        this.values.addAll(immutable.getValues());
        for (String each : this.values) {
            if (!immutable.isCascadeValue(each)) continue;
            this.cascadeList.add(each);
        }
        if (immutable.getTimeRange() != null) {
            this.timeRangeBean = new TimeRangeMutableBeanImpl(immutable.getTimeRange());
        }
    }

    public KeyValuesMutableImpl(ComponentValueSetType keyValueType) {
        super(SDMX_STRUCTURE_TYPE.KEY_VALUES);
        this.id = keyValueType.getId();
        if (keyValueType.getValueList() != null) {
            for (SimpleValueType dataKeyType : keyValueType.getValueList()) {
                this.values.add(dataKeyType.getStringValue());
                if (!dataKeyType.getCascadeValues()) continue;
                this.cascadeList.add(dataKeyType.getStringValue());
            }
        }
        if (keyValueType.getTimeRange() != null) {
            this.timeRangeBean = new TimeRangeMutableBeanImpl(keyValueType.getTimeRange());
        }
    }

    public String getId() {
        return this.id;
    }

    public List<String> getCascade() {
        return this.cascadeList;
    }

    public void setCascade(List<String> cascadeValues) {
        this.cascadeList = cascadeValues;
    }

    public void addCascade(String value) {
        if (this.cascadeList == null) {
            this.cascadeList = new ArrayList<String>();
        }
        this.cascadeList.add(value);
    }

    public boolean isCascadeValue(String value) {
        return this.cascadeList.contains(value);
    }

    public TimeRangeMutableBean getTimeRange() {
        return this.timeRangeBean;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<String> getKeyValues() {
        return this.values;
    }

    public void setKeyValues(List<String> kv) {
        this.values = kv;
    }

    public void addValue(String value) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        if (value != null) {
            this.values.add(value);
        }
    }

    public void setTimeRange(TimeRangeMutableBean timeRange) {
        this.timeRangeBean = timeRange;
    }
}

