/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.mutable.base;

import java.util.Date;
import org.sdmx.resources.sdmxml.schemas.v21.common.TimeRangeValueType;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.base.SdmxStructureBean;
import org.sdmxsource.sdmx.api.model.beans.base.TimeRangeBean;
import org.sdmxsource.sdmx.api.model.mutable.base.TimeRangeMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.TimeRangeBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.base.MutableBeanImpl;
import org.sdmxsource.sdmx.util.date.DateUtil;

public class TimeRangeMutableBeanImpl
extends MutableBeanImpl
implements TimeRangeMutableBean {
    private static final long serialVersionUID = -1105081442071478375L;
    private Date startDate;
    private Date endDate;
    private boolean isRange;
    private boolean isStartInclusive;
    private boolean isEndInclusive;

    public TimeRangeMutableBeanImpl() {
        super(SDMX_STRUCTURE_TYPE.TIME_RANGE);
    }

    public TimeRangeMutableBeanImpl(TimeRangeBean immutable) {
        super(SDMX_STRUCTURE_TYPE.TIME_RANGE);
        if (immutable.getStartDate() != null) {
            this.startDate = immutable.getStartDate().getDate();
        }
        if (immutable.getEndDate() != null) {
            this.endDate = immutable.getEndDate().getDate();
        }
        this.isRange = immutable.isRange();
        this.isStartInclusive = immutable.isStartInclusive();
        this.isEndInclusive = immutable.isEndInclusive();
    }

    public TimeRangeMutableBeanImpl(TimeRangeValueType type) {
        super(SDMX_STRUCTURE_TYPE.TIME_RANGE);
        if (type.getAfterPeriod() != null) {
            this.isRange = false;
            this.endDate = DateUtil.formatDate((Object)type.getAfterPeriod().getObjectValue(), (boolean)true);
            this.isEndInclusive = type.getAfterPeriod().getIsInclusive();
        }
        if (type.getBeforePeriod() != null) {
            this.isRange = false;
            this.startDate = DateUtil.formatDate((Object)type.getBeforePeriod().getObjectValue(), (boolean)true);
            this.isStartInclusive = type.getBeforePeriod().getIsInclusive();
        }
        if (type.getStartPeriod() != null) {
            this.isRange = true;
            this.startDate = DateUtil.formatDate((Object)type.getStartPeriod().getObjectValue(), (boolean)true);
            this.isStartInclusive = type.getStartPeriod().getIsInclusive();
        }
        if (type.getEndPeriod() != null) {
            this.isRange = true;
            this.startDate = DateUtil.formatDate((Object)type.getEndPeriod().getObjectValue(), (boolean)true);
            this.isEndInclusive = type.getEndPeriod().getIsInclusive();
        }
        this.validate();
    }

    private void validate() throws SdmxSemmanticException {
        if (this.startDate == null && this.endDate == null) {
            throw new SdmxSemmanticException("Time period must define at least one date");
        }
        if (this.isRange) {
            if (this.startDate == null || this.endDate == null) {
                throw new SdmxSemmanticException("Time period with a range requires both a start and end period");
            }
            if (this.startDate.getTime() > this.endDate.getTime()) {
                throw new SdmxSemmanticException("Time range can not specify start period after end period");
            }
        } else if (this.startDate != null && this.endDate != null) {
            throw new SdmxSemmanticException("Time period can not define both a before period and after period");
        }
    }

    public boolean isRange() {
        return this.isRange;
    }

    public void setIsRange(boolean isRange) {
        this.isRange = isRange;
    }

    public Date getStartDate() {
        if (this.startDate != null) {
            return new Date(this.startDate.getTime());
        }
        return null;
    }

    public Date getEndDate() {
        if (this.endDate != null) {
            return new Date(this.endDate.getTime());
        }
        return null;
    }

    public boolean isStartInclusive() {
        return this.isStartInclusive;
    }

    public boolean isEndInclusive() {
        return this.isEndInclusive;
    }

    public void setStartDate(Date start) {
        this.startDate = start;
    }

    public void setEndDate(Date end) {
        this.endDate = end;
    }

    public void setIsStartInclusive(boolean includeStart) {
        this.isStartInclusive = includeStart;
    }

    public void setIsEndInclusive(boolean includeEnd) {
        this.isEndInclusive = includeEnd;
    }

    public TimeRangeBean createImmutableInstance(SdmxStructureBean parent) {
        return new TimeRangeBeanImpl(this, parent);
    }
}

