/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.header;

import java.io.Serializable;
import java.util.UUID;
import org.sdmx.resources.sdmxml.schemas.v21.common.PayloadStructureType;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.header.DatasetStructureReferenceBean;
import org.sdmxsource.sdmx.sdmxbeans.util.RefUtil;
import org.sdmxsource.util.ObjectUtil;

public class DatasetStructureReferenceBeanImpl
implements DatasetStructureReferenceBean,
Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private StructureReferenceBean structureReference;
    private String serviceURL;
    private String structureURL;
    private String dimensionAtObservation = "TIME_PERIOD";

    public DatasetStructureReferenceBeanImpl(StructureReferenceBean structureReference) {
        this.structureReference = structureReference;
        this.validate();
    }

    public DatasetStructureReferenceBeanImpl(String id, StructureReferenceBean structureReference, String serviceURL, String structureURL, String dimensionAtObservation) {
        this.id = id;
        this.structureReference = structureReference;
        this.serviceURL = serviceURL;
        this.structureURL = structureURL;
        if (ObjectUtil.validString((String[])new String[]{dimensionAtObservation})) {
            this.dimensionAtObservation = dimensionAtObservation;
        }
        this.validate();
    }

    public DatasetStructureReferenceBeanImpl(PayloadStructureType payloadSt) {
        if (payloadSt.getProvisionAgrement() != null) {
            this.structureReference = RefUtil.createReference(payloadSt.getProvisionAgrement());
        } else if (payloadSt.getStructureUsage() != null) {
            this.structureReference = RefUtil.createReference(payloadSt.getStructureUsage());
        } else if (payloadSt.getStructure() != null) {
            this.structureReference = RefUtil.createReference(payloadSt.getStructure());
        }
        this.id = payloadSt.getStructureID();
        this.serviceURL = payloadSt.getServiceURL();
        this.structureURL = payloadSt.getStructureURL();
        this.dimensionAtObservation = payloadSt.getDimensionAtObservation();
        this.validate();
    }

    public String getId() {
        return this.id;
    }

    public String getServiceURL() {
        return this.serviceURL;
    }

    public String getStructureURL() {
        return this.structureURL;
    }

    public String getDimensionAtObservation() {
        return this.dimensionAtObservation;
    }

    public StructureReferenceBean getStructureReference() {
        return this.structureReference;
    }

    public boolean isTimeSeries() {
        return this.dimensionAtObservation.equals("TIME_PERIOD");
    }

    public void validate() throws SdmxSemmanticException {
        if (!ObjectUtil.validString((String[])new String[]{this.id})) {
            this.id = UUID.randomUUID().toString();
        }
        if (this.structureReference == null) {
            throw new SdmxSemmanticException("Header 'Structure' missing Structure Reference");
        }
        if (this.dimensionAtObservation == null) {
            this.dimensionAtObservation = "TIME_PERIOD";
        }
    }
}

