/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.registry;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.sdmx.resources.sdmxml.schemas.v21.common.ReferenceType;
import org.sdmx.resources.sdmxml.schemas.v21.registry.DataRegistrationEventsType;
import org.sdmx.resources.sdmxml.schemas.v21.registry.EventSelectorType;
import org.sdmx.resources.sdmxml.schemas.v21.registry.MaintainableEventType;
import org.sdmx.resources.sdmxml.schemas.v21.registry.MaintainableQueryType;
import org.sdmx.resources.sdmxml.schemas.v21.registry.MetadataRegistrationEventsType;
import org.sdmx.resources.sdmxml.schemas.v21.registry.NotificationURLType;
import org.sdmx.resources.sdmxml.schemas.v21.registry.StructuralRepositoryEventsType;
import org.sdmx.resources.sdmxml.schemas.v21.registry.SubscriptionType;
import org.sdmx.resources.sdmxml.schemas.v21.registry.VersionableObjectEventType;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.constants.TERTIARY_BOOL;
import org.sdmxsource.sdmx.api.constants.TIME_FORMAT;
import org.sdmxsource.sdmx.api.exception.SdmxNotImplementedException;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.registry.SubscriptionBean;
import org.sdmxsource.sdmx.api.model.mutable.base.MaintainableMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.registry.SubscriptionMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.MaintainableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.SdmxDateImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.registry.SubscriptionMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.util.RefUtil;
import org.sdmxsource.sdmx.util.beans.reference.CrossReferenceBeanImpl;
import org.sdmxsource.sdmx.util.beans.reference.StructureReferenceBeanImpl;
import org.sdmxsource.util.ObjectUtil;
import org.sdmxsource.util.email.EmailValidation;

public class SubscriptionBeanImpl
extends MaintainableBeanImpl
implements SubscriptionBean {
    private static Logger LOG = Logger.getLogger(SubscriptionBeanImpl.class);
    private static final long serialVersionUID = 6358405744989772694L;
    private CrossReferenceBean owner;
    private List<String> mailTo = new ArrayList<String>();
    private List<String> HTTPPostTo = new ArrayList<String>();
    private List<StructureReferenceBean> references = new ArrayList<StructureReferenceBean>();
    private SubscriptionBean.SUBSCRIPTION_TYPE subscriptionType;

    private SubscriptionBeanImpl(SubscriptionBean bean, URL actualLocation, boolean isServiceUrl) {
        super((MaintainableBean)bean, actualLocation, isServiceUrl);
    }

    public SubscriptionBeanImpl(SubscriptionMutableBean mutableBean) {
        super((MaintainableMutableBean)mutableBean);
        LOG.debug((Object)"Building Subscription from Mutable Bean");
        if (mutableBean.getOwner() != null) {
            this.owner = new CrossReferenceBeanImpl((SDMXBean)this, mutableBean.getOwner());
        }
        if (mutableBean.getMailTo() != null) {
            this.mailTo = new ArrayList<String>(mutableBean.getMailTo());
        }
        if (mutableBean.getHTTPPostTo() != null) {
            this.HTTPPostTo = new ArrayList<String>(mutableBean.getHTTPPostTo());
        }
        if (mutableBean.getReferences() != null) {
            for (StructureReferenceBean ref : mutableBean.getReferences()) {
                this.references.add(ref.createCopy());
            }
        }
        this.subscriptionType = mutableBean.getSubscriptionType();
        this.validate();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("subscription Built " + this.getUrn()));
        }
    }

    private static String getSubAgencyId(SubscriptionType subscription) {
        return RefUtil.createReference(subscription.getOrganisation()).getMaintainableReference().getAgencyId();
    }

    private static String getSubId(SubscriptionType subscription) {
        if (ObjectUtil.validString((String[])new String[]{subscription.getSubscriberAssignedID()})) {
            return subscription.getSubscriberAssignedID();
        }
        return "Generated_" + System.currentTimeMillis();
    }

    public SubscriptionBeanImpl(SubscriptionType subscription) {
        super(subscription, SDMX_STRUCTURE_TYPE.SUBSCRIPTION, null, null, "1.0", TERTIARY_BOOL.UNSET, SubscriptionBeanImpl.getSubAgencyId(subscription), SubscriptionBeanImpl.getSubId(subscription), null, null, null, null, null);
        LOG.debug((Object)"Building Subscription from 2.1 SDMX");
        if (subscription.getOrganisation() != null) {
            this.owner = RefUtil.createReference(this, subscription.getOrganisation());
        }
        if (subscription.getValidityPeriod() != null) {
            if (subscription.getValidityPeriod().getStartDate() != null) {
                this.startDate = new SdmxDateImpl(subscription.getValidityPeriod().getStartDate().getTime(), TIME_FORMAT.DATE_TIME);
            }
            if (subscription.getValidityPeriod().getEndDate() != null) {
                this.endDate = new SdmxDateImpl(subscription.getValidityPeriod().getEndDate().getTime(), TIME_FORMAT.DATE_TIME);
            }
        }
        if (subscription.getNotificationHTTPList() != null) {
            for (NotificationURLType not : subscription.getNotificationHTTPList()) {
                this.HTTPPostTo.add(not.getStringValue());
            }
        }
        if (subscription.getNotificationMailToList() != null) {
            for (NotificationURLType not : subscription.getNotificationMailToList()) {
                this.mailTo.add(not.getStringValue());
            }
        }
        if (subscription.getEventSelector() != null) {
            EventSelectorType eventSelector = subscription.getEventSelector();
            for (StructuralRepositoryEventsType structuralRepositoryEventsType : eventSelector.getStructuralRepositoryEventsList()) {
                this.setSubscriptionType(SubscriptionBean.SUBSCRIPTION_TYPE.STRUCTURE);
                List<String> agencies = structuralRepositoryEventsType.getAgencyIDList();
                for (String currentAgency : agencies) {
                    if (!currentAgency.equals("%")) continue;
                    agencies = null;
                    break;
                }
                if (structuralRepositoryEventsType.getAllEvents() != null) {
                    if (!ObjectUtil.validCollection(agencies)) {
                        this.references.add((StructureReferenceBean)new StructureReferenceBeanImpl(null, null, null, SDMX_STRUCTURE_TYPE.ANY, new String[0]));
                        break;
                    }
                    for (String currentAgency : agencies) {
                        this.references.add((StructureReferenceBean)new StructureReferenceBeanImpl(currentAgency, null, null, SDMX_STRUCTURE_TYPE.ANY, new String[0]));
                    }
                    break;
                }
                this.addEventSubscriptions(structuralRepositoryEventsType.getAgencySchemeList(), agencies, SDMX_STRUCTURE_TYPE.AGENCY_SCHEME);
                this.addEventSubscriptions(structuralRepositoryEventsType.getAttachmentConstraintList(), agencies, SDMX_STRUCTURE_TYPE.ATTACHMENT_CONSTRAINT);
                this.addEventSubscriptions(structuralRepositoryEventsType.getCategorySchemeList(), agencies, SDMX_STRUCTURE_TYPE.CATEGORY_SCHEME);
                this.addEventSubscriptions(structuralRepositoryEventsType.getCodelistList(), agencies, SDMX_STRUCTURE_TYPE.CODE_LIST);
                this.addEventSubscriptions(structuralRepositoryEventsType.getConceptSchemeList(), agencies, SDMX_STRUCTURE_TYPE.CONCEPT_SCHEME);
                this.addEventSubscriptions(structuralRepositoryEventsType.getContentConstraintList(), agencies, SDMX_STRUCTURE_TYPE.CONTENT_CONSTRAINT);
                this.addEventSubscriptions(structuralRepositoryEventsType.getDataProviderSchemeList(), agencies, SDMX_STRUCTURE_TYPE.DATA_PROVIDER_SCHEME);
                this.addEventSubscriptions(structuralRepositoryEventsType.getDataConsmerSchemeList(), agencies, SDMX_STRUCTURE_TYPE.DATA_CONSUMER_SCHEME);
                this.addEventSubscriptions(structuralRepositoryEventsType.getDataflowList(), agencies, SDMX_STRUCTURE_TYPE.DATAFLOW);
                this.addEventSubscriptions(structuralRepositoryEventsType.getHierarchicalCodelistList(), agencies, SDMX_STRUCTURE_TYPE.HIERARCHICAL_CODELIST);
                this.addEventSubscriptions(structuralRepositoryEventsType.getKeyFamilyList(), agencies, SDMX_STRUCTURE_TYPE.DSD);
                this.addEventSubscriptions(structuralRepositoryEventsType.getMetadataflowList(), agencies, SDMX_STRUCTURE_TYPE.METADATA_FLOW);
                this.addEventSubscriptions(structuralRepositoryEventsType.getMetadataStructureDefinitionList(), agencies, SDMX_STRUCTURE_TYPE.MSD);
                this.addEventSubscriptions(structuralRepositoryEventsType.getOrganisationUnitSchemeList(), agencies, SDMX_STRUCTURE_TYPE.ORGANISATION_UNIT_SCHEME);
                this.addEventSubscriptions(structuralRepositoryEventsType.getProcessList(), agencies, SDMX_STRUCTURE_TYPE.PROCESS);
                this.addEventSubscriptions(structuralRepositoryEventsType.getProvisionAgreementList(), agencies, SDMX_STRUCTURE_TYPE.PROVISION_AGREEMENT);
                this.addEventSubscriptions(structuralRepositoryEventsType.getReportingTaxonomyList(), agencies, SDMX_STRUCTURE_TYPE.REPORTING_TAXONOMY);
                this.addEventSubscriptions(structuralRepositoryEventsType.getStructureSetList(), agencies, SDMX_STRUCTURE_TYPE.STRUCTURE_SET);
            }
            for (DataRegistrationEventsType dataRegistrationEventsType : eventSelector.getDataRegistrationEventsList()) {
                this.setSubscriptionType(SubscriptionBean.SUBSCRIPTION_TYPE.DATA_REGISTRATION);
                if (dataRegistrationEventsType.getAllEvents() != null) {
                    this.references.add((StructureReferenceBean)new StructureReferenceBeanImpl(SDMX_STRUCTURE_TYPE.ANY));
                    break;
                }
                this.addEventSubscriptions(dataRegistrationEventsType.getDataflowReferenceList(), SDMX_STRUCTURE_TYPE.DATAFLOW);
                this.addEventSubscriptions(dataRegistrationEventsType.getKeyFamilyReferenceList(), SDMX_STRUCTURE_TYPE.DSD);
                this.addEventSubscriptions(dataRegistrationEventsType.getProvisionAgreementList());
                this.addEventSubscriptions(dataRegistrationEventsType.getCategoryList());
                this.addEventSubscriptions(dataRegistrationEventsType.getDataProviderList());
            }
            for (MetadataRegistrationEventsType metadataRegistrationEventsType : eventSelector.getMetadataRegistrationEventsList()) {
                this.setSubscriptionType(SubscriptionBean.SUBSCRIPTION_TYPE.METADATA_REGISTRATION);
                if (metadataRegistrationEventsType.getAllEvents() != null) {
                    this.references.add((StructureReferenceBean)new StructureReferenceBeanImpl(SDMX_STRUCTURE_TYPE.ANY));
                    break;
                }
                this.addEventSubscriptions(metadataRegistrationEventsType.getMetadataflowReferenceList(), SDMX_STRUCTURE_TYPE.METADATA_FLOW);
                this.addEventSubscriptions(metadataRegistrationEventsType.getMetadataStructureDefinitionReferenceList(), SDMX_STRUCTURE_TYPE.MSD);
                this.addEventSubscriptions(metadataRegistrationEventsType.getProvisionAgreementList());
                this.addEventSubscriptions(metadataRegistrationEventsType.getCategoryList());
                this.addEventSubscriptions(metadataRegistrationEventsType.getDataProviderList());
            }
        }
        this.validate();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("subscription Built " + this.getUrn()));
        }
    }

    private void addEventSubscriptions(List<VersionableObjectEventType> events, List<String> agencyIds, SDMX_STRUCTURE_TYPE structureType) {
        for (VersionableObjectEventType vot : events) {
            if (ObjectUtil.validString((String[])new String[]{vot.getURN()})) {
                this.references.add((StructureReferenceBean)new StructureReferenceBeanImpl(vot.getURN()));
                continue;
            }
            String id = vot.getID();
            String version = vot.getVersion();
            if (id != null && id.equals("%")) {
                id = null;
            }
            if (version != null && version.equals("%")) {
                version = null;
            }
            if (ObjectUtil.validCollection(agencyIds)) {
                for (String agencyId : agencyIds) {
                    this.references.add((StructureReferenceBean)new StructureReferenceBeanImpl(agencyId, id, version, structureType, new String[0]));
                }
                continue;
            }
            this.references.add((StructureReferenceBean)new StructureReferenceBeanImpl(null, id, version, structureType, new String[0]));
        }
    }

    private void addEventSubscriptions(List<MaintainableEventType> events, SDMX_STRUCTURE_TYPE structureType) {
        for (MaintainableEventType event : events) {
            if (ObjectUtil.validString((String[])new String[]{event.getURN()})) {
                this.references.add((StructureReferenceBean)new StructureReferenceBeanImpl(event.getURN()));
                continue;
            }
            MaintainableQueryType queryType = event.getRef();
            this.references.add((StructureReferenceBean)new StructureReferenceBeanImpl(queryType.getAgencyID(), queryType.getId(), queryType.getVersion(), structureType, new String[0]));
        }
    }

    private void addEventSubscriptions(List<? extends ReferenceType> events) {
        for (ReferenceType referenceType : events) {
            this.references.add((StructureReferenceBean)RefUtil.createReference(this, referenceType));
        }
    }

    private void setSubscriptionType(SubscriptionBean.SUBSCRIPTION_TYPE type) {
        if (this.subscriptionType != null && this.subscriptionType != type) {
            throw new SdmxSemmanticException("Subscription can not be for more then one event type (structure event, registration event or a provision event)");
        }
        this.subscriptionType = type;
    }

    private void validate() throws SdmxSemmanticException {
        if (this.isFinal.isTrue()) {
            throw new SdmxSemmanticException("Subscription can not be made final");
        }
        if (!this.getVersion().equals("1.0")) {
            throw new SdmxSemmanticException("Subscription can not have a version, other then the default version : 1.0");
        }
        if (this.owner == null) {
            throw new SdmxSemmanticException("Subscription must have an owner which must be a data consumer - no owner provided");
        }
        if (this.owner.getTargetReference() != SDMX_STRUCTURE_TYPE.DATA_CONSUMER && this.owner.getTargetReference() != SDMX_STRUCTURE_TYPE.DATA_PROVIDER && this.owner.getTargetReference() != SDMX_STRUCTURE_TYPE.AGENCY) {
            throw new SdmxSemmanticException("Subscription must have an owner which must be an agency, data provider, or data consumer - " + this.owner.getTargetReference().getType() + " was provided");
        }
        if (this.mailTo.size() == 0 && this.HTTPPostTo.size() == 0) {
            throw new SdmxSemmanticException("Subscription must declare at least one HTTP POST to, or mail to address to send notifications to");
        }
        for (String currentEmail : this.mailTo) {
            if (EmailValidation.validateEmail((String)currentEmail)) continue;
            throw new SdmxSemmanticException("'" + currentEmail + "' is not a valid email address");
        }
        for (String currentHttp : this.HTTPPostTo) {
            try {
                new URL(currentHttp);
            }
            catch (MalformedURLException e) {
                throw new SdmxSemmanticException("'" + currentHttp + "' is not a valid URL");
            }
        }
        if (this.references.size() == 0) {
            this.references.add((StructureReferenceBean)new StructureReferenceBeanImpl(SDMX_STRUCTURE_TYPE.ANY));
        }
        if (this.subscriptionType == null) {
            throw new SdmxSemmanticException("Subscription type not declared");
        }
        this.agencyId = this.owner.getMaintainableReference().getAgencyId();
        super.validateAgencyId();
    }

    @Override
    protected void validateAgencyId() {
    }

    @Override
    public boolean deepEquals(SDMXBean bean, boolean includeFinalProperties) {
        throw new SdmxNotImplementedException("deepEquals on subscription");
    }

    public MaintainableBean getStub(URL actualLocation, boolean isServiceUrl) {
        return new SubscriptionBeanImpl(this, actualLocation, isServiceUrl);
    }

    public SubscriptionMutableBean getMutableInstance() {
        return new SubscriptionMutableBeanImpl(this);
    }

    public CrossReferenceBean getOwner() {
        return this.owner;
    }

    @Override
    public String getAgencyId() {
        if (this.owner.getTargetReference() == SDMX_STRUCTURE_TYPE.AGENCY) {
            if (this.owner.getMaintainableReference().getAgencyId().equals("SDMX")) {
                return this.owner.getChildReference().getId();
            }
            String id = this.owner.getMaintainableReference().getAgencyId();
            for (String currentIdentId : this.owner.getIdentifiableIds()) {
                id = id + "." + currentIdentId;
            }
            return id;
        }
        return this.owner.getMaintainableReference().getAgencyId();
    }

    public List<String> getMailTo() {
        return new ArrayList<String>(this.mailTo);
    }

    public List<String> getHTTPPostTo() {
        return new ArrayList<String>(this.HTTPPostTo);
    }

    public List<StructureReferenceBean> getReferences() {
        return new ArrayList<StructureReferenceBean>(this.references);
    }

    public SubscriptionBean.SUBSCRIPTION_TYPE getSubscriptionType() {
        return this.subscriptionType;
    }

    @Override
    public String getUrn() {
        return super.getUrn() + "." + this.owner.getChildReference().getId() + "." + this.owner.getTargetReference().getUrnClass();
    }
}

