/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.registry;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.sdmx.resources.sdmxml.schemas.v21.common.ComponentValueSetType;
import org.sdmx.resources.sdmxml.schemas.v21.common.MetadataTargetRegionType;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.base.SdmxStructureBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ContentConstraintBean;
import org.sdmxsource.sdmx.api.model.beans.registry.KeyValues;
import org.sdmxsource.sdmx.api.model.beans.registry.MetadataTargetKeyValuesBean;
import org.sdmxsource.sdmx.api.model.beans.registry.MetadataTargetRegionBean;
import org.sdmxsource.sdmx.api.model.mutable.base.MutableBean;
import org.sdmxsource.sdmx.api.model.mutable.registry.KeyValuesMutable;
import org.sdmxsource.sdmx.api.model.mutable.registry.MetadataTargetKeyValuesMutable;
import org.sdmxsource.sdmx.api.model.mutable.registry.MetadataTargetRegionMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.SdmxStructureBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.registry.KeyValuesImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.registry.MetadataTargetKeyValuesBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class MetadataTargetRegionBeanImpl
extends SdmxStructureBeanImpl
implements MetadataTargetRegionBean {
    private static final long serialVersionUID = 2908027391753862424L;
    private boolean isInclude;
    private String report;
    private String metadataTarget;
    private List<MetadataTargetKeyValuesBean> key = new ArrayList<MetadataTargetKeyValuesBean>();
    private List<KeyValues> attributes = new ArrayList<KeyValues>();

    public MetadataTargetRegionBeanImpl(MetadataTargetRegionMutableBean mutableBean, ContentConstraintBean parent) {
        super((MutableBean)mutableBean, (SdmxStructureBean)parent);
        this.isInclude = mutableBean.isInclude();
        this.report = mutableBean.getReport();
        this.metadataTarget = mutableBean.getMetadataTarget();
        if (mutableBean.getKey() != null) {
            for (MetadataTargetKeyValuesMutable currentMetadataTarget : mutableBean.getKey()) {
                this.key.add(new MetadataTargetKeyValuesBeanImpl(currentMetadataTarget, (MetadataTargetRegionBean)this));
            }
        }
        if (mutableBean.getAttributes() != null) {
            for (KeyValuesMutable currentKeyValue : mutableBean.getAttributes()) {
                this.attributes.add(new KeyValuesImpl(currentKeyValue, (SdmxStructureBean)this));
            }
        }
        try {
            this.validate();
        }
        catch (SdmxSemmanticException e) {
            throw new SdmxSemmanticException((Throwable)e, ExceptionCode.FAIL_VALIDATION, new Object[]{this});
        }
    }

    public MetadataTargetRegionBeanImpl(MetadataTargetRegionType type, ContentConstraintBean parent) {
        super(SDMX_STRUCTURE_TYPE.METADATA_TARGET_REGION, (SdmxStructureBean)parent);
        this.isInclude = type.getInclude();
        this.report = type.getReport();
        this.metadataTarget = type.getMetadataTarget();
        if (type.getKeyValueList() != null) {
            for (ComponentValueSetType cv : type.getKeyValueList()) {
                this.key.add(new MetadataTargetKeyValuesBeanImpl(cv, (MetadataTargetRegionBean)this));
            }
        }
        if (type.getKeyValueList() != null) {
            for (ComponentValueSetType cv : type.getAttributeList()) {
                this.attributes.add(new KeyValuesImpl(cv, (SdmxStructureBean)this));
            }
        }
        try {
            this.validate();
        }
        catch (SdmxSemmanticException e) {
            throw new SdmxSemmanticException((Throwable)e, ExceptionCode.FAIL_VALIDATION, new Object[]{this});
        }
    }

    private void validate() {
        if (!ObjectUtil.validString((String[])new String[]{this.report})) {
            throw new SdmxSemmanticException("Metadata Target Region missing mandatory 'report' identifier");
        }
        if (!ObjectUtil.validString((String[])new String[]{this.metadataTarget})) {
            throw new SdmxSemmanticException("Metadata Target Region missing mandatory 'metadata target' identifier");
        }
    }

    @Override
    public boolean deepEquals(SDMXBean bean, boolean includeFinalProperties) {
        if (bean == null) {
            return false;
        }
        if (bean.getStructureType() == this.getStructureType()) {
            MetadataTargetRegionBean that = (MetadataTargetRegionBean)bean;
            if (!super.equivalent(this.attributes, that.getAttributes(), includeFinalProperties)) {
                return false;
            }
            if (!super.equivalent(this.key, that.getKey(), includeFinalProperties)) {
                return false;
            }
            if (!ObjectUtil.equivalent((Object)this.metadataTarget, (Object)that.getMetadataTarget())) {
                return false;
            }
            if (!ObjectUtil.equivalent((Object)this.report, (Object)that.getReport())) {
                return false;
            }
            if (this.isInclude != that.isInclude()) {
                return false;
            }
        }
        return false;
    }

    public boolean isInclude() {
        return this.isInclude;
    }

    public String getReport() {
        return this.report;
    }

    public String getMetadataTarget() {
        return this.metadataTarget;
    }

    public List<MetadataTargetKeyValuesBean> getKey() {
        return new ArrayList<MetadataTargetKeyValuesBean>(this.key);
    }

    public List<KeyValues> getAttributes() {
        return new ArrayList<KeyValues>(this.attributes);
    }

    @Override
    protected Set<SDMXBean> getCompositesInternal() {
        Set<SDMXBean> composites = super.getCompositesInternal();
        super.addToCompositeSet(this.key, composites);
        super.addToCompositeSet(this.attributes, composites);
        return composites;
    }
}

