/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.reference;

import java.util.HashMap;
import java.util.Map;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.query.RESTSchemaQuery;
import org.sdmxsource.sdmx.util.beans.reference.MaintainableRefBeanImpl;
import org.sdmxsource.sdmx.util.beans.reference.StructureReferenceBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class RESTSchemaQueryImpl
implements RESTSchemaQuery {
    private static final long serialVersionUID = 1L;
    private StructureReferenceBean reference;
    private String dimAtObs = "TIME_PERIOD";
    private boolean explicitMeasure;
    private String context;
    private String agencyId;
    private String id;
    private String version;

    public RESTSchemaQueryImpl(StructureReferenceBean reference, String dimAtObs) {
        this(reference, dimAtObs, true);
    }

    public RESTSchemaQueryImpl(StructureReferenceBean reference, String dimAtObs, boolean explicitMeasure) {
        this.reference = reference;
        if (ObjectUtil.validString((String[])new String[]{dimAtObs})) {
            this.dimAtObs = dimAtObs;
        }
        this.explicitMeasure = explicitMeasure;
    }

    public RESTSchemaQueryImpl(String restString) {
        this(restString, null);
    }

    public RESTSchemaQueryImpl(String restString, Map<String, String> queryParameters) {
        String queryString = restString.substring(restString.indexOf("schema/"));
        String[] queryStringArr = queryString.split("/");
        if (queryParameters == null) {
            queryParameters = new HashMap<String, String>();
        }
        if (queryString.indexOf("?") > 0) {
            String params = queryString.substring(queryString.indexOf("?") + 1);
            queryString = queryString.substring(0, queryString.indexOf("?"));
            for (String currentParam : params.split("&")) {
                String[] param = currentParam.split("=");
                queryParameters.put(param[0], param[1]);
            }
        }
        this.evaluate(queryStringArr, queryParameters);
    }

    public RESTSchemaQueryImpl(String[] queryString, Map<String, String> queryParameters) {
        this.evaluate(queryString, queryParameters);
    }

    private void evaluate(String[] queryString, Map<String, String> queryParameters) {
        this.parseQueryString(queryString);
        this.parseQueryParameters(queryParameters);
        SDMX_STRUCTURE_TYPE referencedStructure = SDMX_STRUCTURE_TYPE.parseClass((String)this.context);
        if (referencedStructure != SDMX_STRUCTURE_TYPE.DSD && referencedStructure != SDMX_STRUCTURE_TYPE.DATAFLOW && referencedStructure != SDMX_STRUCTURE_TYPE.PROVISION_AGREEMENT && referencedStructure != SDMX_STRUCTURE_TYPE.METADATA_FLOW && referencedStructure != SDMX_STRUCTURE_TYPE.MSD) {
            throw new SdmxSemmanticException("The referenced structure is not a legitimate type!");
        }
        MaintainableRefBeanImpl ref = new MaintainableRefBeanImpl(this.agencyId, this.id, this.version);
        this.reference = new StructureReferenceBeanImpl((MaintainableRefBean)ref, referencedStructure);
    }

    private void parseQueryString(String[] queryString) {
        if (queryString.length < 2) {
            throw new SdmxSemmanticException("Schema query expected to contain context as the second argument");
        }
        this.context = queryString[1];
        if (queryString.length < 3) {
            throw new SdmxSemmanticException("Schema query expected to contain Agency ID as the third argument");
        }
        this.agencyId = queryString[2];
        if (queryString.length < 4) {
            throw new SdmxSemmanticException("Schema query expected to contain Resource ID as the fourth argument");
        }
        this.id = queryString[3];
        if (queryString.length > 4) {
            this.version = queryString[4];
            if (this.version.equalsIgnoreCase("latest")) {
                this.version = null;
            }
        }
        if (queryString.length > 5) {
            throw new SdmxSemmanticException("Schema query has unexpected sixth argument");
        }
    }

    private void parseQueryParameters(Map<String, String> params) {
        if (params != null) {
            for (String key : params.keySet()) {
                if (key.equalsIgnoreCase("dimensionAtObservation")) {
                    this.dimAtObs = params.get(key);
                    continue;
                }
                if (key.equalsIgnoreCase("explicitMeasure")) {
                    String val = params.get(key);
                    this.explicitMeasure = Boolean.parseBoolean(val);
                    continue;
                }
                throw new SdmxSemmanticException("Unknown query parameter : " + key + " allowed parameters [dimensionAtObservation, explicitMeasure]");
            }
        }
    }

    public StructureReferenceBean getReference() {
        return this.reference;
    }

    public String getDimAtObs() {
        return this.dimAtObs;
    }

    public boolean isExplicitMeasure() {
        return this.explicitMeasure;
    }
}

