/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.process;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.ValidationException;
import org.apache.log4j.Logger;
import org.sdmx.resources.sdmxml.schemas.v20.structure.ProcessStepType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.ProcessType;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.base.NameableBean;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.process.ProcessBean;
import org.sdmxsource.sdmx.api.model.beans.process.ProcessStepBean;
import org.sdmxsource.sdmx.api.model.beans.process.TransitionBean;
import org.sdmxsource.sdmx.api.model.mutable.base.MaintainableMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.process.ProcessMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.process.ProcessStepMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.MaintainableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.process.ProcessStepBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.process.ProcessMutableBeanImpl;

public class ProcessBeanImpl
extends MaintainableBeanImpl
implements ProcessBean {
    private static Logger LOG = Logger.getLogger(ProcessBeanImpl.class);
    private static final long serialVersionUID = 1L;
    private List<ProcessStepBean> processSteps = new ArrayList<ProcessStepBean>();

    private ProcessBeanImpl(ProcessBean bean, URL actualLocation, boolean isServiceUrl) {
        super((MaintainableBean)bean, actualLocation, isServiceUrl);
        LOG.debug((Object)"Stub ProcessBean Built");
    }

    public ProcessBeanImpl(ProcessMutableBean processBean) {
        super((MaintainableMutableBean)processBean);
        LOG.debug((Object)"Building ProcessBean from Mutable Bean");
        try {
            if (processBean.getProcessSteps() != null) {
                for (ProcessStepMutableBean processStep : processBean.getProcessSteps()) {
                    this.processSteps.add(new ProcessStepBeanImpl(this, processStep));
                }
            }
        }
        catch (Throwable th) {
            throw new SdmxSemmanticException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, new Object[]{this});
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new SdmxSemmanticException((Throwable)e, ExceptionCode.FAIL_VALIDATION, new Object[]{this});
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ProcessBean Built " + this.getUrn()));
        }
    }

    public ProcessBeanImpl(org.sdmx.resources.sdmxml.schemas.v21.structure.ProcessType processBean) {
        super(processBean, SDMX_STRUCTURE_TYPE.PROCESS);
        LOG.debug((Object)"Building ProcessBean from 2.1 SDMX");
        try {
            if (processBean.getProcessStepList() != null) {
                for (org.sdmx.resources.sdmxml.schemas.v21.structure.ProcessStepType processStep : processBean.getProcessStepList()) {
                    this.processSteps.add(new ProcessStepBeanImpl((NameableBean)this, processStep));
                }
            }
        }
        catch (Throwable th) {
            throw new SdmxSemmanticException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, new Object[]{this});
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new SdmxSemmanticException((Throwable)e, ExceptionCode.FAIL_VALIDATION, new Object[]{this});
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ProcessBean Built " + this.getUrn()));
        }
    }

    public ProcessBeanImpl(ProcessType bean) {
        super(bean, SDMX_STRUCTURE_TYPE.PROCESS, bean.getValidTo(), bean.getValidFrom(), bean.getVersion(), ProcessBeanImpl.createTertiary(bean.isSetIsFinal(), bean.getIsFinal()), bean.getAgencyID(), bean.getId(), bean.getUri(), bean.getNameList(), bean.getDescriptionList(), ProcessBeanImpl.createTertiary(bean.isSetIsExternalReference(), bean.getIsExternalReference()), bean.getAnnotations());
        LOG.debug((Object)"Building ProcessBean from 2.0 SDMX");
        try {
            if (bean.getProcessStepList() != null) {
                for (ProcessStepType processStep : bean.getProcessStepList()) {
                    this.processSteps.add(new ProcessStepBeanImpl((NameableBean)this, processStep));
                }
            }
        }
        catch (SdmxSemmanticException ex) {
            throw new SdmxSemmanticException((Throwable)ex, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, new Object[]{this.getUrn()});
        }
        catch (Throwable th) {
            throw new SdmxException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, new Object[]{this.getUrn()});
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new SdmxSemmanticException((Throwable)e, ExceptionCode.FAIL_VALIDATION, new Object[]{this});
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ProcessBean Built " + this.getUrn()));
        }
    }

    @Override
    public boolean deepEquals(SDMXBean bean, boolean includeFinalProperties) {
        if (bean == null) {
            return false;
        }
        if (bean.getStructureType() == this.getStructureType()) {
            ProcessBean that = (ProcessBean)bean;
            if (!super.equivalent(this.processSteps, that.getProcessSteps(), includeFinalProperties)) {
                return false;
            }
            return super.deepEqualsInternal((MaintainableBean)that, includeFinalProperties);
        }
        return false;
    }

    private void validate() throws ValidationException {
        HashSet<String> processStepReferences = new HashSet<String>();
        HashSet<String> processStepIds = new HashSet<String>();
        this.populateProcessStepSets(this.processSteps, processStepIds, processStepReferences);
        if (!processStepIds.containsAll(processStepReferences)) {
            for (String currentReference : processStepReferences) {
                if (processStepIds.contains(currentReference)) continue;
                throw new SdmxSemmanticException("Transition references non existent process step '" + currentReference + "'");
            }
        }
    }

    private void populateProcessStepSets(List<ProcessStepBean> processSteps, Set<String> processStepIds, Set<String> processStepReferences) {
        for (ProcessStepBean processStep : processSteps) {
            for (TransitionBean transition : processStep.getTransitions()) {
                processStepReferences.add(transition.getTargetStep().getId());
            }
            processStepIds.add(processStep.getFullIdPath(false));
            this.populateProcessStepSets(processStep.getProcessSteps(), processStepIds, processStepReferences);
        }
    }

    public ProcessBean getStub(URL actualLocation, boolean isServiceUrl) {
        return new ProcessBeanImpl(this, actualLocation, isServiceUrl);
    }

    public ProcessMutableBean getMutableInstance() {
        return new ProcessMutableBeanImpl(this);
    }

    public List<ProcessStepBean> getProcessSteps() {
        return new ArrayList<ProcessStepBean>(this.processSteps);
    }

    @Override
    protected Set<SDMXBean> getCompositesInternal() {
        Set<SDMXBean> composites = super.getCompositesInternal();
        super.addToCompositeSet(this.processSteps, composites);
        return composites;
    }
}

