/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.process;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.sdmx.resources.sdmxml.schemas.v20.structure.ProcessStepType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ComputationType;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.base.AnnotableBean;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.base.SdmxStructureBean;
import org.sdmxsource.sdmx.api.model.beans.base.TextTypeWrapper;
import org.sdmxsource.sdmx.api.model.beans.process.ComputationBean;
import org.sdmxsource.sdmx.api.model.mutable.base.AnnotableMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.base.TextTypeWrapperMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.process.ComputationMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.AnnotableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.TextTypeWrapperImpl;
import org.sdmxsource.sdmx.sdmxbeans.util.TextTypeUtil;
import org.sdmxsource.util.ObjectUtil;

public class ComputationBeanImpl
extends AnnotableBeanImpl
implements ComputationBean {
    private static final long serialVersionUID = 2467028947066566585L;
    private String localId;
    private String softwarePackage;
    private String softwareLanguage;
    private String softwareVersion;
    private List<TextTypeWrapper> description = new ArrayList<TextTypeWrapper>();

    public ComputationBeanImpl(IdentifiableBean parent, ComputationMutableBean mutableBean) {
        super((AnnotableMutableBean)mutableBean, (SdmxStructureBean)parent);
        this.localId = mutableBean.getLocalId();
        this.softwareLanguage = mutableBean.getSoftwareLanguage();
        this.softwarePackage = mutableBean.getSoftwarePackage();
        this.softwareVersion = mutableBean.getSoftwareVersion();
        if (mutableBean.getDescriptions() != null) {
            for (TextTypeWrapperMutableBean currentTT : mutableBean.getDescriptions()) {
                if (!ObjectUtil.validString((String[])new String[]{currentTT.getValue()})) continue;
                this.description.add(new TextTypeWrapperImpl(currentTT, (SDMXBean)this));
            }
        }
        try {
            this.validate();
        }
        catch (SdmxSemmanticException ex) {
            throw new SdmxSemmanticException((Throwable)ex, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, new Object[]{this});
        }
        catch (Throwable th) {
            throw new SdmxException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, new Object[]{this});
        }
    }

    public ComputationBeanImpl(IdentifiableBean parent, ComputationType xmlType) {
        super(xmlType, SDMX_STRUCTURE_TYPE.COMPUTATION, (SdmxStructureBean)parent);
        this.localId = xmlType.getLocalID();
        this.softwareLanguage = xmlType.getSoftwareLanguage();
        this.softwarePackage = xmlType.getSoftwarePackage();
        this.softwareVersion = xmlType.getSoftwareVersion();
        if (xmlType.getDescriptionList() != null) {
            this.description = TextTypeUtil.wrapTextTypeV21(xmlType.getDescriptionList(), this);
        }
        try {
            this.validate();
        }
        catch (SdmxSemmanticException ex) {
            throw new SdmxSemmanticException((Throwable)ex, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, new Object[]{this});
        }
        catch (Throwable th) {
            throw new SdmxException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, new Object[]{this});
        }
    }

    public ComputationBeanImpl(IdentifiableBean parent, ProcessStepType processBean) {
        super(null, SDMX_STRUCTURE_TYPE.COMPUTATION, (SdmxStructureBean)parent);
        if (processBean.getComputationList() != null) {
            this.description = TextTypeUtil.wrapTextTypeV2(processBean.getComputationList(), this);
        }
        try {
            this.validate();
        }
        catch (SdmxSemmanticException ex) {
            throw new SdmxSemmanticException((Throwable)ex, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, new Object[]{this});
        }
        catch (Throwable th) {
            throw new SdmxException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, new Object[]{this});
        }
    }

    @Override
    public boolean deepEquals(SDMXBean bean, boolean includeFinalProperties) {
        if (bean == null) {
            return false;
        }
        if (bean.getStructureType() == this.getStructureType()) {
            ComputationBean that = (ComputationBean)bean;
            if (!super.equivalent(this.description, that.getDescription(), includeFinalProperties)) {
                return false;
            }
            if (!ObjectUtil.equivalent((Object)this.localId, (Object)that.getLocalId())) {
                return false;
            }
            if (!ObjectUtil.equivalent((Object)this.softwarePackage, (Object)that.getSoftwarePackage())) {
                return false;
            }
            if (!ObjectUtil.equivalent((Object)this.softwareLanguage, (Object)that.getSoftwareLanguage())) {
                return false;
            }
            if (!ObjectUtil.equivalent((Object)this.softwareVersion, (Object)that.getSoftwareVersion())) {
                return false;
            }
            return super.deepEqualsInternal((AnnotableBean)that, includeFinalProperties);
        }
        return false;
    }

    public String getLocalId() {
        return this.localId;
    }

    public String getSoftwarePackage() {
        return this.softwarePackage;
    }

    public String getSoftwareLanguage() {
        return this.softwareLanguage;
    }

    public String getSoftwareVersion() {
        return this.softwareVersion;
    }

    public List<TextTypeWrapper> getDescription() {
        return new ArrayList<TextTypeWrapper>(this.description);
    }

    private void validate() {
        if (this.description == null) {
            throw new SdmxSemmanticException("Computation missing mandatory field 'description'");
        }
    }

    @Override
    protected Set<SDMXBean> getCompositesInternal() {
        Set<SDMXBean> composites = super.getCompositesInternal();
        super.addToCompositeSet(this.description, composites);
        return composites;
    }
}

