/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.mapping;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.bind.ValidationException;
import org.apache.log4j.Logger;
import org.sdmx.resources.sdmxml.schemas.v20.structure.StructureSetType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.CategorySchemeMapType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.CodelistMapType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ConceptSchemeMapType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.OrganisationSchemeMapType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.StructureMapType;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.base.SdmxStructureBean;
import org.sdmxsource.sdmx.api.model.beans.mapping.CategorySchemeMapBean;
import org.sdmxsource.sdmx.api.model.beans.mapping.CodelistMapBean;
import org.sdmxsource.sdmx.api.model.beans.mapping.ConceptSchemeMapBean;
import org.sdmxsource.sdmx.api.model.beans.mapping.OrganisationSchemeMapBean;
import org.sdmxsource.sdmx.api.model.beans.mapping.RelatedStructuresBean;
import org.sdmxsource.sdmx.api.model.beans.mapping.StructureMapBean;
import org.sdmxsource.sdmx.api.model.beans.mapping.StructureSetBean;
import org.sdmxsource.sdmx.api.model.mutable.base.MaintainableMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.base.StructureMapMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.mapping.CategorySchemeMapMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.mapping.CodelistMapMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.mapping.ConceptSchemeMapMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.mapping.OrganisationSchemeMapMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.mapping.StructureSetMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.MaintainableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.mapping.CategorySchemeMapBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.mapping.CodelistMapBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.mapping.ConceptSchemeMapBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.mapping.OrganisationSchemeMapBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.mapping.RelatedStructuresBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.mapping.StructureMapBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.mapping.StructureSetMutableBeanImpl;

public class StructureSetBeanImpl
extends MaintainableBeanImpl
implements StructureSetBean {
    private static Logger LOG = Logger.getLogger(StructureSetBeanImpl.class);
    private static final long serialVersionUID = 1L;
    private RelatedStructuresBean relatedStructures;
    private List<StructureMapBean> structureMapList = new ArrayList<StructureMapBean>();
    private List<CodelistMapBean> codelistMapList = new ArrayList<CodelistMapBean>();
    private List<CategorySchemeMapBean> categorySchemeMapList = new ArrayList<CategorySchemeMapBean>();
    private List<ConceptSchemeMapBean> conceptSchemeMapList = new ArrayList<ConceptSchemeMapBean>();
    private List<OrganisationSchemeMapBean> organisationSchemeMapList = new ArrayList<OrganisationSchemeMapBean>();

    private StructureSetBeanImpl(StructureSetBean bean, URL actualLocation, boolean isServiceUrl) {
        super((MaintainableBean)bean, actualLocation, isServiceUrl);
        LOG.debug((Object)"Stub StructureSetBean Built");
    }

    public StructureSetBeanImpl(StructureSetMutableBean structureSet) {
        super((MaintainableMutableBean)structureSet);
        LOG.debug((Object)"Building StructureSetBean from Mutable Bean");
        try {
            if (structureSet.getRelatedStructures() != null) {
                this.relatedStructures = new RelatedStructuresBeanImpl(structureSet.getRelatedStructures(), (SdmxStructureBean)this);
            }
            if (structureSet.getStructureMapList() != null) {
                for (StructureMapMutableBean each : structureSet.getStructureMapList()) {
                    this.structureMapList.add(new StructureMapBeanImpl(each, (StructureSetBean)this));
                }
            }
            if (structureSet.getCodelistMapList() != null) {
                for (StructureMapMutableBean each : structureSet.getCodelistMapList()) {
                    this.codelistMapList.add(new CodelistMapBeanImpl((CodelistMapMutableBean)each, (StructureSetBean)this));
                }
            }
            if (structureSet.getCategorySchemeMapList() != null) {
                for (StructureMapMutableBean each : structureSet.getCategorySchemeMapList()) {
                    this.categorySchemeMapList.add(new CategorySchemeMapBeanImpl((CategorySchemeMapMutableBean)each, (StructureSetBean)this));
                }
            }
            if (structureSet.getConceptSchemeMapList() != null) {
                for (StructureMapMutableBean each : structureSet.getConceptSchemeMapList()) {
                    this.conceptSchemeMapList.add(new ConceptSchemeMapBeanImpl((ConceptSchemeMapMutableBean)each, (StructureSetBean)this));
                }
            }
            if (structureSet.getOrganisationSchemeMapList() != null) {
                for (StructureMapMutableBean each : structureSet.getOrganisationSchemeMapList()) {
                    this.organisationSchemeMapList.add(new OrganisationSchemeMapBeanImpl((OrganisationSchemeMapMutableBean)each, (StructureSetBean)this));
                }
            }
        }
        catch (Throwable th) {
            throw new SdmxSemmanticException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, new Object[]{this});
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new SdmxSemmanticException((Throwable)e, ExceptionCode.FAIL_VALIDATION, new Object[]{this});
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("StructureSetBean Built " + this.getUrn()));
        }
    }

    public StructureSetBeanImpl(org.sdmx.resources.sdmxml.schemas.v21.structure.StructureSetType structureSet) {
        super(structureSet, SDMX_STRUCTURE_TYPE.STRUCTURE_SET);
        LOG.debug((Object)"Building StructureSetBean from 2.1 SDMX");
        try {
            if (structureSet.getRelatedStructureList() != null) {
                this.relatedStructures = new RelatedStructuresBeanImpl(structureSet.getRelatedStructureList(), (SdmxStructureBean)this);
            }
            if (structureSet.getStructureMapList() != null) {
                this.structureMapList = new ArrayList<StructureMapBean>();
                for (StructureMapType structureMapType : structureSet.getStructureMapList()) {
                    this.structureMapList.add(new StructureMapBeanImpl(structureMapType, (StructureSetBean)this));
                }
            }
            if (structureSet.getCodelistMapList() != null) {
                this.codelistMapList = new ArrayList<CodelistMapBean>();
                for (CodelistMapType codelistMapType : structureSet.getCodelistMapList()) {
                    this.codelistMapList.add(new CodelistMapBeanImpl(codelistMapType, (StructureSetBean)this));
                }
            }
            if (structureSet.getCategorySchemeMapList() != null) {
                this.categorySchemeMapList = new ArrayList<CategorySchemeMapBean>();
                for (CategorySchemeMapType categorySchemeMapType : structureSet.getCategorySchemeMapList()) {
                    this.categorySchemeMapList.add(new CategorySchemeMapBeanImpl(categorySchemeMapType, (StructureSetBean)this));
                }
            }
            if (structureSet.getConceptSchemeMapList() != null) {
                this.conceptSchemeMapList = new ArrayList<ConceptSchemeMapBean>();
                for (ConceptSchemeMapType conceptSchemeMapType : structureSet.getConceptSchemeMapList()) {
                    this.conceptSchemeMapList.add(new ConceptSchemeMapBeanImpl(conceptSchemeMapType, (StructureSetBean)this));
                }
            }
            if (structureSet.getOrganisationSchemeMapList() != null) {
                this.organisationSchemeMapList = new ArrayList<OrganisationSchemeMapBean>();
                for (OrganisationSchemeMapType organisationSchemeMapType : structureSet.getOrganisationSchemeMapList()) {
                    this.organisationSchemeMapList.add(new OrganisationSchemeMapBeanImpl(organisationSchemeMapType, (StructureSetBean)this));
                }
            }
        }
        catch (Throwable th) {
            throw new SdmxSemmanticException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, new Object[]{this});
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new SdmxSemmanticException((Throwable)e, ExceptionCode.FAIL_VALIDATION, new Object[]{this});
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("StructureSetBean Built " + this.getUrn()));
        }
    }

    public StructureSetBeanImpl(StructureSetType bean) {
        super(bean, SDMX_STRUCTURE_TYPE.STRUCTURE_SET, bean.getValidTo(), bean.getValidFrom(), bean.getVersion(), StructureSetBeanImpl.createTertiary(bean.isSetIsFinal(), bean.getIsFinal()), bean.getAgencyID(), bean.getId(), bean.getUri(), bean.getNameList(), bean.getDescriptionList(), StructureSetBeanImpl.createTertiary(bean.isSetIsExternalReference(), bean.getIsExternalReference()), bean.getAnnotations());
        LOG.debug((Object)"Building StructureSetBean from 2.0 SDMX");
        try {
            if (bean.getRelatedStructures() != null) {
                this.relatedStructures = new RelatedStructuresBeanImpl(bean.getRelatedStructures(), (SdmxStructureBean)this);
            }
            if (bean.getStructureMap() != null) {
                this.structureMapList = new ArrayList<StructureMapBean>();
                this.structureMapList.add(new StructureMapBeanImpl(bean.getStructureMap(), (StructureSetBean)this));
            }
            if (bean.getCodelistMap() != null) {
                this.codelistMapList = new ArrayList<CodelistMapBean>();
                this.codelistMapList.add(new CodelistMapBeanImpl(bean.getCodelistMap(), (StructureSetBean)this));
            }
            if (bean.getCategorySchemeMap() != null) {
                this.categorySchemeMapList = new ArrayList<CategorySchemeMapBean>();
                this.categorySchemeMapList.add(new CategorySchemeMapBeanImpl(bean.getCategorySchemeMap(), (StructureSetBean)this));
            }
            if (bean.getConceptSchemeMap() != null) {
                this.conceptSchemeMapList = new ArrayList<ConceptSchemeMapBean>();
                this.conceptSchemeMapList.add(new ConceptSchemeMapBeanImpl(bean.getConceptSchemeMap(), (StructureSetBean)this));
            }
            if (bean.getOrganisationSchemeMap() != null) {
                this.organisationSchemeMapList = new ArrayList<OrganisationSchemeMapBean>();
                this.organisationSchemeMapList.add(new OrganisationSchemeMapBeanImpl(bean.getOrganisationSchemeMap(), (StructureSetBean)this));
            }
        }
        catch (Throwable th) {
            throw new SdmxSemmanticException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, new Object[]{this});
        }
        try {
            this.validate();
        }
        catch (ValidationException e) {
            throw new SdmxSemmanticException((Throwable)e, ExceptionCode.FAIL_VALIDATION, new Object[]{this});
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("StructureSetBean Built " + this.getUrn()));
        }
    }

    @Override
    public boolean deepEquals(SDMXBean bean, boolean includeFinalProperties) {
        if (bean == null) {
            return false;
        }
        if (bean.getStructureType() == this.getStructureType()) {
            StructureSetBean that = (StructureSetBean)bean;
            if (!super.equivalent((SDMXBean)this.relatedStructures, (SDMXBean)that.getRelatedStructures(), includeFinalProperties)) {
                return false;
            }
            if (!super.equivalent(this.structureMapList, that.getStructureMapList(), includeFinalProperties)) {
                return false;
            }
            if (!super.equivalent(this.codelistMapList, that.getCodelistMapList(), includeFinalProperties)) {
                return false;
            }
            if (!super.equivalent(this.categorySchemeMapList, that.getCategorySchemeMapList(), includeFinalProperties)) {
                return false;
            }
            if (!super.equivalent(this.conceptSchemeMapList, that.getConceptSchemeMapList(), includeFinalProperties)) {
                return false;
            }
            if (!super.equivalent(this.organisationSchemeMapList, that.getOrganisationSchemeMapList(), includeFinalProperties)) {
                return false;
            }
            return super.deepEqualsInternal((MaintainableBean)that, includeFinalProperties);
        }
        return false;
    }

    private void validate() throws ValidationException {
    }

    public StructureSetBean getStub(URL actualLocation, boolean isServiceUrl) {
        return new StructureSetBeanImpl(this, actualLocation, isServiceUrl);
    }

    public StructureSetMutableBean getMutableInstance() {
        return new StructureSetMutableBeanImpl(this);
    }

    public RelatedStructuresBean getRelatedStructures() {
        return this.relatedStructures;
    }

    public List<StructureMapBean> getStructureMapList() {
        ArrayList<StructureMapBean> list = new ArrayList<StructureMapBean>();
        for (StructureMapBean each : this.structureMapList) {
            list.add(each);
        }
        return list;
    }

    public List<CodelistMapBean> getCodelistMapList() {
        ArrayList<CodelistMapBean> list = new ArrayList<CodelistMapBean>();
        for (CodelistMapBean each : this.codelistMapList) {
            list.add(each);
        }
        return list;
    }

    public List<CategorySchemeMapBean> getCategorySchemeMapList() {
        ArrayList<CategorySchemeMapBean> list = new ArrayList<CategorySchemeMapBean>();
        for (CategorySchemeMapBean each : this.categorySchemeMapList) {
            list.add(each);
        }
        return list;
    }

    public List<ConceptSchemeMapBean> getConceptSchemeMapList() {
        ArrayList<ConceptSchemeMapBean> list = new ArrayList<ConceptSchemeMapBean>();
        for (ConceptSchemeMapBean each : this.conceptSchemeMapList) {
            list.add(each);
        }
        return list;
    }

    public List<OrganisationSchemeMapBean> getOrganisationSchemeMapList() {
        return new ArrayList<OrganisationSchemeMapBean>(this.organisationSchemeMapList);
    }

    @Override
    protected Set<SDMXBean> getCompositesInternal() {
        Set<SDMXBean> composites = super.getCompositesInternal();
        super.addToCompositeSet((SDMXBean)this.relatedStructures, composites);
        super.addToCompositeSet(this.structureMapList, composites);
        super.addToCompositeSet(this.codelistMapList, composites);
        super.addToCompositeSet(this.categorySchemeMapList, composites);
        super.addToCompositeSet(this.conceptSchemeMapList, composites);
        super.addToCompositeSet(this.organisationSchemeMapList, composites);
        return composites;
    }
}

