/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.base;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.xmlbeans.XmlObject;
import org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.common.AnnotationsType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.IdentifiableType;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.base.AnnotableBean;
import org.sdmxsource.sdmx.api.model.beans.base.AnnotationBean;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.base.SdmxStructureBean;
import org.sdmxsource.sdmx.api.model.beans.base.TextTypeWrapper;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.mutable.base.AnnotableMutableBean;
import org.sdmxsource.sdmx.api.model.mutable.base.IdentifiableMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.AnnotableBeanImpl;
import org.sdmxsource.sdmx.util.beans.ValidationUtil;
import org.sdmxsource.sdmx.util.beans.reference.StructureReferenceBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public abstract class IdentifiableBeanImpl
extends AnnotableBeanImpl
implements IdentifiableBean {
    private static final long serialVersionUID = 1L;
    private String id;
    URI uri;

    public IdentifiableBeanImpl(String id, SDMX_STRUCTURE_TYPE structureType, SdmxStructureBean parent) {
        super(null, structureType, parent);
        this.setId(id);
        this.validateIdentifiableAttributes();
    }

    protected IdentifiableBeanImpl(IdentifiableBean bean) {
        super((AnnotableBean)bean);
        this.id = bean.getId();
        this.uri = bean.getUri();
        this.structureType = bean.getStructureType();
        this.validateIdentifiableAttributes();
    }

    protected IdentifiableBeanImpl(IdentifiableMutableBean bean, SdmxStructureBean parent) {
        super((AnnotableMutableBean)bean, parent);
        this.setId(bean.getId());
        this.setUri(bean.getUri());
        this.validateIdentifiableAttributes();
    }

    public IdentifiableBeanImpl(IdentifiableType createdFrom, SDMX_STRUCTURE_TYPE structureType, SdmxStructureBean parent) {
        super(createdFrom, structureType, parent);
        this.id = createdFrom.getId();
        this.setUri(createdFrom.getUri());
        this.validateIdentifiableAttributes();
    }

    public IdentifiableBeanImpl(XmlObject createdFrom, SDMX_STRUCTURE_TYPE structureType, String id, String uri, org.sdmx.resources.sdmxml.schemas.v20.common.AnnotationsType annotationsType, SdmxStructureBean parent) {
        super(createdFrom, annotationsType, structureType, parent);
        this.setId(id);
        this.setUri(uri);
        this.validateIdentifiableAttributes();
    }

    public IdentifiableBeanImpl(XmlObject createdFrom, SDMX_STRUCTURE_TYPE structureType, String id, String uri, AnnotationsType annotationsType, SdmxStructureBean parent) {
        super(createdFrom, annotationsType, structureType, parent);
        this.setId(id);
        this.setUri(uri);
        this.validateIdentifiableAttributes();
    }

    protected void validateIdentifiableAttributes() throws SdmxSemmanticException {
        if (this.parent == null && !this.structureType.isMaintainable()) {
            throw new SdmxSemmanticException(ExceptionCode.JAVA_REQUIRED_OBJECT_NULL, new Object[]{"parent"});
        }
        this.validateId(true);
    }

    protected void validateId(boolean startWithIntAllowed) {
        if (!ObjectUtil.validString((String[])new String[]{this.getId()})) {
            throw new SdmxSemmanticException(ExceptionCode.STRUCTURE_IDENTIFIABLE_MISSING_ID, new Object[]{this.structureType});
        }
        this.id = ValidationUtil.cleanAndValidateId((String)this.getId(), (boolean)startWithIntAllowed);
    }

    protected boolean deepEqualsInternal(IdentifiableBean bean, boolean includeFinalProperties) {
        if (bean == null) {
            return false;
        }
        if (!ObjectUtil.equivalent((Object)this.id, (Object)bean.getId())) {
            return false;
        }
        if (includeFinalProperties && !ObjectUtil.equivalent((Object)this.uri, (Object)bean.getUri())) {
            return false;
        }
        if (!ObjectUtil.equivalent((Object)this.getUrn(), (Object)bean.getUrn())) {
            return false;
        }
        return super.deepEqualsInternal((AnnotableBean)bean, includeFinalProperties);
    }

    public StructureReferenceBean asReference() {
        return new StructureReferenceBeanImpl((IdentifiableBean)this);
    }

    public String getId() {
        return this.id;
    }

    protected void setId(String id) {
        this.id = id;
    }

    private void setUri(String uriStr) {
        if (uriStr == null) {
            this.uri = null;
            return;
        }
        try {
            this.uri = new URI(uriStr);
        }
        catch (Throwable th) {
            throw new SdmxSemmanticException("Could not create attribute 'uri' with value '" + uriStr + "'");
        }
    }

    public URI getUri() {
        return this.uri;
    }

    public String getFullIdPath(boolean includeDifferentTypes) {
        if (!this.getStructureType().isMaintainable()) {
            List<String> parentIds = this.getParentIds(includeDifferentTypes);
            String returnId = "";
            String concat = "";
            for (String currentId : parentIds) {
                returnId = returnId + concat + currentId;
                concat = ".";
            }
            return returnId;
        }
        return null;
    }

    public String getUrn() {
        List<String> parentIds = this.getParentIds(true);
        MaintainableBean maintainableParent = this.getMaintainableParent();
        String[] ids = new String[parentIds.size()];
        parentIds.toArray(ids);
        return this.structureType.generateUrn(maintainableParent.getAgencyId(), maintainableParent.getId(), maintainableParent.getVersion(), ids);
    }

    protected List<String> getParentIds(boolean includeDifferentTypes) {
        ArrayList<String> parentIds = new ArrayList<String>();
        if (!this.getStructureType().isMaintainable()) {
            parentIds.add(this.getId());
            for (IdentifiableBean currentParent = this.getIdentifiableParent(); currentParent != null && (includeDifferentTypes || this.getStructureType() == currentParent.getStructureType()) && !currentParent.getStructureType().isMaintainable(); currentParent = currentParent.getIdentifiableParent()) {
                parentIds.add(currentParent.getId());
            }
        }
        Collections.reverse(parentIds);
        return parentIds;
    }

    public List<TextTypeWrapper> getAllTextTypes() {
        ArrayList<TextTypeWrapper> returnList = new ArrayList<TextTypeWrapper>();
        for (AnnotationBean annotation : this.getAnnotations()) {
            returnList.addAll(annotation.getText());
        }
        return returnList;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IdentifiableBean) {
            IdentifiableBean that = (IdentifiableBean)obj;
            return that.getUrn().equals(this.getUrn());
        }
        return false;
    }

    public String toString() {
        try {
            return this.getUrn();
        }
        catch (Throwable th) {
            StringBuilder sb = new StringBuilder();
            sb.append("\nId: " + this.getId());
            return sb.toString();
        }
    }

    public int hashCode() {
        return this.getUrn().hashCode();
    }
}

