/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.util.beans.reference;

import java.util.ArrayList;
import java.util.Arrays;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.reference.IdentifiableRefBean;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.util.beans.UrnUtil;
import org.sdmxsource.sdmx.util.beans.reference.IdentifiableRefBeanImpl;
import org.sdmxsource.sdmx.util.beans.reference.MaintainableRefBeanImpl;
import org.sdmxsource.util.ObjectUtil;
import org.sdmxsource.util.VersionableUtil;

public class StructureReferenceBeanImpl
implements StructureReferenceBean {
    private static final long serialVersionUID = -4043917683226286238L;
    private String agencyId;
    private String maintainableId;
    protected String version;
    private SDMX_STRUCTURE_TYPE structureType;
    private SDMX_STRUCTURE_TYPE targetStructureType;
    private IdentifiableRefBean childReference;
    int hashcode = -1;

    public StructureReferenceBeanImpl() {
    }

    public StructureReferenceBeanImpl(String urn) {
        SDMX_STRUCTURE_TYPE targetStructure = UrnUtil.getIdentifiableType(urn);
        UrnUtil.validateURN(urn, targetStructure);
        String[] components = UrnUtil.getUrnComponents(urn);
        this.agencyId = components[0];
        this.maintainableId = components[1];
        this.version = UrnUtil.getVersionFromUrn(urn);
        if (this.version == null) {
            this.version = "1.0";
        }
        this.targetStructureType = targetStructure;
        if (!targetStructure.isMaintainable() && targetStructure.isIdentifiable()) {
            String[] identfiableIds = Arrays.copyOfRange(components, 2, components.length);
            this.childReference = new IdentifiableRefBeanImpl((StructureReferenceBean)this, identfiableIds, targetStructure);
            while (!(targetStructure = targetStructure.getParentStructureType()).isMaintainable()) {
            }
            this.structureType = targetStructure;
        } else {
            this.structureType = targetStructure;
        }
    }

    public StructureReferenceBeanImpl(MaintainableRefBean ref, SDMX_STRUCTURE_TYPE structureType) {
        if (ref != null) {
            this.setInformation(ref.getAgencyId(), ref.getMaintainableId(), ref.getVersion(), structureType, new String[0]);
        } else {
            this.setInformation(null, null, null, structureType, new String[0]);
        }
    }

    public StructureReferenceBeanImpl(SDMX_STRUCTURE_TYPE structureType) {
        this.setInformation(null, null, null, structureType, new String[0]);
    }

    public StructureReferenceBeanImpl(IdentifiableBean identifiable) {
        this(identifiable.getUrn());
    }

    public StructureReferenceBeanImpl(MaintainableBean parentMaint, SDMX_STRUCTURE_TYPE targetStructure, String ... identfiableIds) {
        this.setInformation(parentMaint.getAgencyId(), parentMaint.getId(), parentMaint.getVersion(), targetStructure, identfiableIds);
    }

    public StructureReferenceBeanImpl(String agencyId, String maintainableId, String version, SDMX_STRUCTURE_TYPE targetStructure, String ... identfiableIds) {
        this.setInformation(agencyId, maintainableId, version, targetStructure, identfiableIds);
    }

    public String getFullId() {
        if (this.childReference == null) {
            return null;
        }
        String returnString = "";
        String concat = "";
        for (String currentId : this.getIdentifiableIds()) {
            returnString = returnString + concat + currentId;
            concat = ".";
        }
        if (this.targetStructureType == SDMX_STRUCTURE_TYPE.AGENCY && this.agencyId != null && !this.agencyId.equals("SDMX")) {
            returnString = this.agencyId + "." + returnString;
        }
        return returnString;
    }

    private void setInformation(String agencyId, String maintainableId, String version, SDMX_STRUCTURE_TYPE targetStructure, String ... identfiableIds) {
        this.agencyId = agencyId;
        this.maintainableId = maintainableId;
        if (ObjectUtil.validString(version)) {
            this.version = VersionableUtil.formatVersion(version);
        }
        if (targetStructure == null) {
            throw new IllegalArgumentException("Structure Type must be given for a StructureReferenceBeanImpl");
        }
        if (identfiableIds == null && !targetStructure.isMaintainable() && targetStructure != SDMX_STRUCTURE_TYPE.ANY) {
            throw new IllegalArgumentException("Can not create reference, target structure is not maintainable, and no identifiable reference parameters present");
        }
        this.targetStructureType = targetStructure;
        if (!targetStructure.isMaintainable() && targetStructure.isIdentifiable()) {
            if (identfiableIds != null && identfiableIds.length > 0) {
                this.childReference = new IdentifiableRefBeanImpl((StructureReferenceBean)this, identfiableIds, targetStructure);
            }
            while (!(targetStructure = targetStructure.getParentStructureType()).isMaintainable()) {
            }
            this.structureType = targetStructure;
        } else {
            this.structureType = targetStructure;
        }
    }

    public String getTargetUrn() {
        if (this.targetStructureType == SDMX_STRUCTURE_TYPE.AGENCY && this.childReference != null && ObjectUtil.validString(this.childReference.getId())) {
            if (this.agencyId.equals("SDMX")) {
                return this.targetStructureType.getUrnPrefix() + this.childReference.getId();
            }
            return this.targetStructureType.getUrnPrefix() + this.agencyId + "." + this.childReference.getId();
        }
        if (ObjectUtil.validString(this.agencyId, this.maintainableId, this.version)) {
            ArrayList<String> ids = new ArrayList<String>();
            if (this.childReference != null) {
                block3: for (IdentifiableRefBean currentRef = this.childReference; currentRef != null; currentRef = currentRef.getChildReference()) {
                    switch (currentRef.getStructureType()) {
                        case ATTRIBUTE_DESCRIPTOR: 
                        case DIMENSION_DESCRIPTOR: 
                        case MEASURE_DESCRIPTOR: {
                            if (this.targetStructureType != currentRef.getStructureType()) continue block3;
                            ids.add(currentRef.getId());
                            continue block3;
                        }
                        default: {
                            ids.add(currentRef.getId());
                        }
                    }
                }
            }
            String[] arr = new String[ids.size()];
            ids.toArray(arr);
            return this.targetStructureType.generateUrn(this.agencyId, this.maintainableId, this.version, arr);
        }
        return null;
    }

    public String getMaintainableUrn() {
        if (ObjectUtil.validString(this.agencyId, this.maintainableId, this.version)) {
            return this.structureType.generateUrn(this.agencyId, this.maintainableId, this.version, new String[0]);
        }
        return null;
    }

    public MaintainableRefBean getMaintainableReference() {
        return new MaintainableRefBeanImpl(this.agencyId, this.maintainableId, this.version);
    }

    public SDMX_STRUCTURE_TYPE getMaintainableStructureType() {
        return this.structureType;
    }

    public SDMX_STRUCTURE_TYPE getTargetReference() {
        return this.targetStructureType;
    }

    public IdentifiableRefBean getChildReference() {
        return this.childReference;
    }

    public String[] getIdentifiableIds() {
        if (this.childReference == null) {
            return null;
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (IdentifiableRefBean currentRef = this.childReference; currentRef != null; currentRef = currentRef.getChildReference()) {
            ids.add(currentRef.getId());
        }
        String[] returnArray = new String[ids.size()];
        ids.toArray(returnArray);
        return returnArray;
    }

    public SDMX_STRUCTURE_TYPE getTargetStructureType() {
        return this.targetStructureType;
    }

    public void setTargetStructureType(SDMX_STRUCTURE_TYPE targetStructureType) {
        this.targetStructureType = targetStructureType;
        this.setMaintainableStructureType(targetStructureType);
    }

    public String getAgencyId() {
        return this.agencyId;
    }

    public String getMaintainableId() {
        return this.maintainableId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setAgencyId(String agencyId) {
        this.agencyId = ObjectUtil.validString(agencyId) ? agencyId : null;
    }

    public void setVersion(String version) {
        this.version = ObjectUtil.validString(version) ? VersionableUtil.formatVersion(version) : null;
    }

    public void setMaintainableStructureType(SDMX_STRUCTURE_TYPE structureType) {
        block1: {
            this.structureType = structureType;
            if (structureType == null || structureType.isMaintainable()) break block1;
            SDMX_STRUCTURE_TYPE targetStructure = structureType;
            while (!(targetStructure = targetStructure.getParentStructureType()).isMaintainable()) {
            }
            this.structureType = targetStructure;
        }
    }

    public void setChildReference(IdentifiableRefBean childReference) {
        this.childReference = childReference;
    }

    public void setMaintainableId(String maintainableId) {
        this.maintainableId = ObjectUtil.validString(maintainableId) ? maintainableId : null;
    }

    public boolean hasAgencyId() {
        return ObjectUtil.validString(this.agencyId);
    }

    public boolean hasMaintainableId() {
        return ObjectUtil.validString(this.maintainableId);
    }

    public boolean hasVersion() {
        return ObjectUtil.validString(this.version);
    }

    public boolean hasChildReference() {
        return this.getChildReference() != null;
    }

    public boolean hasTargetUrn() {
        return this.getTargetUrn() != null;
    }

    public boolean hasMaintainableUrn() {
        return this.getTargetUrn() != null;
    }

    public StructureReferenceBean createCopy() {
        return new StructureReferenceBeanImpl(this.agencyId, this.maintainableId, this.version, this.targetStructureType, this.getIdentifiableIds());
    }

    public boolean equals(Object obj) {
        if (obj instanceof StructureReferenceBean) {
            StructureReferenceBean that = (StructureReferenceBean)obj;
            MaintainableRefBean thatMRef = that.getMaintainableReference();
            MaintainableRefBean thisMRef = this.getMaintainableReference();
            return ObjectUtil.equivalent(thatMRef.getMaintainableId(), thisMRef.getMaintainableId()) && ObjectUtil.equivalent(thatMRef.getAgencyId(), thisMRef.getAgencyId()) && ObjectUtil.equivalent(thatMRef.getVersion(), thisMRef.getVersion()) && ObjectUtil.equivalent(this.getChildReference(), that.getChildReference());
        }
        return false;
    }

    public boolean isMatch(MaintainableBean maintainbleBean) {
        return this.getMatch(maintainbleBean) != null;
    }

    public IdentifiableBean getMatch(MaintainableBean maintainbleBean) {
        if (this.getMaintainableStructureType() == maintainbleBean.getStructureType()) {
            if (ObjectUtil.validString(this.getAgencyId()) && !this.getAgencyId().equals(maintainbleBean.getAgencyId())) {
                return null;
            }
            if (ObjectUtil.validString(this.getMaintainableId()) && !this.getMaintainableId().equals(maintainbleBean.getId())) {
                return null;
            }
            if (ObjectUtil.validString(this.getVersion()) && !this.getVersion().equals(maintainbleBean.getVersion())) {
                return null;
            }
            if (this.getChildReference() != null) {
                for (IdentifiableBean currentComposite : maintainbleBean.getIdentifiableComposites()) {
                    IdentifiableBean matchedIdentifiable = this.getChildReference().getMatch(currentComposite);
                    if (matchedIdentifiable == null) continue;
                    return matchedIdentifiable;
                }
            } else {
                return maintainbleBean;
            }
        }
        return null;
    }

    public int hashCode() {
        if (this.hashcode < 0) {
            String concat = "";
            if (this.childReference != null) {
                concat = " - Identifiable Reference " + this.childReference.toString();
            }
            MaintainableRefBean mRef = this.getMaintainableReference();
            String str = "Target: " + this.getTargetReference() + "Agency Id: " + mRef.getAgencyId() + " - " + "Maintainable Id: " + mRef.getMaintainableId() + " - " + "Version: " + mRef.getVersion() + concat;
            this.hashcode = str.hashCode();
        }
        return this.hashcode;
    }

    public String toString() {
        String concat = "";
        if (this.childReference != null) {
            concat = " - Identifiable Reference: " + this.childReference.toString();
        }
        MaintainableRefBean mRef = this.getMaintainableReference();
        return "Target: " + this.getTargetReference() + " - " + "Agency Id: " + mRef.getAgencyId() + " - " + "Maintainable Id: " + mRef.getMaintainableId() + " - " + "Version: " + mRef.getVersion() + concat;
    }
}

