/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.util.beans;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.sdmxsource.sdmx.api.model.beans.base.TextTypeWrapper;
import org.sdmxsource.util.ObjectUtil;

public class LocaleUtil {
    private static List<Locale> defaultLocales;

    public static List<Locale> getDefaultLocales() {
        if (defaultLocales == null) {
            defaultLocales = new ArrayList<Locale>();
            defaultLocales.add(Locale.ENGLISH);
        }
        return defaultLocales;
    }

    public void setDefaultLocale(Locale defaultLocale) {
        defaultLocales = new ArrayList<Locale>();
        defaultLocales.add(defaultLocale);
    }

    public void setDefaultLocale(List<Locale> defaultLocales) {
        LocaleUtil.defaultLocales = defaultLocales;
    }

    public static String getStringByDefaultLocale(Map<Locale, String> localToStringMap) {
        if (!ObjectUtil.validCollection(LocaleUtil.getDefaultLocales())) {
            throw new IllegalArgumentException("No Default Locale found");
        }
        for (Locale currentLocale : LocaleUtil.getDefaultLocales()) {
            String str = localToStringMap.get(currentLocale);
            if (!ObjectUtil.validString(str)) continue;
            return str;
        }
        return null;
    }

    public static Map<Locale, String> buildLocalMap(List<TextTypeWrapper> textTypes) {
        if (textTypes == null) {
            return null;
        }
        HashMap<Locale, String> buildLocalMap = new HashMap<Locale, String>();
        for (TextTypeWrapper currentTextType : textTypes) {
            String lang = currentTextType.getLocale();
            String value = currentTextType.getValue();
            Locale loc = new Locale(lang);
            buildLocalMap.put(loc, value);
        }
        return buildLocalMap;
    }
}

