/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.util.beans;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sdmxsource.sdmx.api.constants.ATTRIBUTE_ATTACHMENT_LEVEL;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.model.beans.datastructure.AttributeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DimensionBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.GroupBean;

public class DataStructureUtil {
    public static String getTimeConcept(DataStructureBean dataStructureBean) {
        if (dataStructureBean.getTimeDimension() != null) {
            return dataStructureBean.getTimeDimension().getId();
        }
        return null;
    }

    public static String getMeasureConcept(DataStructureBean dataStructureBean) {
        return dataStructureBean.getPrimaryMeasure().getId();
    }

    public static List<String> getSeriesKeyConcepts(DataStructureBean dataStructureBean) {
        ArrayList<String> keyConcepts = new ArrayList<String>();
        for (DimensionBean currentDimension : dataStructureBean.getDimensions(new SDMX_STRUCTURE_TYPE[]{SDMX_STRUCTURE_TYPE.DIMENSION})) {
            keyConcepts.add(currentDimension.getId());
        }
        return keyConcepts;
    }

    public static List<String> getSeriesAndGroupAttributeConcepts(DataStructureBean dataStructureBean) {
        ArrayList<String> attributeConcepts = new ArrayList<String>();
        if (dataStructureBean.getDimensionGroupAttributes() != null) {
            for (AttributeBean currentAttribute : dataStructureBean.getDimensionGroupAttributes()) {
                attributeConcepts.add(currentAttribute.getId());
            }
            for (AttributeBean currentAttribute : dataStructureBean.getGroupAttributes()) {
                if (attributeConcepts.contains(currentAttribute.getId())) continue;
                attributeConcepts.add(currentAttribute.getId());
            }
        }
        return attributeConcepts;
    }

    public static List<String> getSeriesAttributeConcepts(DataStructureBean dataStructureBean) {
        ArrayList<String> keyConcepts = new ArrayList<String>();
        for (AttributeBean currentBean : dataStructureBean.getDimensionGroupAttributes()) {
            keyConcepts.add(currentBean.getId());
        }
        return keyConcepts;
    }

    public static Map<String, List<String>> getGroupConcepts(DataStructureBean dataStructureBean) {
        HashMap<String, List<String>> returnMap = new HashMap<String, List<String>>();
        if (dataStructureBean.getGroups() != null) {
            for (GroupBean currentBean : dataStructureBean.getGroups()) {
                returnMap.put(currentBean.getId(), currentBean.getDimensionRefs());
            }
        }
        return returnMap;
    }

    public static List<String> getGroupAttributeConcepts(DataStructureBean dataStructureBean) {
        ArrayList<String> keyConcepts = new ArrayList<String>();
        for (AttributeBean currentBean : dataStructureBean.getGroupAttributes()) {
            keyConcepts.add(currentBean.getId());
        }
        return keyConcepts;
    }

    public static List<String> getObservationConcepts(DataStructureBean dataStructureBean) {
        ArrayList<String> obsConcepts = new ArrayList<String>();
        obsConcepts.add(DataStructureUtil.getMeasureConcept(dataStructureBean));
        if (dataStructureBean.getAttributes() != null) {
            for (AttributeBean currentAttribute : dataStructureBean.getAttributes()) {
                String conceptId = currentAttribute.getId();
                if (currentAttribute.getAttachmentLevel() != ATTRIBUTE_ATTACHMENT_LEVEL.OBSERVATION || obsConcepts.contains(conceptId)) continue;
                obsConcepts.add(conceptId);
            }
        }
        return obsConcepts;
    }
}

