/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.api.constants;

public enum TIME_FORMAT {
    YEAR("A", "Yearly"),
    HALF_OF_YEAR("S", "Half Yearly"),
    THIRD_OF_YEAR("T", "Trimesterly (Third of Year)"),
    QUARTER_OF_YEAR("Q", "Quarterly"),
    MONTH("M", "Monthly"),
    WEEK("W", "Weekly"),
    DATE("D", "Daily"),
    HOUR("H", "Hourly"),
    DATE_TIME("I", "Date Time");

    private String frequencyCode;
    private String readableCode;

    private TIME_FORMAT(String frequencyCode, String readableCode) {
        this.frequencyCode = frequencyCode;
        this.readableCode = readableCode;
    }

    public String getReadableCode() {
        return this.readableCode;
    }

    public String getFrequencyCodeId() {
        return this.frequencyCode;
    }

    public static TIME_FORMAT getTimeFormatFromCodeId(String codeId) {
        for (TIME_FORMAT currentTimeFormat : TIME_FORMAT.values()) {
            if (!currentTimeFormat.getFrequencyCodeId().equals(codeId)) continue;
            return currentTimeFormat;
        }
        StringBuilder sb = new StringBuilder();
        String concat = "";
        for (TIME_FORMAT currentTimeFormat : TIME_FORMAT.values()) {
            sb.append(concat + currentTimeFormat.getFrequencyCodeId());
            concat = ",";
        }
        throw new IllegalArgumentException("Time format can not be found for code id : " + codeId + " allowed values are : " + sb.toString());
    }
}

