/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.manager.impl;

import java.io.OutputStream;
import org.sdmxsource.sdmx.api.engine.ErrorWriterEngine;
import org.sdmxsource.sdmx.api.exception.SdmxNotImplementedException;
import org.sdmxsource.sdmx.api.factory.ErrorWriterFactory;
import org.sdmxsource.sdmx.api.manager.output.ErrorWriterManager;
import org.sdmxsource.sdmx.api.model.ErrorFormat;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class ErrorWriterManagerImpl
implements ErrorWriterManager,
ApplicationContextAware {
    private ApplicationContext applicationContext;

    public int writeError(Throwable th, OutputStream out, ErrorFormat format) {
        return this.getErrorWriterEngine(format).writeError(th, out);
    }

    private ErrorWriterEngine getErrorWriterEngine(ErrorFormat format) {
        for (ErrorWriterFactory factory : this.applicationContext.getBeansOfType(ErrorWriterFactory.class).values()) {
            ErrorWriterEngine engine = factory.getErrorWriterEngine(format);
            if (engine == null) continue;
            return engine;
        }
        throw new SdmxNotImplementedException("Could not write error out in format: " + format);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

