/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.engine.writing;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_SCHEMA;
import org.sdmxsource.sdmx.api.engine.StructureWriterEngine;
import org.sdmxsource.sdmx.api.exception.SdmxNotImplementedException;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.structureparser.engine.writing.SchemaLocationWriter;
import org.sdmxsource.sdmx.util.beans.container.SdmxBeansImpl;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractWritingEngine
implements StructureWriterEngine {
    private OutputStream outputStream;
    private boolean prettyfy;
    private SDMX_SCHEMA schemaVersion;
    @Autowired(required=false)
    private SchemaLocationWriter schemaLocationWriter;

    public AbstractWritingEngine(SDMX_SCHEMA schemaVersion, OutputStream outputStream, boolean prettyfy) {
        this.outputStream = outputStream;
        this.schemaVersion = schemaVersion;
        this.prettyfy = prettyfy;
    }

    public void writeStructure(MaintainableBean bean) {
        SdmxBeansImpl beans = new SdmxBeansImpl();
        beans.addIdentifiable((IdentifiableBean)bean);
        this.writeStructures((SdmxBeans)beans);
    }

    public void writeStructures(SdmxBeans beans) {
        XmlObject doc = this.build(beans);
        try {
            if (this.schemaLocationWriter != null) {
                String schemaUri = null;
                switch (this.schemaVersion) {
                    case VERSION_ONE: {
                        schemaUri = "http://www.SDMX.org/resources/SDMXML/schemas/v1_0/message";
                        break;
                    }
                    case VERSION_TWO: {
                        schemaUri = "http://www.SDMX.org/resources/SDMXML/schemas/v2_0/message";
                        break;
                    }
                    case VERSION_TWO_POINT_ONE: {
                        schemaUri = "http://www.sdmx.org/resources/sdmxml/schemas/v2_1/message";
                        break;
                    }
                    default: {
                        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"Schema Version " + this.schemaVersion});
                    }
                }
                this.schemaLocationWriter.writeSchemaLocation(doc, schemaUri);
            }
            if (this.prettyfy) {
                XmlOptions options = new XmlOptions();
                options.setSaveAggressiveNamespaces();
                options.setSavePrettyPrint();
                doc.save(this.outputStream, options);
            } else {
                doc.save(this.outputStream);
            }
            this.outputStream.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract XmlObject build(SdmxBeans var1);
}

