/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.engine.reversion;

import java.util.Map;
import java.util.Set;
import org.sdmxsource.sdmx.api.exception.CrossReferenceException;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.CategorisationBean;
import org.sdmxsource.sdmx.api.model.beans.categoryscheme.ReportingTaxonomyBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.HierarchicalCodelistBean;
import org.sdmxsource.sdmx.api.model.beans.conceptscheme.ConceptSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;
import org.sdmxsource.sdmx.api.model.beans.mapping.StructureSetBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.MetadataFlowBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.MetadataStructureDefinitionBean;
import org.sdmxsource.sdmx.api.model.beans.process.ProcessBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ProvisionAgreementBean;
import org.sdmxsource.sdmx.structureparser.engine.CategorisationCrossReferenceUpdaterEngine;
import org.sdmxsource.sdmx.structureparser.engine.ConceptSchemeCrossReferenceUpdaterEngine;
import org.sdmxsource.sdmx.structureparser.engine.CrossReferenceReversionEngine;
import org.sdmxsource.sdmx.structureparser.engine.DataStructureCrossReferenceUpdaterEngine;
import org.sdmxsource.sdmx.structureparser.engine.DataflowCrossReferenceUpdaterEngine;
import org.sdmxsource.sdmx.structureparser.engine.HierarchicCodelistCrossReferenceUpdaterEngine;
import org.sdmxsource.sdmx.structureparser.engine.MetadataStructureCrossReferenceUpdaterEngine;
import org.sdmxsource.sdmx.structureparser.engine.MetadataflowCrossReferenceUpdaterEngine;
import org.sdmxsource.sdmx.structureparser.engine.ProcessCrossReferenceUpdater;
import org.sdmxsource.sdmx.structureparser.engine.ProvisionCrossReferenceUpdaterEngine;
import org.sdmxsource.sdmx.structureparser.engine.ReportingTaxonomyBeanCrossReferenceUpdaterEngine;
import org.sdmxsource.sdmx.structureparser.engine.StructureSetCrossReferenceUpdaterEngine;
import org.sdmxsource.sdmx.structureretrieval.engine.impl.CrossReferenceResolverEngineImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CrossReferenceReversionEngineImpl
implements CrossReferenceReversionEngine {
    @Autowired
    private CategorisationCrossReferenceUpdaterEngine categorisationCrossReferenceUpdaterEngine;
    @Autowired
    private ConceptSchemeCrossReferenceUpdaterEngine conceptSchemeCrossReferenceUpdaterEngine;
    @Autowired
    private DataflowCrossReferenceUpdaterEngine dataflowCrossReferenceUpdaterEngine;
    @Autowired
    private DataStructureCrossReferenceUpdaterEngine dataStructureCrossReferenceUpdaterEngine;
    @Autowired
    private HierarchicCodelistCrossReferenceUpdaterEngine hierarchicCodelistCrossReferenceUpdaterEngine;
    @Autowired
    private MetadataflowCrossReferenceUpdaterEngine metadataflowCrossReferenceUpdaterEngine;
    @Autowired
    private MetadataStructureCrossReferenceUpdaterEngine metadataStructureCrossReferenceUpdaterEngine;
    @Autowired
    private ProcessCrossReferenceUpdater processCrossReferenceUpdater;
    @Autowired
    private ProvisionCrossReferenceUpdaterEngine provisionCrossReferenceUpdaterEngine;
    @Autowired
    private StructureSetCrossReferenceUpdaterEngine structureSetCrossReferenceUpdaterEngine;
    @Autowired
    private ReportingTaxonomyBeanCrossReferenceUpdaterEngine reportingTaxonomyBeanCrossReferenceUpdaterEngine;

    public Map<IdentifiableBean, Set<IdentifiableBean>> resolveReferences(SdmxBeans structures, boolean resolveAgencies, int resolutionDepth, SdmxBeanRetrievalManager retrievalManager) throws CrossReferenceException {
        CrossReferenceResolverEngineImpl crossRefResolver = new CrossReferenceResolverEngineImpl();
        return crossRefResolver.resolveReferences(structures, resolveAgencies, resolutionDepth, retrievalManager);
    }

    @Override
    public MaintainableBean udpateReferences(MaintainableBean maintianable, Map<StructureReferenceBean, StructureReferenceBean> updateReferences, String newVersionNumber) {
        switch (maintianable.getStructureType()) {
            case ATTACHMENT_CONSTRAINT: {
                break;
            }
            case CATEGORISATION: {
                return this.categorisationCrossReferenceUpdaterEngine.updateReferences((CategorisationBean)maintianable, updateReferences, newVersionNumber);
            }
            case CONCEPT_SCHEME: {
                return this.conceptSchemeCrossReferenceUpdaterEngine.updateReferences((ConceptSchemeBean)maintianable, updateReferences, newVersionNumber);
            }
            case CONTENT_CONSTRAINT: {
                break;
            }
            case DATAFLOW: {
                return this.dataflowCrossReferenceUpdaterEngine.updateReferences((DataflowBean)maintianable, updateReferences, newVersionNumber);
            }
            case DSD: {
                return this.dataStructureCrossReferenceUpdaterEngine.updateReferences((DataStructureBean)maintianable, updateReferences, newVersionNumber);
            }
            case HIERARCHICAL_CODELIST: {
                return this.hierarchicCodelistCrossReferenceUpdaterEngine.updateReferences((HierarchicalCodelistBean)maintianable, updateReferences, newVersionNumber);
            }
            case METADATA_FLOW: {
                return this.metadataflowCrossReferenceUpdaterEngine.updateReferences((MetadataFlowBean)maintianable, updateReferences, newVersionNumber);
            }
            case MSD: {
                return this.metadataStructureCrossReferenceUpdaterEngine.updateReferences((MetadataStructureDefinitionBean)maintianable, updateReferences, newVersionNumber);
            }
            case PROCESS: {
                return this.processCrossReferenceUpdater.updateReferences((ProcessBean)maintianable, updateReferences, newVersionNumber);
            }
            case PROVISION_AGREEMENT: {
                return this.provisionCrossReferenceUpdaterEngine.updateReferences((ProvisionAgreementBean)maintianable, updateReferences, newVersionNumber);
            }
            case REPORTING_TAXONOMY: {
                return this.reportingTaxonomyBeanCrossReferenceUpdaterEngine.updateReferences((ReportingTaxonomyBean)maintianable, updateReferences, newVersionNumber);
            }
            case STRUCTURE_SET: {
                return this.structureSetCrossReferenceUpdaterEngine.updateReferences((StructureSetBean)maintianable, updateReferences, newVersionNumber);
            }
        }
        return maintianable;
    }
}

