/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.assemblers;

import java.util.Collection;
import org.sdmx.resources.sdmxml.schemas.v21.common.LocalProcessStepReferenceType;
import org.sdmx.resources.sdmxml.schemas.v21.common.RefBaseType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ComputationType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.IdentifiableType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.InputOutputType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.NameableType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ProcessStepType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.TransitionType;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.model.beans.base.AnnotableBean;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.NameableBean;
import org.sdmxsource.sdmx.api.model.beans.process.ComputationBean;
import org.sdmxsource.sdmx.api.model.beans.process.InputOutputBean;
import org.sdmxsource.sdmx.api.model.beans.process.ProcessStepBean;
import org.sdmxsource.sdmx.api.model.beans.process.TransitionBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.assemblers.Assembler;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v21.assemblers.NameableBeanAssembler;
import org.sdmxsource.util.ObjectUtil;
import org.springframework.stereotype.Service;

@Service
public class ProcessStepBeanAssembler
extends NameableBeanAssembler
implements Assembler<ProcessStepType, ProcessStepBean> {
    @Override
    public void assemble(ProcessStepType assembleInto, ProcessStepBean assembleFrom) throws SdmxException {
        this.assembleNameable((NameableType)assembleInto, (NameableBean)assembleFrom);
        for (InputOutputBean currentInput : assembleFrom.getInput()) {
            this.assembleInputOutput(currentInput, assembleInto.addNewInput());
        }
        for (InputOutputBean currentOutput : assembleFrom.getOutput()) {
            this.assembleInputOutput(currentOutput, assembleInto.addNewOutput());
        }
        if (assembleFrom.getComputation() != null) {
            this.assembleComputation(assembleFrom.getComputation(), assembleInto.addNewComputation());
        }
        for (TransitionBean currentTranistion : assembleFrom.getTransitions()) {
            this.assembleTransition(currentTranistion, assembleInto.addNewTransition());
        }
        for (ProcessStepBean eachProcessStepBean : assembleFrom.getProcessSteps()) {
            ProcessStepType eachProcessStep = assembleInto.addNewProcessStep();
            this.assemble(eachProcessStep, eachProcessStepBean);
        }
    }

    private void assembleInputOutput(InputOutputBean currentInput, InputOutputType ioType) {
        if (ObjectUtil.validString((String[])new String[]{currentInput.getLocalId()})) {
            ioType.setLocalID(currentInput.getLocalId());
        }
        if (this.hasAnnotations((AnnotableBean)currentInput)) {
            ioType.setAnnotations(this.getAnnotationsType((AnnotableBean)currentInput));
        }
        if (currentInput.getStructureReference() != null) {
            super.setReference(ioType.addNewObjectReference().addNewRef(), (StructureReferenceBean)currentInput.getStructureReference());
        }
    }

    private void assembleComputation(ComputationBean computationBean, ComputationType computationType) {
        if (ObjectUtil.validString((String[])new String[]{computationBean.getLocalId()})) {
            computationType.setLocalID(computationBean.getLocalId());
        }
        if (ObjectUtil.validString((String[])new String[]{computationBean.getSoftwarePackage()})) {
            computationType.setSoftwarePackage(computationBean.getSoftwarePackage());
        }
        if (ObjectUtil.validString((String[])new String[]{computationBean.getSoftwareLanguage()})) {
            computationType.setSoftwareLanguage(computationBean.getSoftwareLanguage());
        }
        if (ObjectUtil.validString((String[])new String[]{computationBean.getSoftwareVersion()})) {
            computationType.setSoftwareVersion(computationBean.getSoftwareVersion());
        }
        if (this.hasAnnotations((AnnotableBean)computationBean)) {
            computationType.setAnnotations(this.getAnnotationsType((AnnotableBean)computationBean));
        }
        if (this.validCollection(computationBean.getDescription())) {
            computationType.setDescriptionArray(this.getTextType(computationBean.getDescription()));
        }
    }

    private void assembleTransition(TransitionBean transitionBean, TransitionType transitionType) {
        if (ObjectUtil.validString((String[])new String[]{transitionBean.getLocalId()})) {
            transitionType.setLocalID(transitionBean.getLocalId());
        }
        super.assembleIdentifiable((IdentifiableType)transitionType, (IdentifiableBean)transitionBean);
        if (transitionBean.getTargetStep() != null) {
            LocalProcessStepReferenceType procRef = transitionType.addNewTargetStep();
            RefBaseType ref = procRef.addNewRef();
            ref.setId(transitionBean.getTargetStep().getFullIdPath(false));
        }
        if (ObjectUtil.validCollection((Collection)transitionBean.getCondition())) {
            transitionType.setConditionArray(this.getTextType(transitionBean.getCondition()));
        } else {
            transitionType.addNewCondition();
        }
    }
}

