/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2;

import java.util.Collection;
import java.util.Date;
import org.sdmx.resources.sdmxml.schemas.v20.common.ActionType;
import org.sdmx.resources.sdmxml.schemas.v20.common.TextType;
import org.sdmx.resources.sdmxml.schemas.v20.message.ContactType;
import org.sdmx.resources.sdmxml.schemas.v20.message.HeaderType;
import org.sdmx.resources.sdmxml.schemas.v20.message.PartyType;
import org.sdmxsource.sdmx.api.builder.Builder;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.model.beans.base.ContactBean;
import org.sdmxsource.sdmx.api.model.beans.base.TextTypeWrapper;
import org.sdmxsource.sdmx.api.model.header.HeaderBean;
import org.sdmxsource.sdmx.api.model.header.PartyBean;
import org.sdmxsource.sdmx.util.date.DateUtil;
import org.sdmxsource.util.ObjectUtil;
import org.springframework.stereotype.Service;

@Service(value="StructureHeaderXmlBeanBuilderV2")
public class StructureHeaderXmlBeanBuilder
implements Builder<HeaderType, HeaderBean> {
    public HeaderType build(HeaderBean buildFrom) throws SdmxException {
        TextType tt;
        HeaderType headerType = HeaderType.Factory.newInstance();
        if (ObjectUtil.validString((String[])new String[]{buildFrom.getId()})) {
            headerType.setID(buildFrom.getId());
        }
        headerType.setTest(buildFrom.isTest());
        if (buildFrom.getAction() != null) {
            switch (buildFrom.getAction()) {
                case APPEND: {
                    headerType.setDataSetAction(ActionType.APPEND);
                    break;
                }
                case REPLACE: {
                    headerType.setDataSetAction(ActionType.REPLACE);
                    break;
                }
                case DELETE: {
                    headerType.setDataSetAction(ActionType.DELETE);
                    break;
                }
                case INFORMATION: {
                    headerType.setDataSetAction(ActionType.INFORMATION);
                }
            }
        }
        if (buildFrom.getName() != null) {
            for (TextTypeWrapper ttw : buildFrom.getName()) {
                tt = headerType.addNewName();
                tt.setLang(ttw.getLocale());
                tt.setStringValue(ttw.getValue());
            }
        }
        if (buildFrom.getSource() != null) {
            for (TextTypeWrapper ttw : buildFrom.getSource()) {
                tt = headerType.addNewSource();
                tt.setLang(ttw.getLocale());
                tt.setStringValue(ttw.getValue());
            }
        }
        if (buildFrom.getExtracted() != null) {
            headerType.setExtracted(DateUtil.createCalendar((Date)buildFrom.getExtracted()));
        }
        if (buildFrom.getPrepared() != null) {
            headerType.setPrepared(DateUtil.createCalendar((Date)buildFrom.getPrepared()));
        }
        if (buildFrom.getReportingBegin() != null) {
            headerType.setReportingBegin(DateUtil.createCalendar((Date)buildFrom.getReportingBegin()));
        }
        if (buildFrom.getReportingEnd() != null) {
            headerType.setReportingEnd(DateUtil.createCalendar((Date)buildFrom.getReportingEnd()));
        }
        if (buildFrom.getSender() != null) {
            PartyBean sender = buildFrom.getSender();
            PartyType senderType = headerType.addNewSender();
            if (ObjectUtil.validString((String[])new String[]{sender.getId()})) {
                senderType.setId(sender.getId());
            }
            for (TextTypeWrapper ttw : sender.getName()) {
                TextType tt2 = senderType.addNewName();
                tt2.setLang(ttw.getLocale());
                tt2.setStringValue(ttw.getValue());
            }
            for (ContactBean contact : sender.getContacts()) {
                this.buildContact(senderType.addNewContact(), contact);
            }
        }
        if (buildFrom.getReceiver() != null) {
            for (PartyBean receiver : buildFrom.getReceiver()) {
                PartyType receiverType = headerType.addNewReceiver();
                if (ObjectUtil.validString((String[])new String[]{receiver.getId()})) {
                    receiverType.setId(receiver.getId());
                }
                for (TextTypeWrapper ttw : receiver.getName()) {
                    TextType tt3 = receiverType.addNewName();
                    tt3.setLang(ttw.getLocale());
                    tt3.setStringValue(ttw.getValue());
                }
                for (ContactBean contact : receiver.getContacts()) {
                    this.buildContact(receiverType.addNewContact(), contact);
                }
            }
        }
        if (!ObjectUtil.validCollection((Collection)headerType.getReceiverList())) {
            PartyType receiverType = headerType.addNewReceiver();
            receiverType.setId("unknown");
        }
        return headerType;
    }

    private void buildContact(ContactType contactType, ContactBean contact) {
        TextType tt;
        if (contact.getDepartments() != null) {
            for (TextTypeWrapper ttw : contact.getDepartments()) {
                tt = contactType.addNewDepartment();
                tt.setLang(ttw.getLocale());
                tt.setStringValue(ttw.getValue());
            }
        }
        if (contact.getName() != null) {
            for (TextTypeWrapper ttw : contact.getName()) {
                tt = contactType.addNewName();
                tt.setLang(ttw.getLocale());
                tt.setStringValue(ttw.getValue());
            }
        }
        if (contact.getRole() != null) {
            for (TextTypeWrapper ttw : contact.getRole()) {
                tt = contactType.addNewRole();
                tt.setLang(ttw.getLocale());
                tt.setStringValue(ttw.getValue());
            }
        }
        if (contact.getEmail() != null) {
            for (String val : contact.getEmail()) {
                contactType.addEmail(val);
            }
        }
        if (contact.getFax() != null) {
            for (String val : contact.getFax()) {
                contactType.addFax(val);
            }
        }
        if (contact.getTelephone() != null) {
            for (String val : contact.getTelephone()) {
                contactType.addTelephone(val);
            }
        }
        if (contact.getUri() != null) {
            for (String val : contact.getUri()) {
                contactType.addURI(val);
            }
        }
        if (contact.getX400() != null) {
            for (String val : contact.getX400()) {
                contactType.addX400(val);
            }
        }
    }
}

