/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2;

import java.util.Collection;
import org.sdmx.resources.sdmxml.schemas.v20.structure.ProcessStepType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.ProcessType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.TransitionType;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.model.beans.base.AnnotableBean;
import org.sdmxsource.sdmx.api.model.beans.base.TextTypeWrapper;
import org.sdmxsource.sdmx.api.model.beans.process.InputOutputBean;
import org.sdmxsource.sdmx.api.model.beans.process.ProcessBean;
import org.sdmxsource.sdmx.api.model.beans.process.ProcessStepBean;
import org.sdmxsource.sdmx.api.model.beans.process.TransitionBean;
import org.sdmxsource.sdmx.sdmxbeans.util.XmlBeansEnumUtil;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.AbstractBuilder;
import org.sdmxsource.util.ObjectUtil;
import org.springframework.stereotype.Service;

@Service(value="ProcessXmlBeanBuilderV2")
public class ProcessXmlBeanBuilder
extends AbstractBuilder {
    public ProcessType build(ProcessBean buildFrom) throws SdmxException {
        ProcessType builtObj = ProcessType.Factory.newInstance();
        if (this.validString(buildFrom.getAgencyId())) {
            builtObj.setAgencyID(buildFrom.getAgencyId());
        }
        if (this.validString(buildFrom.getId())) {
            builtObj.setId(buildFrom.getId());
        }
        if (buildFrom.getUri() != null) {
            builtObj.setUri(buildFrom.getUri().toString());
        } else if (buildFrom.getStructureURL() != null) {
            builtObj.setUri(buildFrom.getStructureURL().toString());
        } else if (buildFrom.getServiceURL() != null) {
            builtObj.setUri(buildFrom.getStructureURL().toString());
        }
        if (this.validString(buildFrom.getUrn())) {
            builtObj.setUrn(buildFrom.getUrn());
        }
        if (this.validString(buildFrom.getVersion())) {
            builtObj.setVersion(buildFrom.getVersion());
        }
        if (buildFrom.getStartDate() != null) {
            builtObj.setValidFrom((Object)buildFrom.getStartDate());
        }
        if (buildFrom.getEndDate() != null) {
            builtObj.setValidTo((Object)buildFrom.getEndDate());
        }
        if (this.validCollection(buildFrom.getNames())) {
            builtObj.setNameArray(this.getTextType(buildFrom.getNames()));
        }
        if (this.validCollection(buildFrom.getDescriptions())) {
            builtObj.setDescriptionArray(this.getTextType(buildFrom.getDescriptions()));
        }
        if (this.hasAnnotations((AnnotableBean)buildFrom)) {
            builtObj.setAnnotations(this.getAnnotationsType((AnnotableBean)buildFrom));
        }
        if (buildFrom.isExternalReference().isSet()) {
            builtObj.setIsExternalReference(buildFrom.isExternalReference().isTrue());
        }
        if (buildFrom.isFinal().isSet()) {
            builtObj.setIsFinal(buildFrom.isFinal().isTrue());
        }
        for (ProcessStepBean processStep : buildFrom.getProcessSteps()) {
            ProcessStepType processStepType = builtObj.addNewProcessStep();
            this.processProcessStep(processStep, processStepType);
        }
        return builtObj;
    }

    private void processProcessStep(ProcessStepBean buildFrom, ProcessStepType builtObj) {
        if (this.validString(buildFrom.getId())) {
            builtObj.setId(buildFrom.getId());
        }
        if (this.validCollection(buildFrom.getNames())) {
            builtObj.setNameArray(this.getTextType(buildFrom.getNames()));
        }
        if (this.validCollection(buildFrom.getInput())) {
            for (InputOutputBean ioBean : buildFrom.getInput()) {
                if (ioBean.getStructureReference() == null) continue;
                builtObj.addInput(XmlBeansEnumUtil.getSdmxObjectIdType((SDMX_STRUCTURE_TYPE)ioBean.getStructureReference().getTargetReference()));
            }
        }
        if (this.validCollection(buildFrom.getOutput())) {
            for (InputOutputBean ioBean : buildFrom.getOutput()) {
                if (ioBean.getStructureReference() == null) continue;
                builtObj.addOutput(XmlBeansEnumUtil.getSdmxObjectIdType((SDMX_STRUCTURE_TYPE)ioBean.getStructureReference().getTargetReference()));
            }
        }
        if (buildFrom.getComputation() != null) {
            builtObj.setComputationArray(this.getTextType(buildFrom.getComputation().getDescription()));
        }
        if (this.validCollection(buildFrom.getTransitions())) {
            for (TransitionBean transition : buildFrom.getTransitions()) {
                TransitionType transitionType = builtObj.addNewTransition();
                if (transition.getTargetStep() != null) {
                    transitionType.setTargetStep(transition.getTargetStep().getId());
                }
                if (!ObjectUtil.validCollection((Collection)transition.getCondition())) continue;
                transitionType.setCondition(this.getTextType((TextTypeWrapper)transition.getCondition().get(0)));
            }
        }
        if (this.validCollection(buildFrom.getProcessSteps())) {
            for (ProcessStepBean processStep : buildFrom.getProcessSteps()) {
                ProcessStepType newProcessStepType = builtObj.addNewProcessStep();
                this.processProcessStep(processStep, newProcessStepType);
            }
        }
        if (this.hasAnnotations((AnnotableBean)buildFrom)) {
            builtObj.setAnnotations(this.getAnnotationsType((AnnotableBean)buildFrom));
        }
    }
}

