/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2;

import java.util.Collection;
import org.sdmx.resources.sdmxml.schemas.v20.structure.CodeRefType;
import org.sdmxsource.sdmx.api.builder.Builder;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.model.beans.codelist.HierarchicalCodeBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2.AbstractBuilder;
import org.sdmxsource.util.ObjectUtil;
import org.springframework.stereotype.Service;

@Service(value="CodeRefXmlBeanBuilderV2")
public class CodeRefXmlBeanBuilder
extends AbstractBuilder
implements Builder<CodeRefType, HierarchicalCodeBean> {
    public CodeRefType build(HierarchicalCodeBean buildFrom) throws SdmxException {
        CodeRefType builtObj = CodeRefType.Factory.newInstance();
        if (this.validString(buildFrom.getCodeId())) {
            builtObj.setCodeID(buildFrom.getCodeId());
        }
        if (this.validString(buildFrom.getId())) {
            builtObj.setNodeAliasID(buildFrom.getId());
        }
        if (this.validString(buildFrom.getCodelistAliasRef())) {
            builtObj.setCodelistAliasRef(buildFrom.getCodelistAliasRef());
        } else {
            CrossReferenceBean crossRefernce = buildFrom.getCodeReference();
            if (crossRefernce != null) {
                builtObj.setURN(crossRefernce.getTargetUrn());
            }
        }
        if (buildFrom.getValidFrom() != null) {
            builtObj.setValidFrom((Object)buildFrom.getValidFrom().getDate());
        }
        if (buildFrom.getValidTo() != null) {
            builtObj.setValidTo((Object)buildFrom.getValidTo().getDate());
        }
        if (buildFrom.getLevel(false) != null) {
            builtObj.setLevelRef(buildFrom.getLevel(false).getId());
        }
        if (ObjectUtil.validCollection((Collection)buildFrom.getCodeRefs())) {
            for (HierarchicalCodeBean currentCodeRef : buildFrom.getCodeRefs()) {
                builtObj.getCodeRefList().add(this.build(currentCodeRef));
            }
        }
        return builtObj;
    }
}

