/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v2;

import java.util.Collection;
import java.util.List;
import org.apache.xmlbeans.GDuration;
import org.sdmx.resources.sdmxml.schemas.v20.common.AnnotationType;
import org.sdmx.resources.sdmxml.schemas.v20.common.AnnotationsType;
import org.sdmx.resources.sdmxml.schemas.v20.common.TextType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.DataProviderRefType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.DataflowRefType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.MetadataflowRefType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.TextFormatType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.TextTypeType;
import org.sdmxsource.sdmx.api.model.beans.base.AnnotableBean;
import org.sdmxsource.sdmx.api.model.beans.base.AnnotationBean;
import org.sdmxsource.sdmx.api.model.beans.base.TextFormatBean;
import org.sdmxsource.sdmx.api.model.beans.base.TextTypeWrapper;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.util.ObjectUtil;

public class AbstractBuilder {
    boolean validString(String string) {
        return ObjectUtil.validString((String[])new String[]{string});
    }

    boolean validCollection(Collection collection) {
        return ObjectUtil.validCollection((Collection)collection);
    }

    void populateTextFormatType(TextFormatType textFormatType, TextFormatBean textFormat) {
        if (textFormat.getTextType() != null) {
            switch (textFormat.getTextType()) {
                case BIG_INTEGER: {
                    textFormatType.setTextType(TextTypeType.BIG_INTEGER);
                    break;
                }
                case BOOLEAN: {
                    textFormatType.setTextType(TextTypeType.BOOLEAN);
                    break;
                }
                case COUNT: {
                    textFormatType.setTextType(TextTypeType.COUNT);
                    break;
                }
                case DATE: {
                    textFormatType.setTextType(TextTypeType.DATE);
                    break;
                }
                case DATE_TIME: {
                    textFormatType.setTextType(TextTypeType.DATE_TIME);
                    break;
                }
                case DAY: {
                    textFormatType.setTextType(TextTypeType.DAY);
                    break;
                }
                case DECIMAL: {
                    textFormatType.setTextType(TextTypeType.DECIMAL);
                    break;
                }
                case DOUBLE: {
                    textFormatType.setTextType(TextTypeType.DOUBLE);
                    break;
                }
                case DURATION: {
                    textFormatType.setTextType(TextTypeType.DURATION);
                    break;
                }
                case EXCLUSIVE_VALUE_RANGE: {
                    textFormatType.setTextType(TextTypeType.EXCLUSIVE_VALUE_RANGE);
                    break;
                }
                case FLOAT: {
                    textFormatType.setTextType(TextTypeType.FLOAT);
                    break;
                }
                case INCLUSIVE_VALUE_RANGE: {
                    textFormatType.setTextType(TextTypeType.INCLUSIVE_VALUE_RANGE);
                    break;
                }
                case INCREMENTAL: {
                    textFormatType.setTextType(TextTypeType.INCREMENTAL);
                    break;
                }
                case LONG: {
                    textFormatType.setTextType(TextTypeType.LONG);
                    break;
                }
                case MONTH: {
                    textFormatType.setTextType(TextTypeType.MONTH);
                    break;
                }
                case MONTH_DAY: {
                    textFormatType.setTextType(TextTypeType.MONTH_DAY);
                    break;
                }
                case OBSERVATIONAL_TIME_PERIOD: {
                    textFormatType.setTextType(TextTypeType.OBSERVATIONAL_TIME_PERIOD);
                    break;
                }
                case SHORT: {
                    textFormatType.setTextType(TextTypeType.SHORT);
                    break;
                }
                case STRING: {
                    textFormatType.setTextType(TextTypeType.STRING);
                    break;
                }
                case TIME: {
                    textFormatType.setTextType(TextTypeType.TIME);
                    break;
                }
                case TIMESPAN: {
                    textFormatType.setTextType(TextTypeType.TIMESPAN);
                    break;
                }
                case URI: {
                    textFormatType.setTextType(TextTypeType.URI);
                    break;
                }
                case YEAR: {
                    textFormatType.setTextType(TextTypeType.YEAR);
                    break;
                }
                case YEAR_MONTH: {
                    textFormatType.setTextType(TextTypeType.YEAR_MONTH);
                }
            }
        }
        if (this.validString(textFormat.getPattern())) {
            textFormatType.setPattern(textFormat.getPattern());
        }
        if (this.validString(textFormat.getTimeInterval())) {
            textFormatType.setTimeInterval(new GDuration((CharSequence)textFormat.getTimeInterval()));
        }
        if (textFormat.getDecimals() != null) {
            textFormatType.setDecimals(textFormat.getDecimals());
        }
        if (textFormat.getEndValue() != null) {
            textFormatType.setEndValue(textFormat.getEndValue().doubleValue());
        }
        if (textFormat.getInterval() != null) {
            textFormatType.setInterval(textFormat.getInterval().doubleValue());
        }
        if (textFormat.getMaxLength() != null) {
            textFormatType.setMaxLength(textFormat.getMaxLength());
        }
        if (textFormat.getMinLength() != null) {
            textFormatType.setMinLength(textFormat.getMinLength());
        }
        if (textFormat.getStartValue() != null) {
            textFormatType.setStartValue(textFormat.getStartValue().doubleValue());
        }
        if (textFormat.getSequence().isSet()) {
            textFormatType.setIsSequence(textFormat.getSequence().isTrue());
        }
    }

    TextType[] getTextType(List<TextTypeWrapper> ttWrapper) {
        if (!ObjectUtil.validCollection(ttWrapper)) {
            return null;
        }
        TextType[] ttArr = new TextType[ttWrapper.size()];
        int i = 0;
        while (i < ttWrapper.size()) {
            TextType tt;
            ttArr[i] = tt = this.getTextType(ttWrapper.get(i));
            ++i;
        }
        return ttArr;
    }

    TextType getTextType(TextTypeWrapper ttWrapper) {
        TextType tt = TextType.Factory.newInstance();
        tt.setLang(ttWrapper.getLocale());
        tt.setStringValue(ttWrapper.getValue());
        return tt;
    }

    TextType getTextType(String englishString) {
        TextType tt = TextType.Factory.newInstance();
        tt.setLang("en");
        tt.setStringValue(englishString);
        return tt;
    }

    void setDefaultText(TextType tt) {
        tt.setLang("en");
        tt.setStringValue("Undefined");
    }

    boolean hasAnnotations(AnnotableBean annotable) {
        return ObjectUtil.validCollection((Collection)annotable.getAnnotations());
    }

    AnnotationsType getAnnotationsType(AnnotableBean annotable) {
        if (!ObjectUtil.validCollection((Collection)annotable.getAnnotations())) {
            return null;
        }
        AnnotationsType returnType = AnnotationsType.Factory.newInstance();
        for (AnnotationBean currentAnnotationBean : annotable.getAnnotations()) {
            AnnotationType annotation = returnType.addNewAnnotation();
            if (ObjectUtil.validCollection((Collection)currentAnnotationBean.getText())) {
                annotation.setAnnotationTextArray(this.getTextType(currentAnnotationBean.getText()));
            }
            if (ObjectUtil.validString((String[])new String[]{currentAnnotationBean.getTitle()})) {
                annotation.setAnnotationTitle(currentAnnotationBean.getTitle());
            }
            if (ObjectUtil.validString((String[])new String[]{currentAnnotationBean.getType()})) {
                annotation.setAnnotationType(currentAnnotationBean.getType());
            }
            if (currentAnnotationBean.getUri() == null) continue;
            annotation.setAnnotationURL(currentAnnotationBean.getUri().toString());
        }
        return returnType;
    }

    void populateDataflowRef(CrossReferenceBean crossReference, DataflowRefType dfRef) {
        MaintainableRefBean maintRef = crossReference.getMaintainableReference();
        if (this.validString(crossReference.getTargetUrn())) {
            dfRef.setURN(crossReference.getTargetUrn());
        }
        if (this.validString(maintRef.getAgencyId())) {
            dfRef.setAgencyID(maintRef.getAgencyId());
        }
        if (this.validString(maintRef.getMaintainableId())) {
            dfRef.setDataflowID(maintRef.getMaintainableId());
        }
        if (this.validString(maintRef.getVersion())) {
            dfRef.setVersion(maintRef.getVersion());
        }
    }

    void populateMetadataflowRef(CrossReferenceBean crossReference, MetadataflowRefType mdfRef) {
        MaintainableRefBean maintRef = crossReference.getMaintainableReference();
        if (this.validString(crossReference.getTargetUrn())) {
            mdfRef.setURN(crossReference.getTargetUrn());
        }
        if (this.validString(maintRef.getAgencyId())) {
            mdfRef.setAgencyID(maintRef.getAgencyId());
        }
        if (this.validString(maintRef.getMaintainableId())) {
            mdfRef.setMetadataflowID(maintRef.getMaintainableId());
        }
        if (this.validString(maintRef.getVersion())) {
            mdfRef.setVersion(maintRef.getVersion());
        }
    }

    void populateDataproviderRef(CrossReferenceBean crossReference, DataProviderRefType dpRef) {
        MaintainableRefBean maintRef = crossReference.getMaintainableReference();
        if (this.validString(crossReference.getTargetUrn())) {
            dpRef.setURN(crossReference.getTargetUrn());
        }
        if (this.validString(maintRef.getAgencyId())) {
            dpRef.setOrganisationSchemeAgencyID(maintRef.getAgencyId());
        }
        if (this.validString(maintRef.getMaintainableId())) {
            dpRef.setOrganisationSchemeID(maintRef.getMaintainableId());
        }
        if (this.validString(maintRef.getVersion())) {
            dpRef.setVersion(maintRef.getVersion());
        }
        if (this.validString(crossReference.getChildReference().getId())) {
            dpRef.setDataProviderID(crossReference.getChildReference().getId());
        }
    }
}

