/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v1;

import org.apache.log4j.Logger;
import org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.structure.AssignmentStatusType;
import org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.structure.AttachmentLevelType;
import org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.structure.AttributeType;
import org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.structure.TextFormatType;
import org.sdmxsource.sdmx.api.builder.Builder;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.model.beans.base.AnnotableBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.AttributeBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.v1.AbstractBuilder;
import org.sdmxsource.sdmx.util.beans.ConceptRefUtil;
import org.sdmxsource.util.ObjectUtil;
import org.springframework.stereotype.Service;

@Service(value="AttributeXmlBeanBuilderV1")
public class AttributeXmlBeanBuilder
extends AbstractBuilder
implements Builder<AttributeType, AttributeBean> {
    static {
        AbstractBuilder.log = Logger.getLogger(AttributeXmlBeanBuilder.class);
    }

    public AttributeType build(AttributeBean buildFrom) throws SdmxException {
        AttributeType builtObj = AttributeType.Factory.newInstance();
        if (this.hasAnnotations((AnnotableBean)buildFrom)) {
            builtObj.setAnnotations(this.getAnnotationsType((AnnotableBean)buildFrom));
        }
        if (this.validString(buildFrom.getAssignmentStatus())) {
            if (buildFrom.getAssignmentStatus().equals(AssignmentStatusType.CONDITIONAL.toString())) {
                builtObj.setAssignmentStatus(AssignmentStatusType.CONDITIONAL);
            } else if (buildFrom.getAssignmentStatus().equals(AssignmentStatusType.MANDATORY.toString())) {
                builtObj.setAssignmentStatus(AssignmentStatusType.MANDATORY);
            } else {
                throw new IllegalArgumentException("Unknown assignment status: " + buildFrom.getAssignmentStatus());
            }
        }
        if (ObjectUtil.validString((String[])new String[]{buildFrom.getAttachmentGroup()})) {
            String[] arr = new String[]{buildFrom.getAttachmentGroup()};
            builtObj.setAttachmentGroupArray(arr);
        }
        if (buildFrom.getAttachmentLevel() != null) {
            switch (buildFrom.getAttachmentLevel()) {
                case DATA_SET: {
                    builtObj.setAttachmentLevel(AttachmentLevelType.DATA_SET);
                    break;
                }
                case DIMENSION_GROUP: {
                    builtObj.setAttachmentLevel(AttachmentLevelType.SERIES);
                    break;
                }
                case OBSERVATION: {
                    builtObj.setAttachmentLevel(AttachmentLevelType.OBSERVATION);
                    break;
                }
                case GROUP: {
                    builtObj.setAttachmentLevel(AttachmentLevelType.GROUP);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown attachment level: " + buildFrom.getAttachmentLevel());
                }
            }
        }
        if (buildFrom.hasCodedRepresentation()) {
            builtObj.setCodelist(buildFrom.getRepresentation().getRepresentation().getMaintainableReference().getMaintainableId());
        }
        if (buildFrom.getConceptRef() != null) {
            builtObj.setConcept(ConceptRefUtil.getConceptId((StructureReferenceBean)buildFrom.getConceptRef()));
        }
        if (buildFrom.getId().equals("TIME_FORMAT")) {
            builtObj.setIsTimeFormat(true);
        }
        if (buildFrom.getRepresentation() != null && buildFrom.getRepresentation().getTextFormat() != null) {
            TextFormatType textFormatType = TextFormatType.Factory.newInstance();
            this.populateTextFormatType(textFormatType, buildFrom.getRepresentation().getTextFormat());
            builtObj.setTextFormat(textFormatType);
        }
        return builtObj;
    }
}

