/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.query.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.sdmx.resources.sdmxml.schemas.v20.message.QueryMessageType;
import org.sdmx.resources.sdmxml.schemas.v20.query.CategorySchemeWhereType;
import org.sdmx.resources.sdmxml.schemas.v20.query.QueryType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.AgencyRefType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.CategorySchemeRefType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.DataProviderRefType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.DataflowRefType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.MetadataflowRefType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.ProvisionAgreementRefType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.QueryProvisioningRequestType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.QueryRegistrationRequestType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.QueryStructureRequestType;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxNotImplementedException;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.util.beans.reference.StructureReferenceBeanImpl;
import org.sdmxsource.util.ObjectUtil;
import org.springframework.stereotype.Service;

@Service
public class QueryBeanBuilderV2 {
    public List<StructureReferenceBean> build(QueryStructureRequestType queryStructureRequests) {
        String version;
        String maintId;
        String agencyId;
        String urn;
        ArrayList<StructureReferenceBean> reutrnList = new ArrayList<StructureReferenceBean>();
        if (queryStructureRequests.getAgencyRefList() != null) {
            for (AgencyRefType agencyRefType : queryStructureRequests.getAgencyRefList()) {
                urn = agencyRefType.getURN();
                if (ObjectUtil.validString((String[])new String[]{urn})) {
                    reutrnList.add((StructureReferenceBean)new StructureReferenceBeanImpl(urn));
                    continue;
                }
                agencyId = agencyRefType.getAgencyID();
                maintId = agencyRefType.getOrganisationSchemeID();
                version = agencyRefType.getOrganisationSchemeAgencyID();
                reutrnList.add((StructureReferenceBean)new StructureReferenceBeanImpl(agencyId, maintId, version, SDMX_STRUCTURE_TYPE.AGENCY, new String[0]));
            }
        }
        if (queryStructureRequests.getCategorySchemeRefList() != null) {
            for (CategorySchemeRefType refType : queryStructureRequests.getCategorySchemeRefList()) {
                urn = refType.getURN();
                if (ObjectUtil.validString((String[])new String[]{urn})) {
                    reutrnList.add((StructureReferenceBean)new StructureReferenceBeanImpl(urn));
                    continue;
                }
                agencyId = refType.getAgencyID();
                maintId = refType.getCategorySchemeID();
                version = refType.getVersion();
                reutrnList.add((StructureReferenceBean)new StructureReferenceBeanImpl(agencyId, maintId, version, SDMX_STRUCTURE_TYPE.CATEGORY_SCHEME, new String[0]));
            }
        }
        if (queryStructureRequests.getCodelistRefList() != null) {
            for (CategorySchemeRefType refType : queryStructureRequests.getCodelistRefList()) {
                urn = refType.getURN();
                if (ObjectUtil.validString((String[])new String[]{urn})) {
                    reutrnList.add((StructureReferenceBean)new StructureReferenceBeanImpl(urn));
                    continue;
                }
                agencyId = refType.getAgencyID();
                maintId = refType.getCodelistID();
                version = refType.getVersion();
                reutrnList.add((StructureReferenceBean)new StructureReferenceBeanImpl(agencyId, maintId, version, SDMX_STRUCTURE_TYPE.CODE_LIST, new String[0]));
            }
        }
        if (queryStructureRequests.getConceptSchemeRefList() != null) {
            for (CategorySchemeRefType refType : queryStructureRequests.getConceptSchemeRefList()) {
                urn = refType.getURN();
                if (ObjectUtil.validString((String[])new String[]{urn})) {
                    reutrnList.add((StructureReferenceBean)new StructureReferenceBeanImpl(urn));
                    continue;
                }
                agencyId = refType.getAgencyID();
                maintId = refType.getConceptSchemeID();
                version = refType.getVersion();
                reutrnList.add((StructureReferenceBean)new StructureReferenceBeanImpl(agencyId, maintId, version, SDMX_STRUCTURE_TYPE.CONCEPT_SCHEME, new String[0]));
            }
        }
        if (queryStructureRequests.getDataflowRefList() != null) {
            for (CategorySchemeRefType refType : queryStructureRequests.getDataflowRefList()) {
                reutrnList.add(this.buildDataflowQuery((DataflowRefType)refType));
            }
        }
        if (queryStructureRequests.getDataProviderRefList() != null) {
            for (CategorySchemeRefType refType : queryStructureRequests.getDataProviderRefList()) {
                urn = refType.getURN();
                if (ObjectUtil.validString((String[])new String[]{urn})) {
                    reutrnList.add((StructureReferenceBean)new StructureReferenceBeanImpl(urn));
                    continue;
                }
                agencyId = refType.getOrganisationSchemeAgencyID();
                maintId = refType.getOrganisationSchemeAgencyID();
                version = refType.getVersion();
                String id = refType.getDataProviderID();
                reutrnList.add((StructureReferenceBean)new StructureReferenceBeanImpl(agencyId, maintId, version, SDMX_STRUCTURE_TYPE.DATA_PROVIDER, new String[]{id}));
            }
        }
        if (queryStructureRequests.getHierarchicalCodelistRefList() != null) {
            for (CategorySchemeRefType refType : queryStructureRequests.getHierarchicalCodelistRefList()) {
                urn = refType.getURN();
                if (ObjectUtil.validString((String[])new String[]{urn})) {
                    reutrnList.add((StructureReferenceBean)new StructureReferenceBeanImpl(urn));
                    continue;
                }
                agencyId = refType.getAgencyID();
                maintId = refType.getHierarchicalCodelistID();
                version = refType.getVersion();
                reutrnList.add((StructureReferenceBean)new StructureReferenceBeanImpl(agencyId, maintId, version, SDMX_STRUCTURE_TYPE.HIERARCHICAL_CODELIST, new String[0]));
            }
        }
        if (queryStructureRequests.getKeyFamilyRefList() != null) {
            for (CategorySchemeRefType refType : queryStructureRequests.getKeyFamilyRefList()) {
                urn = refType.getURN();
                if (ObjectUtil.validString((String[])new String[]{urn})) {
                    reutrnList.add((StructureReferenceBean)new StructureReferenceBeanImpl(urn));
                    continue;
                }
                agencyId = refType.getAgencyID();
                maintId = refType.getKeyFamilyID();
                version = refType.getVersion();
                reutrnList.add((StructureReferenceBean)new StructureReferenceBeanImpl(agencyId, maintId, version, SDMX_STRUCTURE_TYPE.DSD, new String[0]));
            }
        }
        if (queryStructureRequests.getMetadataflowRefList() != null) {
            for (CategorySchemeRefType refType : queryStructureRequests.getMetadataflowRefList()) {
                urn = refType.getURN();
                if (ObjectUtil.validString((String[])new String[]{urn})) {
                    reutrnList.add((StructureReferenceBean)new StructureReferenceBeanImpl(urn));
                    continue;
                }
                agencyId = refType.getAgencyID();
                maintId = refType.getMetadataflowID();
                version = refType.getVersion();
                reutrnList.add((StructureReferenceBean)new StructureReferenceBeanImpl(agencyId, maintId, version, SDMX_STRUCTURE_TYPE.METADATA_FLOW, new String[0]));
            }
        }
        if (queryStructureRequests.getMetadataStructureRefList() != null) {
            for (CategorySchemeRefType refType : queryStructureRequests.getMetadataStructureRefList()) {
                urn = refType.getURN();
                if (ObjectUtil.validString((String[])new String[]{urn})) {
                    reutrnList.add((StructureReferenceBean)new StructureReferenceBeanImpl(urn));
                    continue;
                }
                agencyId = refType.getAgencyID();
                maintId = refType.getMetadataStructureID();
                version = refType.getVersion();
                reutrnList.add((StructureReferenceBean)new StructureReferenceBeanImpl(agencyId, maintId, version, SDMX_STRUCTURE_TYPE.MSD, new String[0]));
            }
        }
        if (queryStructureRequests.getOrganisationSchemeRefList() != null) {
            for (CategorySchemeRefType refType : queryStructureRequests.getOrganisationSchemeRefList()) {
                urn = refType.getURN();
                if (ObjectUtil.validString((String[])new String[]{urn})) {
                    reutrnList.add((StructureReferenceBean)new StructureReferenceBeanImpl(urn));
                    continue;
                }
                agencyId = refType.getAgencyID();
                maintId = refType.getOrganisationSchemeID();
                version = refType.getVersion();
                reutrnList.add((StructureReferenceBean)new StructureReferenceBeanImpl(agencyId, maintId, version, SDMX_STRUCTURE_TYPE.AGENCY_SCHEME, new String[0]));
                reutrnList.add((StructureReferenceBean)new StructureReferenceBeanImpl(agencyId, maintId, version, SDMX_STRUCTURE_TYPE.DATA_CONSUMER_SCHEME, new String[0]));
                reutrnList.add((StructureReferenceBean)new StructureReferenceBeanImpl(agencyId, maintId, version, SDMX_STRUCTURE_TYPE.DATA_PROVIDER_SCHEME, new String[0]));
            }
        }
        if (queryStructureRequests.getProcessRefList() != null) {
            for (CategorySchemeRefType refType : queryStructureRequests.getProcessRefList()) {
                urn = refType.getURN();
                if (ObjectUtil.validString((String[])new String[]{urn})) {
                    reutrnList.add((StructureReferenceBean)new StructureReferenceBeanImpl(urn));
                    continue;
                }
                agencyId = refType.getAgencyID();
                maintId = refType.getProcessID();
                version = refType.getVersion();
                reutrnList.add((StructureReferenceBean)new StructureReferenceBeanImpl(agencyId, maintId, version, SDMX_STRUCTURE_TYPE.PROCESS, new String[0]));
            }
        }
        if (queryStructureRequests.getReportingTaxonomyRefList() != null) {
            for (CategorySchemeRefType refType : queryStructureRequests.getReportingTaxonomyRefList()) {
                urn = refType.getURN();
                if (ObjectUtil.validString((String[])new String[]{urn})) {
                    reutrnList.add((StructureReferenceBean)new StructureReferenceBeanImpl(urn));
                    continue;
                }
                agencyId = refType.getAgencyID();
                maintId = refType.getReportingTaxonomyID();
                version = refType.getVersion();
                reutrnList.add((StructureReferenceBean)new StructureReferenceBeanImpl(agencyId, maintId, version, SDMX_STRUCTURE_TYPE.REPORTING_TAXONOMY, new String[0]));
            }
        }
        if (queryStructureRequests.getStructureSetRefList() != null) {
            for (CategorySchemeRefType refType : queryStructureRequests.getStructureSetRefList()) {
                urn = refType.getURN();
                if (ObjectUtil.validString((String[])new String[]{urn})) {
                    reutrnList.add((StructureReferenceBean)new StructureReferenceBeanImpl(urn));
                    continue;
                }
                agencyId = refType.getAgencyID();
                maintId = refType.getStructureSetID();
                version = refType.getVersion();
                reutrnList.add((StructureReferenceBean)new StructureReferenceBeanImpl(agencyId, maintId, version, SDMX_STRUCTURE_TYPE.STRUCTURE_SET, new String[0]));
            }
        }
        return reutrnList;
    }

    protected StructureReferenceBean buildDataflowQuery(DataflowRefType refType) {
        String urn = refType.getURN();
        if (ObjectUtil.validString((String[])new String[]{urn})) {
            return new StructureReferenceBeanImpl(urn);
        }
        String agencyId = refType.getAgencyID();
        String maintId = refType.getDataflowID();
        String version = refType.getVersion();
        return new StructureReferenceBeanImpl(agencyId, maintId, version, SDMX_STRUCTURE_TYPE.DATAFLOW, new String[0]);
    }

    public StructureReferenceBean build(QueryRegistrationRequestType queryRegistrationRequestType) {
        DataflowRefType dataflowRef = queryRegistrationRequestType.getDataflowRef();
        DataProviderRefType dataProviderRef = queryRegistrationRequestType.getDataProviderRef();
        MetadataflowRefType metadataflowRef = queryRegistrationRequestType.getMetadataflowRef();
        ProvisionAgreementRefType provRef = queryRegistrationRequestType.getProvisionAgreementRef();
        if (dataProviderRef != null) {
            if (ObjectUtil.validString((String[])new String[]{dataProviderRef.getURN()})) {
                return new StructureReferenceBeanImpl(dataProviderRef.getURN());
            }
            String agencyId = dataProviderRef.getOrganisationSchemeAgencyID();
            String maintId = dataProviderRef.getOrganisationSchemeID();
            String version = dataProviderRef.getVersion();
            String id = dataProviderRef.getDataProviderID();
            return new StructureReferenceBeanImpl(agencyId, maintId, version, SDMX_STRUCTURE_TYPE.DATA_PROVIDER, new String[]{id});
        }
        if (provRef != null) {
            if (ObjectUtil.validString((String[])new String[]{provRef.getURN()})) {
                return new StructureReferenceBeanImpl(provRef.getURN());
            }
            throw new IllegalArgumentException("Version 2.0 query for registration by provision agreement must use the provision URN");
        }
        if (dataflowRef != null) {
            if (ObjectUtil.validString((String[])new String[]{dataflowRef.getURN()})) {
                return new StructureReferenceBeanImpl(dataflowRef.getURN());
            }
            String agencyId = dataflowRef.getAgencyID();
            String maintId = dataflowRef.getDataflowID();
            String version = dataflowRef.getVersion();
            return new StructureReferenceBeanImpl(agencyId, maintId, version, SDMX_STRUCTURE_TYPE.DATAFLOW, new String[0]);
        }
        if (metadataflowRef != null) {
            if (ObjectUtil.validString((String[])new String[]{metadataflowRef.getURN()})) {
                return new StructureReferenceBeanImpl(metadataflowRef.getURN());
            }
            String agencyId = metadataflowRef.getAgencyID();
            String maintId = metadataflowRef.getMetadataflowID();
            String version = metadataflowRef.getVersion();
            return new StructureReferenceBeanImpl(agencyId, maintId, version, SDMX_STRUCTURE_TYPE.METADATA_FLOW, new String[0]);
        }
        return null;
    }

    public StructureReferenceBean build(QueryProvisioningRequestType queryProvisionRequestType) {
        DataflowRefType dataflowRef = queryProvisionRequestType.getDataflowRef();
        DataProviderRefType dataProviderRef = queryProvisionRequestType.getDataProviderRef();
        MetadataflowRefType metadataflowRef = queryProvisionRequestType.getMetadataflowRef();
        ProvisionAgreementRefType provRef = queryProvisionRequestType.getProvisionAgreementRef();
        if (dataProviderRef != null) {
            if (ObjectUtil.validString((String[])new String[]{dataProviderRef.getURN()})) {
                return new StructureReferenceBeanImpl(dataProviderRef.getURN());
            }
            String agencyId = dataProviderRef.getOrganisationSchemeAgencyID();
            String maintId = dataProviderRef.getOrganisationSchemeID();
            String version = dataProviderRef.getVersion();
            String id = dataProviderRef.getDataProviderID();
            return new StructureReferenceBeanImpl(agencyId, maintId, version, SDMX_STRUCTURE_TYPE.DATA_PROVIDER, new String[]{id});
        }
        if (provRef != null && ObjectUtil.validString((String[])new String[]{provRef.getURN()})) {
            return new StructureReferenceBeanImpl(provRef.getURN());
        }
        if (dataflowRef != null) {
            if (ObjectUtil.validString((String[])new String[]{dataflowRef.getURN()})) {
                return new StructureReferenceBeanImpl(dataflowRef.getURN());
            }
            String agencyId = dataflowRef.getAgencyID();
            String maintId = dataflowRef.getDataflowID();
            String version = dataflowRef.getVersion();
            return new StructureReferenceBeanImpl(agencyId, maintId, version, SDMX_STRUCTURE_TYPE.DATAFLOW, new String[0]);
        }
        if (metadataflowRef != null) {
            if (ObjectUtil.validString((String[])new String[]{metadataflowRef.getURN()})) {
                return new StructureReferenceBeanImpl(metadataflowRef.getURN());
            }
            String agencyId = metadataflowRef.getAgencyID();
            String maintId = metadataflowRef.getMetadataflowID();
            String version = metadataflowRef.getVersion();
            return new StructureReferenceBeanImpl(agencyId, maintId, version, SDMX_STRUCTURE_TYPE.METADATA_FLOW, new String[0]);
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"At version 2.0 provisions can only be queryies by Provision URN, Dataflow Ref, Data Provider Ref or Metadata Flow Ref"});
    }

    public List<StructureReferenceBean> build(QueryMessageType queryMessage) {
        ArrayList<StructureReferenceBean> reutrnList = new ArrayList<StructureReferenceBean>();
        if (queryMessage.getQuery() != null) {
            StructureReferenceBeanImpl refBean;
            SDMX_STRUCTURE_TYPE structType;
            String version;
            String maintId;
            String agencyId;
            QueryType queryType = queryMessage.getQuery();
            if (queryType.getAgencyWhereList() != null && ObjectUtil.validCollection((Collection)queryMessage.getQuery().getAgencyWhereList())) {
                throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"AgencyWhere"});
            }
            if (queryType.getCategorySchemeWhereList() != null) {
                for (CategorySchemeWhereType structQuery : queryType.getCategorySchemeWhereList()) {
                    agencyId = structQuery.getAgencyID();
                    maintId = structQuery.getID();
                    version = structQuery.getVersion();
                    structType = SDMX_STRUCTURE_TYPE.CATEGORY_SCHEME;
                    refBean = new StructureReferenceBeanImpl(agencyId, maintId, version, structType, new String[0]);
                    reutrnList.add((StructureReferenceBean)refBean);
                }
            }
            if (queryType.getCodelistWhereList() != null) {
                for (CategorySchemeWhereType structQuery : queryType.getCodelistWhereList()) {
                    String codelistId = null;
                    if (structQuery.getCodelist() != null) {
                        codelistId = structQuery.getCodelist().getId();
                    }
                    String agencyId2 = structQuery.getAgencyID();
                    String maintId2 = codelistId;
                    String version2 = structQuery.getVersion();
                    SDMX_STRUCTURE_TYPE structType2 = SDMX_STRUCTURE_TYPE.CODE_LIST;
                    StructureReferenceBeanImpl refBean2 = new StructureReferenceBeanImpl(agencyId2, maintId2, version2, structType2, new String[0]);
                    reutrnList.add((StructureReferenceBean)refBean2);
                    if (structQuery.getOr() != null) {
                        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"CodelistWhere/Or"});
                    }
                    if (structQuery.getAnd() == null) continue;
                    throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"CodelistWhere/And"});
                }
            }
            if (queryType.getConceptSchemeWhereList() != null) {
                for (CategorySchemeWhereType structQuery : queryType.getConceptSchemeWhereList()) {
                    agencyId = structQuery.getAgencyID();
                    maintId = structQuery.getID();
                    version = structQuery.getVersion();
                    structType = SDMX_STRUCTURE_TYPE.CONCEPT_SCHEME;
                    refBean = new StructureReferenceBeanImpl(agencyId, maintId, version, structType, new String[0]);
                    reutrnList.add((StructureReferenceBean)refBean);
                }
            }
            if (queryType.getConceptWhereList() != null) {
                for (CategorySchemeWhereType structQuery : queryType.getConceptWhereList()) {
                    agencyId = structQuery.getAgencyID();
                    String conceptId = structQuery.getConcept();
                    SDMX_STRUCTURE_TYPE structType3 = SDMX_STRUCTURE_TYPE.CONCEPT;
                    StructureReferenceBeanImpl refBean3 = new StructureReferenceBeanImpl(agencyId, "STANDALONE_CONCEPT_SCHEME", "1.0", structType3, new String[]{conceptId});
                    reutrnList.add((StructureReferenceBean)refBean3);
                    if (structQuery.getOr() != null) {
                        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"ConceptWhere/Or"});
                    }
                    if (structQuery.getAnd() == null) continue;
                    throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"ConceptWhere/And"});
                }
            }
            if (queryType.getDataflowWhereList() != null) {
                for (CategorySchemeWhereType structQuery : queryType.getDataflowWhereList()) {
                    agencyId = structQuery.getAgencyID();
                    maintId = structQuery.getID();
                    version = structQuery.getVersion();
                    structType = SDMX_STRUCTURE_TYPE.DATAFLOW;
                    refBean = new StructureReferenceBeanImpl(agencyId, maintId, version, structType, new String[0]);
                    reutrnList.add((StructureReferenceBean)refBean);
                }
            }
            if (queryType.getDataProviderWhereList() != null && queryType.getDataProviderWhereList().size() > 0) {
                throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"DataProviderWhere"});
            }
            if (queryType.getDataWhereList() != null && queryType.getDataWhereList().size() > 0) {
                throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"DataWhere"});
            }
            if (queryType.getHierarchicalCodelistWhereList() != null) {
                for (CategorySchemeWhereType structQuery : queryType.getHierarchicalCodelistWhereList()) {
                    agencyId = structQuery.getAgencyID();
                    maintId = structQuery.getID();
                    version = structQuery.getVersion();
                    structType = SDMX_STRUCTURE_TYPE.HIERARCHICAL_CODELIST;
                    refBean = new StructureReferenceBeanImpl(agencyId, maintId, version, structType, new String[0]);
                    reutrnList.add((StructureReferenceBean)refBean);
                }
            }
            if (queryType.getKeyFamilyWhereList() != null) {
                for (CategorySchemeWhereType structQuery : queryType.getKeyFamilyWhereList()) {
                    agencyId = structQuery.getAgencyID();
                    maintId = structQuery.getKeyFamily();
                    version = structQuery.getVersion();
                    structType = SDMX_STRUCTURE_TYPE.DSD;
                    refBean = new StructureReferenceBeanImpl(agencyId, maintId, version, structType, new String[0]);
                    reutrnList.add((StructureReferenceBean)refBean);
                    if (structQuery.getOr() != null) {
                        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"KeyFamilyWhere/Or"});
                    }
                    if (structQuery.getAnd() != null) {
                        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"KeyFamilyWhere/And"});
                    }
                    if (structQuery.getDimension() != null) {
                        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"KeyFamilyWhere/Dimension"});
                    }
                    if (structQuery.getAttribute() != null) {
                        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"KeyFamilyWhere/Attribute"});
                    }
                    if (structQuery.getCodelist() != null) {
                        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"KeyFamilyWhere/Codelist"});
                    }
                    if (structQuery.getCategory() != null) {
                        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"KeyFamilyWhere/Category"});
                    }
                    if (structQuery.getConcept() == null) continue;
                    throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"KeyFamilyWhere/Concept"});
                }
            }
            if (queryType.getMetadataflowWhereList() != null) {
                for (CategorySchemeWhereType structQuery : queryType.getMetadataflowWhereList()) {
                    agencyId = structQuery.getAgencyID();
                    maintId = structQuery.getID();
                    version = structQuery.getVersion();
                    structType = SDMX_STRUCTURE_TYPE.METADATA_FLOW;
                    refBean = new StructureReferenceBeanImpl(agencyId, maintId, version, structType, new String[0]);
                    reutrnList.add((StructureReferenceBean)refBean);
                }
            }
            if (queryType.getMetadataWhereList() != null && queryType.getMetadataWhereList().size() > 0) {
                throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"DataWhere"});
            }
            if (queryType.getOrganisationSchemeWhereList() != null) {
                for (CategorySchemeWhereType structQuery : queryType.getOrganisationSchemeWhereList()) {
                    agencyId = structQuery.getAgencyID();
                    maintId = structQuery.getID();
                    version = structQuery.getVersion();
                    structType = SDMX_STRUCTURE_TYPE.ORGANISATION_UNIT_SCHEME;
                    refBean = new StructureReferenceBeanImpl(agencyId, maintId, version, structType, new String[0]);
                    reutrnList.add((StructureReferenceBean)refBean);
                }
            }
            if (queryType.getProcessWhereList() != null) {
                for (CategorySchemeWhereType structQuery : queryType.getProcessWhereList()) {
                    agencyId = structQuery.getAgencyID();
                    maintId = structQuery.getID();
                    version = structQuery.getVersion();
                    structType = SDMX_STRUCTURE_TYPE.PROCESS;
                    refBean = new StructureReferenceBeanImpl(agencyId, maintId, version, structType, new String[0]);
                    reutrnList.add((StructureReferenceBean)refBean);
                }
            }
            if (queryType.getStructureSetWhereList() != null) {
                for (CategorySchemeWhereType structQuery : queryType.getStructureSetWhereList()) {
                    agencyId = structQuery.getAgencyID();
                    maintId = structQuery.getID();
                    version = structQuery.getVersion();
                    structType = SDMX_STRUCTURE_TYPE.STRUCTURE_SET;
                    refBean = new StructureReferenceBeanImpl(agencyId, maintId, version, structType, new String[0]);
                    reutrnList.add((StructureReferenceBean)refBean);
                }
            }
            if (queryType.getReportingTaxonomyWhereList() != null) {
                for (CategorySchemeWhereType structQuery : queryType.getReportingTaxonomyWhereList()) {
                    agencyId = structQuery.getAgencyID();
                    maintId = structQuery.getID();
                    version = structQuery.getVersion();
                    structType = SDMX_STRUCTURE_TYPE.REPORTING_TAXONOMY;
                    refBean = new StructureReferenceBeanImpl(agencyId, maintId, version, structType, new String[0]);
                    reutrnList.add((StructureReferenceBean)refBean);
                }
            }
        }
        return reutrnList;
    }
}

