/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.commons.templates.model.actions.impl;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.gcube.data.analysis.tabulardata.commons.templates.model.TemplateAction;
import org.gcube.data.analysis.tabulardata.commons.templates.model.Utils;
import org.gcube.data.analysis.tabulardata.commons.templates.model.actions.GroupAction;
import org.gcube.data.analysis.tabulardata.commons.templates.model.actions.impl.AddColumnAction;
import org.gcube.data.analysis.tabulardata.commons.templates.model.actions.impl.ChangeToTimeDimensionAction;
import org.gcube.data.analysis.tabulardata.commons.templates.model.columns.ColumnCategory;
import org.gcube.data.analysis.tabulardata.commons.templates.model.columns.TemplateColumn;
import org.gcube.data.analysis.tabulardata.commons.utils.TimeDimensionReference;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.dsl.Texts;
import org.gcube.data.analysis.tabulardata.expression.dsl.Types;
import org.gcube.data.analysis.tabulardata.model.datatype.TextType;
import org.gcube.data.analysis.tabulardata.model.time.PeriodType;
import org.gcube.data.analysis.tabulardata.model.time.TimeConstants;

public class GenerateTimeDimensionGroup
implements GroupAction {
    private TemplateColumn<TextType> year;
    private TemplateColumn<TextType> month;
    private TemplateColumn<TextType> quarter;
    private TemplateColumn<TextType> day;
    private String id = UUID.randomUUID().toString();
    private PeriodType periodType;
    private String formatId;

    public GenerateTimeDimensionGroup(TemplateColumn<TextType> year) {
        this.year = year;
        this.periodType = PeriodType.YEAR;
        this.formatId = TimeConstants.ISO_YEAR.getId();
    }

    public GenerateTimeDimensionGroup(TemplateColumn<TextType> year, TemplateColumn<TextType> secondParam, boolean isMonth) {
        this.year = year;
        if (isMonth) {
            this.month = secondParam;
            this.periodType = PeriodType.MONTH;
            this.formatId = TimeConstants.ISO_MONTH.getId();
        } else {
            this.quarter = secondParam;
            this.periodType = PeriodType.QUARTER;
            this.formatId = TimeConstants.ISO_QUARTER.getId();
        }
    }

    public GenerateTimeDimensionGroup(TemplateColumn<TextType> year, TemplateColumn<TextType> month, TemplateColumn<TextType> day) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.periodType = PeriodType.DAY;
        this.formatId = TimeConstants.ISO_DATE_ANY_SEP.getId();
    }

    @Override
    public List<TemplateAction<Long>> getActions() {
        Object expr = this.day != null ? Texts.concat((Expression)Texts.concat((Expression)Texts.concat((Expression)Texts.concat((Expression)Types.textPlaceholder((String)this.year.getId()), (Expression)Types.text((String)"-")), (Expression)Types.textPlaceholder((String)this.month.getId())), (Expression)Types.text((String)"-")), (Expression)Types.textPlaceholder((String)this.day.getId())) : (this.quarter != null ? Texts.concat((Expression)Texts.concat((Expression)Types.textPlaceholder((String)this.year.getId()), (Expression)Types.text((String)"-Q")), (Expression)Types.textPlaceholder((String)this.quarter.getId())) : (this.month != null ? Texts.concat((Expression)Texts.concat((Expression)Types.textPlaceholder((String)this.year.getId()), (Expression)Types.text((String)"-")), (Expression)Types.textPlaceholder((String)this.month.getId())) : Types.textPlaceholder((String)this.year.getId())));
        TemplateColumn<TextType> newColumn = new TemplateColumn<TextType>(ColumnCategory.ATTRIBUTE, TextType.class, Utils.TEXT_FORMAT_REFERENCE);
        AddColumnAction addColumn = new AddColumnAction(newColumn, (Expression)expr);
        addColumn.setBelogsToGroup(this.getGroupId());
        ChangeToTimeDimensionAction changeCol = new ChangeToTimeDimensionAction(addColumn.getCreatedColumns().get(0), new TimeDimensionReference(this.periodType, this.formatId));
        changeCol.setBelogsToGroup(this.getGroupId());
        return Arrays.asList(addColumn, changeCol);
    }

    @Override
    public String getGroupId() {
        return this.id;
    }
}

