/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.commons.templates.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.analysis.tabulardata.commons.templates.model.actions.impl.TemplateActionColumnReference;
import org.gcube.data.analysis.tabulardata.commons.templates.model.columns.TemplateColumn;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.table.TableId;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class TemplateAction<T extends Serializable>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String belongsToGroup = null;

    public abstract boolean usesExpression();

    public abstract T getIdentifier();

    public abstract List<TemplateColumn<?>> getPostOperationStructure(List<TemplateColumn<?>> var1);

    public abstract Map<String, Object> getParameters();

    public Map<String, Object> replaceColumnReferences(TableId tableId, Map<String, ColumnLocalId> columnMapping) {
        Map<String, Object> parameters = this.getParameters();
        if (parameters == null || parameters.isEmpty()) {
            return parameters;
        }
        return this.getNewInstanceMap(tableId, columnMapping, this.getParameters());
    }

    private Map<String, Object> getNewInstanceMap(TableId tableId, Map<String, ColumnLocalId> columnMapping, Map<String, Object> oldInstances) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : oldInstances.entrySet()) {
            returnMap.put(entry.getKey(), this.getNewObjectInstance(entry.getValue(), columnMapping, tableId));
        }
        return returnMap;
    }

    private Object getNewObjectInstance(Object value, Map<String, ColumnLocalId> columnMapping, TableId tableId) {
        if (value instanceof TemplateActionColumnReference) {
            String columnId = ((TemplateActionColumnReference)value).getColumnId();
            if (columnMapping.containsKey(columnId)) {
                ColumnLocalId newId = columnMapping.get(columnId);
                ColumnReference colRef = new ColumnReference(tableId, newId);
                return colRef;
            }
            throw new RuntimeException("unexpected error, id " + columnId + " not found in column mapping");
        }
        if (value instanceof ColumnReference) {
            ColumnReference ref = (ColumnReference)value;
            if (columnMapping.containsKey(ref.getColumnId().toString())) {
                ColumnLocalId newId = columnMapping.get(ref.getColumnId().toString());
                ref.setColumnId(newId);
                return ref;
            }
        } else if (value instanceof String) {
            if (columnMapping.containsKey((String)value)) {
                return columnMapping.get((String)value).getValue();
            }
        } else {
            if (value instanceof Map) {
                Map compParam = (Map)value;
                return this.getNewInstanceMap(tableId, columnMapping, compParam);
            }
            if (value instanceof List) {
                List compParam = (List)value;
                ArrayList<Object> newInstances = new ArrayList<Object>();
                for (Object param : compParam) {
                    newInstances.add(this.getNewObjectInstance(param, columnMapping, tableId));
                }
                return newInstances;
            }
        }
        return value;
    }

    public void setBelogsToGroup(String groupId) {
        this.belongsToGroup = groupId;
    }

    public String getBelongsToGroup() {
        return this.belongsToGroup;
    }
}

