/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.model.error;

import java.util.ArrayList;
import java.util.List;
import org.sdmxsource.sdmx.api.exception.ExceptionHandler;
import org.sdmxsource.util.model.impl.ErrorReport;

public class MultipleFailureHandelerEngine
implements ExceptionHandler {
    private List<String> errors = new ArrayList<String>();
    private int limit = -1;

    public MultipleFailureHandelerEngine() {
    }

    public MultipleFailureHandelerEngine(int limit) {
        this.limit = limit;
    }

    public void handleException(Throwable ex) {
        String errorMessage = ErrorReport.build((Throwable)ex).toString();
        if (!this.errors.contains(errorMessage)) {
            this.errors.add(errorMessage);
            if (this.errors.size() >= this.limit) {
                StringBuilder sb = new StringBuilder();
                int i = 0;
                for (String currentError : this.errors) {
                    sb.append(System.getProperty("line.separator"));
                    sb.append("#" + ++i + " - " + currentError);
                }
                throw new RuntimeException(sb.toString());
            }
        }
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public List<String> getErrors() {
        return new ArrayList<String>(this.errors);
    }
}

