/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.factory;

import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.sdmxsource.sdmx.api.engine.DataWriterEngine;
import org.sdmxsource.sdmx.api.factory.DataWriterFactory;
import org.sdmxsource.sdmx.api.model.data.DataFormat;
import org.sdmxsource.sdmx.dataparser.engine.writer.CompactDataWriterEngine;
import org.sdmxsource.sdmx.dataparser.engine.writer.CrossSectionDataWriterEngine;
import org.sdmxsource.sdmx.dataparser.engine.writer.GenericDataWriterEngine;
import org.sdmxsource.sdmx.ediparser.engine.writer.impl.EDIDataWriterEngineImpl;
import org.springframework.stereotype.Service;

@Service
public class SdmxDataWriterFactory
implements DataWriterFactory {
    private static Logger LOG = Logger.getLogger(SdmxDataWriterFactory.class);

    public DataWriterEngine getDataWriterEngine(DataFormat dataFormat, OutputStream out) {
        if (dataFormat.getSdmxDataFormat() != null) {
            switch (dataFormat.getSdmxDataFormat().getBaseDataFormat()) {
                case COMPACT: {
                    return new CompactDataWriterEngine(dataFormat.getSdmxDataFormat().getSchemaVersion(), out);
                }
                case GENERIC: {
                    return new GenericDataWriterEngine(dataFormat.getSdmxDataFormat().getSchemaVersion(), out);
                }
                case CROSS_SECTIONAL: {
                    return new CrossSectionDataWriterEngine(dataFormat.getSdmxDataFormat().getSchemaVersion(), out);
                }
                case EDI: {
                    return new EDIDataWriterEngineImpl(out);
                }
            }
            LOG.warn((Object)("DataWriterFactoryImpl encountered unsuported SDMX format: " + dataFormat));
        }
        return null;
    }
}

