/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.engine.writer;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.sdmxsource.sdmx.api.constants.BASE_DATA_FORMAT;
import org.sdmxsource.sdmx.api.constants.SDMX_SCHEMA;
import org.sdmxsource.sdmx.api.engine.DataWriterEngine;
import org.sdmxsource.sdmx.api.model.beans.base.AnnotationBean;
import org.sdmxsource.sdmx.api.model.beans.base.ComponentBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;
import org.sdmxsource.sdmx.api.model.header.DatasetHeaderBean;
import org.sdmxsource.sdmx.dataparser.engine.writer.SdmxDataWriterEngine;
import org.sdmxsource.util.ObjectUtil;

public class CompactDataWriterEngine
extends SdmxDataWriterEngine {
    private Map<String, String> componentVals = new HashMap<String, String>();
    private String primaryMeasureConcept;
    private String timeConcept;

    public CompactDataWriterEngine(SDMX_SCHEMA schemaVersion, OutputStream out) {
        super(schemaVersion, BASE_DATA_FORMAT.COMPACT, out);
    }

    @Override
    public void startDataset(DataflowBean dataflowBean, DataStructureBean dsd, DatasetHeaderBean header, AnnotationBean ... annotations) {
        super.startDataset(dataflowBean, dsd, header, new AnnotationBean[0]);
        this.primaryMeasureConcept = this.getComponentId((ComponentBean)dsd.getPrimaryMeasure());
        this.timeConcept = this.getComponentId((ComponentBean)dsd.getTimeDimension());
        if (this.isTwoPointOne()) {
            this.writeAnnotations(this.writer, annotations);
        } else {
            this.datasetAnnotations = annotations;
        }
    }

    @Override
    public void startGroup(String groupId, AnnotationBean ... annotations) {
        super.startGroup(groupId, new AnnotationBean[0]);
        try {
            if (this.currentPosition != null) {
                switch (this.currentPosition) {
                    case OBSERVATION: {
                        this.writeEndObs();
                        this.writeEndSeries();
                        break;
                    }
                    case OBSERVATION_ATTRIBUTE: {
                        this.writeEndObs();
                        this.writeEndSeries();
                        break;
                    }
                    case SERIES_KEY_ATTRIBUTE: {
                        this.writeEndSeries();
                        break;
                    }
                    case SERIES_KEY: {
                        this.writeEndSeries();
                        break;
                    }
                    case GROUP: {
                        this.writeEndGroup();
                        break;
                    }
                    case GROUP_KEY_ATTRIBUTE: {
                        this.writeEndGroup();
                    }
                }
            }
            if (this.isTwoPointOne()) {
                this.writer.writeStartElement("Group");
                this.writer.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", this.COMPACT_NS.namespacePrefix + ":" + groupId);
                this.writeAnnotations(this.writer, annotations);
            } else {
                this.groupAnnotations = annotations;
                this.writer.writeStartElement(this.COMPACT_NS.namespacePrefix, groupId, this.COMPACT_NS.namespaceURL);
            }
            this.currentPosition = SdmxDataWriterEngine.POSITION.GROUP;
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void closeGroupWriter() throws Exception {
        if (this.currentPosition != null) {
            switch (this.currentPosition) {
                case GROUP: {
                    this.writeEndGroup();
                    break;
                }
                case GROUP_KEY_ATTRIBUTE: {
                    this.writeEndGroup();
                }
            }
        }
        this.writer.flush();
    }

    @Override
    public void writeGroupKeyValue(String conceptId, String conceptValue) {
        conceptId = this.getComponentId(conceptId);
        super.writeGroupKeyValue(conceptId, conceptValue);
        try {
            if (this.currentPosition != SdmxDataWriterEngine.POSITION.GROUP) {
                throw new IllegalArgumentException("startGroup must be called before calling writeGroupKeyValue");
            }
            this.writer.writeAttribute(conceptId, conceptValue);
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void startSeries(AnnotationBean ... annotations) {
        super.startSeries(new AnnotationBean[0]);
        if (this.isFlat) {
            this.componentVals = new HashMap<String, String>();
        } else {
            try {
                if (this.currentPosition != null) {
                    switch (this.currentPosition) {
                        case OBSERVATION: {
                            this.writeEndObs();
                            this.writeEndSeries();
                            break;
                        }
                        case OBSERVATION_ATTRIBUTE: {
                            this.writeEndObs();
                            this.writeEndSeries();
                            break;
                        }
                        case SERIES_KEY_ATTRIBUTE: {
                            this.writeEndSeries();
                            break;
                        }
                        case SERIES_KEY: {
                            this.writeEndSeries();
                            break;
                        }
                        case GROUP: {
                            this.writeEndGroup();
                            break;
                        }
                        case GROUP_KEY_ATTRIBUTE: {
                            this.writeEndGroup();
                        }
                    }
                }
                this.seriesAnnotations = annotations;
                if (this.isTwoPointOne()) {
                    if (this.isFlat) {
                        this.seriesWriter.writeStartElement("Obs");
                    } else {
                        this.seriesWriter.writeStartElement("Series");
                    }
                } else {
                    this.startElement(this.seriesWriter, this.COMPACT_NS, "Series");
                }
                this.currentPosition = SdmxDataWriterEngine.POSITION.SERIES_KEY;
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    protected void writeEndSeries() throws XMLStreamException {
        if (this.isTwoPointOne() && (this.currentPosition == SdmxDataWriterEngine.POSITION.SERIES_KEY || this.currentPosition == SdmxDataWriterEngine.POSITION.SERIES_KEY_ATTRIBUTE)) {
            this.writeAnnotations(this.seriesWriter, this.seriesAnnotations);
            this.seriesAnnotations = null;
        }
        super.writeEndSeries();
    }

    @Override
    public void writeSeriesKeyValue(String dimensionId, String dimensionValue) {
        dimensionId = this.getComponentId(dimensionId);
        super.writeSeriesKeyValue(dimensionId, dimensionValue);
        if (this.isFlat) {
            this.componentVals.put(dimensionId, dimensionValue);
        } else {
            try {
                if (this.currentPosition != SdmxDataWriterEngine.POSITION.SERIES_KEY) {
                    this.startSeries(new AnnotationBean[0]);
                }
                this.seriesWriter.writeAttribute(dimensionId, dimensionValue);
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    public void writeObservation(String obsConceptValue, String obsValue, AnnotationBean ... annotations) {
        if (this.isFlat) {
            throw new IllegalArgumentException("Can not write observation, as no observation concept id was given, and this is writing a flat dataset. Plase use the method: writeObservation(String obsConceptId, String obsIdValue, String obsValue, AnnotationBean... annotations)");
        }
        if (this.isCrossSectional) {
            this.writeObservation(this.crossSectionConcept, obsConceptValue, obsValue, annotations);
        } else {
            this.writeObservation(this.timeConcept, obsConceptValue, obsValue, annotations);
        }
    }

    @Override
    public void writeObservation(String obsConceptId, String obsIdValue, String obsValue, AnnotationBean ... annotations) {
        obsConceptId = this.getComponentId(obsConceptId);
        super.writeObservation(obsConceptId, obsIdValue, obsValue, new AnnotationBean[0]);
        if (!ObjectUtil.validString((String[])new String[]{obsValue})) {
            obsValue = "NaN";
        }
        if ("TIME_PERIOD".equals(obsConceptId)) {
            obsConceptId = this.timeConcept;
        }
        try {
            switch (this.currentPosition) {
                case OBSERVATION: {
                    this.writeEndObs();
                    break;
                }
                case OBSERVATION_ATTRIBUTE: {
                    this.writeEndObs();
                    break;
                }
                case SERIES_KEY: {
                    if (!this.isTwoPointOne()) break;
                    this.writeAnnotations(this.seriesWriter, this.seriesAnnotations);
                    this.seriesAnnotations = null;
                    break;
                }
                case SERIES_KEY_ATTRIBUTE: {
                    if (!this.isTwoPointOne()) break;
                    this.writeAnnotations(this.seriesWriter, this.seriesAnnotations);
                    this.seriesAnnotations = null;
                    break;
                }
                default: {
                    if (this.isTwoPointOne()) break;
                    throw new IllegalArgumentException("An observation may only be written while inside a series");
                }
            }
            this.obsAnnotations = annotations;
            this.currentPosition = SdmxDataWriterEngine.POSITION.OBSERVATION;
            if (this.isTwoPointOne()) {
                this.seriesWriter.writeStartElement("Obs");
            } else {
                this.startElement(this.seriesWriter, this.COMPACT_NS, "Obs");
            }
            if (this.isFlat) {
                for (String key : this.componentVals.keySet()) {
                    this.seriesWriter.writeAttribute(key, this.componentVals.get(key));
                }
            }
            if (this.isCrossSectionalMeasure) {
                this.seriesWriter.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "type", this.COMPACT_NS.namespacePrefix + ":" + obsIdValue);
            } else {
                this.seriesWriter.writeAttribute(obsConceptId, obsIdValue);
            }
            this.seriesWriter.writeAttribute(this.primaryMeasureConcept, obsValue);
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void writeEndObs() throws XMLStreamException {
        if (this.isTwoPointOne()) {
            this.writeAnnotations(this.seriesWriter, this.obsAnnotations);
            this.obsAnnotations = null;
        }
        super.writeEndObs();
    }

    @Override
    public void writeAttributeValue(String attributeId, String attributeValue) {
        attributeId = this.getComponentId(attributeId);
        super.writeAttributeValue(attributeId, attributeValue);
        if (attributeValue == null) {
            attributeValue = "";
        }
        try {
            switch (this.currentPosition) {
                case DATASET: 
                case DATASET_ATTRIBUTE: {
                    this.currentPosition = SdmxDataWriterEngine.POSITION.DATASET_ATTRIBUTE;
                    super.writeDatasetAttribute(attributeId, attributeValue);
                    break;
                }
                case OBSERVATION: 
                case OBSERVATION_ATTRIBUTE: {
                    this.currentPosition = SdmxDataWriterEngine.POSITION.OBSERVATION_ATTRIBUTE;
                    this.seriesWriter.writeAttribute(attributeId, attributeValue);
                    break;
                }
                case SERIES_KEY_ATTRIBUTE: 
                case SERIES_KEY: {
                    this.currentPosition = SdmxDataWriterEngine.POSITION.SERIES_KEY_ATTRIBUTE;
                    if (this.isFlat) {
                        this.componentVals.put(attributeId, attributeValue);
                        break;
                    }
                    this.seriesWriter.writeAttribute(attributeId, attributeValue);
                    break;
                }
                case GROUP: 
                case GROUP_KEY_ATTRIBUTE: 
                case GROUP_KEY: {
                    this.currentPosition = SdmxDataWriterEngine.POSITION.GROUP_KEY_ATTRIBUTE;
                    this.writer.writeAttribute(attributeId, attributeValue);
                }
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close(DataWriterEngine.FooterMessage ... footer) {
        if (this.currentPosition != null) {
            try {
                switch (this.currentPosition) {
                    case DATASET: {
                        break;
                    }
                    case OBSERVATION: {
                        this.writeEndObs();
                        this.writeEndSeries();
                        break;
                    }
                    case OBSERVATION_ATTRIBUTE: {
                        this.writeEndObs();
                        this.writeEndSeries();
                        break;
                    }
                    case SERIES_KEY_ATTRIBUTE: {
                        this.writeEndSeries();
                        break;
                    }
                    case SERIES_KEY: {
                        this.writeEndSeries();
                        break;
                    }
                    case GROUP: {
                        this.writeEndGroup();
                        break;
                    }
                    case GROUP_KEY_ATTRIBUTE: {
                        this.writeEndGroup();
                        break;
                    }
                    case GROUP_KEY: {
                        this.writeEndGroup();
                        break;
                    }
                }
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        super.close(footer);
    }
}

