/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.engine.reader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.sdmxsource.sdmx.api.constants.DATASET_POSITION;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.constants.TIME_FORMAT;
import org.sdmxsource.sdmx.api.engine.DataReaderEngine;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.exception.SdmxSyntaxException;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.model.beans.base.AnnotationBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.AttributeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;
import org.sdmxsource.sdmx.api.model.data.KeyValue;
import org.sdmxsource.sdmx.api.model.data.Keyable;
import org.sdmxsource.sdmx.api.model.data.Observation;
import org.sdmxsource.sdmx.api.model.header.DatasetStructureReferenceBean;
import org.sdmxsource.sdmx.api.util.ReadableDataLocation;
import org.sdmxsource.sdmx.dataparser.engine.reader.AbstractSdmxDataReaderEngine;
import org.sdmxsource.sdmx.sdmxbeans.model.data.KeyValueImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.data.KeyableImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.data.ObservationImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.header.DatasetHeaderBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.header.DatasetStructureReferenceBeanImpl;
import org.sdmxsource.sdmx.util.beans.DataStructureUtil;
import org.sdmxsource.sdmx.util.beans.reference.StructureReferenceBeanImpl;
import org.sdmxsource.sdmx.util.date.DateUtil;
import org.sdmxsource.sdmx.util.stax.StaxUtil;

public class GenericDataReaderEngine
extends AbstractSdmxDataReaderEngine {
    private static final long serialVersionUID = 8712324190069733547L;
    private Map<String, String> attributesOnDatasetNode = new HashMap<String, String>();

    public GenericDataReaderEngine(ReadableDataLocation dataLocation, DataStructureBean dataStructureBean, DataflowBean dataflowBean) {
        this(dataLocation, null, dataStructureBean, dataflowBean);
    }

    public GenericDataReaderEngine(ReadableDataLocation dataLocation, SdmxBeanRetrievalManager beanRetrieval, DataStructureBean dataStructureBean, DataflowBean dataflowBean) {
        super(dataLocation, beanRetrieval, dataStructureBean, dataflowBean);
        this.reset();
    }

    public DataReaderEngine createCopy() {
        return new GenericDataReaderEngine(this.dataLocation, this.beanRetrieval, this.currentDsd, this.currentDataflow);
    }

    public List<KeyValue> getDatasetAttributes() {
        ArrayList<KeyValue> returnList = new ArrayList<KeyValue>();
        for (AttributeBean attr : this.currentDsd.getDatasetAttributes()) {
            String attributeValue = this.attributesOnDatasetNode.get(attr.getId());
            if (attributeValue == null) continue;
            returnList.add((KeyValue)new KeyValueImpl(attributeValue, attr.getId()));
        }
        return returnList;
    }

    @Override
    protected boolean next(boolean includeObs) {
        String nodeName = null;
        try {
            while (this.parser.hasNext()) {
                int event = this.parser.next();
                if (event == 1) {
                    nodeName = this.parser.getLocalName();
                    if (nodeName.equalsIgnoreCase("Dataset")) {
                        this.datasetPosition = DATASET_POSITION.DATASET;
                        this.attributesOnDatasetNode = new HashMap<String, String>();
                        this.datasetHeaderBean = new DatasetHeaderBeanImpl(this.parser, this.headerBean);
                        String dsdId = this.processDatasetNode();
                        DatasetStructureReferenceBean dsRef = this.datasetHeaderBean.getDataStructureReference();
                        Object structureReference = null;
                        String id = null;
                        String serviceURL = null;
                        String structureURL = null;
                        String dimensionAtObservation = null;
                        if (dsRef != null) {
                            id = dsRef.getId();
                            serviceURL = dsRef.getServiceURL();
                            structureURL = dsRef.getStructureURL();
                            dimensionAtObservation = dsRef.getDimensionAtObservation();
                            structureReference = dsRef.getStructureReference();
                        }
                        if (structureReference == null) {
                            structureReference = this.defaultDsd != null && this.defaultDsd.getId().equals(dsdId) ? this.defaultDsd.asReference() : new StructureReferenceBeanImpl(null, dsdId, "1.0", SDMX_STRUCTURE_TYPE.DSD, new String[0]);
                        }
                        dsRef = new DatasetStructureReferenceBeanImpl(id, structureReference, serviceURL, structureURL, dimensionAtObservation);
                        this.datasetHeaderBean = this.datasetHeaderBean.modifyDataStructureReference(dsRef);
                        return true;
                    }
                    if (nodeName.equals("Series")) {
                        StaxUtil.skipToEndNode((XMLStreamReader)this.runAheadParser, (String)"SeriesKey");
                        this.datasetPosition = DATASET_POSITION.SERIES;
                        return true;
                    }
                    if (nodeName.equals("Group")) {
                        StaxUtil.skipToEndNode((XMLStreamReader)this.runAheadParser, (String)"GroupKey");
                        this.datasetPosition = DATASET_POSITION.GROUP;
                        this.groupId = this.parser.getAttributeValue(null, "type");
                        return true;
                    }
                    if (nodeName.equals("Obs")) {
                        if (this.datasetPosition == DATASET_POSITION.SERIES || this.datasetPosition == DATASET_POSITION.OBSERVATION) {
                            if (!includeObs) continue;
                            this.datasetPosition = DATASET_POSITION.OBSERVATION;
                            return true;
                        }
                        this.datasetPosition = DATASET_POSITION.OBSERAVTION_AS_SERIES;
                        return true;
                    }
                    if (nodeName.equals("Annotations") || nodeName.equals("Attributes")) {
                        StaxUtil.skipNode((XMLStreamReader)this.parser);
                        continue;
                    }
                    if (nodeName.equals("KeyFamilyRef") || nodeName.equals("Time") || nodeName.equals("ObsValue") || nodeName.equals("ObsDimension")) continue;
                    throw new SdmxSyntaxException("Unexpected Node in XML: " + nodeName);
                }
                if (event != 2) continue;
                nodeName = this.parser.getLocalName();
                if (nodeName.equals("Series")) {
                    this.datasetPosition = null;
                    continue;
                }
                if (!nodeName.equals("Group")) continue;
                this.datasetPosition = null;
            }
        }
        catch (XMLStreamException ex) {
            this.close();
            throw new RuntimeException(ex);
        }
        this.hasNext = false;
        return false;
    }

    private String processDatasetNode() throws XMLStreamException {
        while (this.runAheadParser.hasNext()) {
            String nodeName;
            int event = this.runAheadParser.next();
            if (event == 1) {
                nodeName = this.runAheadParser.getLocalName();
                if (nodeName.equals("Attributes")) {
                    List<KeyValue> attributes = this.getKeyValues("Attributes");
                    for (KeyValue kv : attributes) {
                        this.attributesOnDatasetNode.put(kv.getConcept(), kv.getCode());
                    }
                    continue;
                }
                if (nodeName.equals("KeyFamilyRef")) {
                    return this.runAheadParser.getElementText();
                }
                if (!this.isTwoPointOne) continue;
                if (nodeName.equals("Series")) {
                    return null;
                }
                if (!nodeName.equals("Group")) continue;
                return null;
            }
            if (event != 2 || !(nodeName = this.runAheadParser.getLocalName()).equals("DataSet")) continue;
            return null;
        }
        return null;
    }

    @Override
    protected Keyable processSeriesNode() throws XMLStreamException {
        List<KeyValue> key = this.noSeries ? this.getKeyValues("ObsKey") : this.getKeyValues("SeriesKey");
        List<KeyValue> attributes = null;
        TIME_FORMAT timeFormat = null;
        String obsValue = null;
        String obsConcept = null;
        boolean inSeries = true;
        while (this.runAheadParser.hasNext()) {
            String nodeName;
            int event = this.runAheadParser.next();
            if (event == 1) {
                nodeName = this.runAheadParser.getLocalName();
                if (inSeries && nodeName.equals("Attributes")) {
                    attributes = this.getKeyValues("Attributes");
                    continue;
                }
                if (nodeName.equals("Time")) {
                    obsConcept = this.runAheadParser.getElementText();
                    break;
                }
                if (nodeName.equals("Obs")) {
                    if (this.noSeries) continue;
                    inSeries = false;
                    continue;
                }
                if (nodeName.equals("ObsDimension")) {
                    obsConcept = this.runAheadParser.getAttributeValue(null, "value");
                    break;
                }
                if (!nodeName.equals("ObsValue")) continue;
                obsValue = this.runAheadParser.getAttributeValue(null, "value");
                continue;
            }
            if (event != 2 || !(nodeName = this.runAheadParser.getLocalName()).equals("Series") && (!this.noSeries || !nodeName.equals("Obs"))) continue;
            break;
        }
        if (this.noSeries) {
            ArrayList<KeyValue> seriesKey = new ArrayList<KeyValue>();
            String obsTime = null;
            for (KeyValue currentKeyValue : key) {
                if (currentKeyValue.getConcept().equals("TIME_PERIOD")) {
                    obsTime = currentKeyValue.getCode();
                    continue;
                }
                seriesKey.add(currentKeyValue);
            }
            ArrayList<KeyValue> seriesAttributes = new ArrayList<KeyValue>();
            ArrayList<KeyValue> obsAttributes = new ArrayList<KeyValue>();
            List observationAttributeIds = DataStructureUtil.getObservationConcepts((DataStructureBean)this.currentDsd);
            for (KeyValue currentKv : attributes) {
                if (observationAttributeIds.contains(currentKv.getConcept())) {
                    obsAttributes.add(currentKv);
                    continue;
                }
                seriesAttributes.add(currentKv);
            }
            timeFormat = DateUtil.getTimeFormatOfDate((String)obsTime);
            this.currentKey = new KeyableImpl(this.currentDataflow, this.currentDsd, seriesKey, seriesAttributes, timeFormat, new AnnotationBean[0]);
            this.currentObs = new ObservationImpl(this.currentKey, obsTime, obsValue, obsAttributes, new AnnotationBean[0]);
        } else if (this.isTimeSeries()) {
            if (obsConcept != null) {
                timeFormat = DateUtil.getTimeFormatOfDate(obsConcept);
            }
            this.currentKey = new KeyableImpl(this.currentDataflow, this.currentDsd, key, attributes, timeFormat, new AnnotationBean[0]);
        } else {
            ArrayList<KeyValue> seriesKey = new ArrayList<KeyValue>();
            String crossSectionTime = null;
            for (KeyValue currentKeyValue : key) {
                if (currentKeyValue.getConcept().equals("TIME_PERIOD")) {
                    crossSectionTime = currentKeyValue.getCode();
                    timeFormat = DateUtil.getTimeFormatOfDate((String)crossSectionTime);
                    continue;
                }
                seriesKey.add(currentKeyValue);
            }
            this.currentKey = new KeyableImpl(this.currentDataflow, this.currentDsd, seriesKey, attributes, timeFormat, this.getCrossSectionConcept(), crossSectionTime, new AnnotationBean[0]);
        }
        return this.currentKey;
    }

    @Override
    protected Keyable processGroupNode() throws XMLStreamException {
        List<KeyValue> key = this.getKeyValues("GroupKey");
        List<KeyValue> attributes = null;
        while (this.runAheadParser.hasNext()) {
            int event = this.runAheadParser.next();
            if (event != 1) continue;
            if (!this.runAheadParser.getLocalName().equals("Attributes")) break;
            attributes = this.getKeyValues("Attributes");
        }
        this.currentKey = new KeyableImpl(this.currentDataflow, this.currentDsd, key, attributes, this.groupId, new AnnotationBean[0]);
        return this.currentKey;
    }

    @Override
    protected Observation processObsNode(XMLStreamReader parser) throws XMLStreamException {
        String obsDimension = null;
        String obsValue = null;
        List<KeyValue> attributes = null;
        while (parser.hasNext()) {
            int event = parser.next();
            if (event == 1) {
                String nodeName = parser.getLocalName();
                if (nodeName.equals("Time")) {
                    obsDimension = parser.getElementText();
                    continue;
                }
                if (nodeName.equals("ObsDimension")) {
                    obsDimension = parser.getAttributeValue(null, "value");
                    continue;
                }
                if (nodeName.equals("ObsValue")) {
                    obsValue = parser.getAttributeValue(null, "value");
                    continue;
                }
                if (!nodeName.equals("Attributes")) continue;
                attributes = this.getKeyValues("Attributes");
                continue;
            }
            if (event != 2 || !parser.getLocalName().equals("Obs")) continue;
            break;
        }
        obsDimension = this.getComponentId(obsDimension);
        try {
            if (this.isTimeSeries()) {
                return new ObservationImpl(this.currentKey, obsDimension, obsValue, attributes, new AnnotationBean[0]);
            }
            if (obsDimension == null) {
                throw new SdmxSemmanticException("Error while processing observation for series '" + this.currentKey + "' , missing required cross sectional concept value '" + this.getCrossSectionConcept() + "'");
            }
            KeyValueImpl crossSection = new KeyValueImpl(obsDimension, this.getCrossSectionConcept());
            return new ObservationImpl(this.currentKey, this.currentKey.getObsTime(), obsValue, attributes, (KeyValue)crossSection, new AnnotationBean[0]);
        }
        catch (Throwable th) {
            if (this.currentKey != null) {
                throw new RuntimeException("Error while processing observation for key " + this.currentKey, th);
            }
            throw new RuntimeException("Error while processing observation");
        }
    }

    private List<KeyValue> getKeyValues(String endElement) throws XMLStreamException {
        ArrayList<KeyValue> returnList = new ArrayList<KeyValue>();
        while (this.parser.hasNext()) {
            int event = this.parser.next();
            if (event == 1) {
                String nodeName = this.parser.getLocalName();
                if (!nodeName.equals("Value")) continue;
                String componetVal = this.parser.getAttributeValue(null, "value");
                if (this.isTwoPointOne) {
                    returnList.add((KeyValue)new KeyValueImpl(componetVal, this.parser.getAttributeValue(null, "id")));
                    continue;
                }
                String componentId = this.getComponentId(this.parser.getAttributeValue(null, "concept"));
                returnList.add((KeyValue)new KeyValueImpl(componetVal, componentId));
                continue;
            }
            if (event != 2 || !this.parser.getLocalName().equals(endElement)) continue;
            break;
        }
        return returnList;
    }

    public static enum MOVE_TO {
        SERIES,
        GROUP,
        KEYABLE;

    }
}

