/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.engine.reader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.sdmxsource.sdmx.api.constants.DATASET_ACTION;
import org.sdmxsource.sdmx.api.constants.DATASET_POSITION;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.constants.TIME_FORMAT;
import org.sdmxsource.sdmx.api.engine.DataReaderEngine;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.exception.SdmxNotImplementedException;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.exception.SdmxSyntaxException;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.model.beans.base.AnnotationBean;
import org.sdmxsource.sdmx.api.model.beans.base.ComponentBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.AttributeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DimensionBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.GroupBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.data.KeyValue;
import org.sdmxsource.sdmx.api.model.data.Keyable;
import org.sdmxsource.sdmx.api.model.data.Observation;
import org.sdmxsource.sdmx.api.util.ReadableDataLocation;
import org.sdmxsource.sdmx.dataparser.engine.reader.AbstractSdmxDataReaderEngine;
import org.sdmxsource.sdmx.sdmxbeans.model.data.KeyValueImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.data.KeyableImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.data.ObservationImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.header.DatasetHeaderBeanImpl;
import org.sdmxsource.sdmx.util.beans.ConceptRefUtil;
import org.sdmxsource.sdmx.util.date.DateUtil;
import org.sdmxsource.sdmx.util.stax.StaxUtil;

public class CompactDataReaderEngine
extends AbstractSdmxDataReaderEngine {
    private static final long serialVersionUID = 7750528288236102625L;
    private Map<String, String> rolledUpAttributes = new HashMap<String, String>();
    private Map<String, String> keyValues = new HashMap<String, String>();
    private Map<String, String> attributeValues = new HashMap<String, String>();
    private List<String> groups = new ArrayList<String>();
    private List<String> dimensionConcepts = new ArrayList<String>();
    private Map<String, List<String>> groupConcepts = new HashMap<String, List<String>>();
    private String primaryMeasureConcept;
    private String timeConcept;
    private Set<String> datasetAttributes = new HashSet<String>();
    private Set<String> seriesAttributes = new HashSet<String>();
    private Set<String> observationAttributes = new HashSet<String>();
    private Map<String, Set<String>> groupAttributeConcepts = new HashMap<String, Set<String>>();
    private String obsTime = null;
    private String obsValue = null;
    private List<KeyValue> attributes = new ArrayList<KeyValue>();
    private KeyValue crossSection = null;
    private Map<String, String> attributesOnDatasetNode = new HashMap<String, String>();

    public CompactDataReaderEngine(ReadableDataLocation dataLocation, DataStructureBean dataStructureBean, DataflowBean dataflowBean) {
        this(dataLocation, null, dataStructureBean, dataflowBean);
    }

    public CompactDataReaderEngine(ReadableDataLocation dataLocation, SdmxBeanRetrievalManager beanRetrieval, DataStructureBean dataStructureBean, DataflowBean dataflowBean) {
        super(dataLocation, beanRetrieval, dataStructureBean, dataflowBean);
        this.reset();
    }

    public DataReaderEngine createCopy() {
        return new CompactDataReaderEngine(this.dataLocation, this.beanRetrieval, this.defaultDsd, this.defaultDataflow);
    }

    private void populateGroupConcepts(GroupBean groupBean, List<String> groups) {
        for (String dimensionId : groupBean.getDimensionRefs()) {
            groups.add(dimensionId);
        }
    }

    private String getComponentId(ComponentBean component) {
        if (component == null) {
            return null;
        }
        if (this.isTwoPointOne) {
            return component.getId();
        }
        return ConceptRefUtil.getConceptId((StructureReferenceBean)component.getConceptRef());
    }

    @Override
    protected boolean next(boolean includeObs) throws XMLStreamException {
        while (this.parser.hasNext()) {
            String nodeName;
            int event = this.parser.next();
            if (event == 1) {
                nodeName = this.parser.getLocalName();
                if (nodeName.equals("DataSet")) {
                    this.datasetPosition = DATASET_POSITION.DATASET;
                    this.processDataSetNode();
                    return true;
                }
                if (nodeName.equals("Series")) {
                    StaxUtil.jumpToNode((XMLStreamReader)this.runAheadParser, (String)"Series", null);
                    this.datasetPosition = DATASET_POSITION.SERIES;
                    return true;
                }
                if (!this.isTwoPointOne && this.groups.contains(nodeName)) {
                    this.datasetPosition = DATASET_POSITION.GROUP;
                    this.groupId = nodeName;
                    return true;
                }
                if (this.isTwoPointOne && nodeName.equals("Group")) {
                    this.datasetPosition = DATASET_POSITION.GROUP;
                    this.groupId = this.parser.getAttributeValue("xsi", "type");
                    return true;
                }
                if (nodeName.equals("Obs")) {
                    if (this.datasetPosition == DATASET_POSITION.SERIES || this.datasetPosition == DATASET_POSITION.OBSERVATION) {
                        if (!includeObs) continue;
                        this.datasetPosition = DATASET_POSITION.OBSERVATION;
                        return true;
                    }
                    this.datasetPosition = DATASET_POSITION.OBSERAVTION_AS_SERIES;
                    return true;
                }
                if (nodeName.equals("Annotations")) {
                    StaxUtil.skipNode((XMLStreamReader)this.parser);
                    continue;
                }
                throw new SdmxSyntaxException("Unexpected Node in XML: " + nodeName);
            }
            if (event != 2) continue;
            nodeName = this.parser.getLocalName();
            if (nodeName.equals("Series")) {
                this.datasetPosition = null;
                continue;
            }
            if (this.groups.contains(nodeName)) {
                this.datasetPosition = null;
                continue;
            }
            if (!nodeName.equals("Group")) continue;
            this.datasetPosition = null;
        }
        this.datasetPosition = null;
        this.hasNext = false;
        return false;
    }

    private void processDataSetNode() {
        this.rolledUpAttributes = new HashMap<String, String>();
        this.keyValues = new HashMap<String, String>();
        this.attributeValues = new HashMap<String, String>();
        this.attributesOnDatasetNode = new HashMap<String, String>();
        this.datasetHeaderBean = new DatasetHeaderBeanImpl(this.parser, this.headerBean);
        for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
            String attributeId = this.parser.getAttributeLocalName(i);
            attributeId = this.getComponentId(attributeId);
            this.attributesOnDatasetNode.put(attributeId, this.parser.getAttributeValue(i));
        }
    }

    private void setDimensionAtObservation(String dimensionAtObservation) {
        this.observationAttributes = new HashSet<String>();
        this.seriesAttributes = new HashSet<String>();
        for (AttributeBean attributeBean : this.currentDsd.getSeriesAttributes(dimensionAtObservation)) {
            this.seriesAttributes.add(this.getComponentId((ComponentBean)attributeBean));
        }
        for (AttributeBean attributeBean : this.currentDsd.getObservationAttributes(dimensionAtObservation)) {
            this.observationAttributes.add(this.getComponentId((ComponentBean)attributeBean));
        }
    }

    public List<KeyValue> getDatasetAttributes() {
        ArrayList<KeyValue> returnList = new ArrayList<KeyValue>();
        for (AttributeBean attr : this.currentDsd.getDatasetAttributes()) {
            String attributeValue = this.attributesOnDatasetNode.get(attr.getId());
            if (attributeValue == null) continue;
            returnList.add((KeyValue)new KeyValueImpl(attributeValue, attr.getId()));
        }
        return returnList;
    }

    @Override
    protected void setCurrentDsd(DataStructureBean dsd) {
        super.setCurrentDsd(dsd);
        this.dimensionConcepts = new ArrayList<String>();
        this.datasetAttributes = new HashSet<String>();
        this.seriesAttributes = new HashSet<String>();
        this.observationAttributes = new HashSet<String>();
        this.groups = new ArrayList<String>();
        this.groupConcepts = new HashMap<String, List<String>>();
        if (this.datasetHeaderBean.getDataStructureReference() != null) {
            this.setDimensionAtObservation(this.datasetHeaderBean.getDataStructureReference().getDimensionAtObservation());
        } else {
            this.setDimensionAtObservation("TIME_PERIOD");
        }
        for (String attributeId : this.attributesOnDatasetNode.keySet()) {
            ComponentBean component = dsd.getComponent(attributeId);
            if (component == null) continue;
            this.rolledUpAttributes.put(attributeId, this.attributesOnDatasetNode.get(attributeId));
        }
        for (DimensionBean dimensionBean : dsd.getDimensions(new SDMX_STRUCTURE_TYPE[]{SDMX_STRUCTURE_TYPE.DIMENSION})) {
            this.dimensionConcepts.add(dimensionBean.getId());
        }
        for (AttributeBean attributeBean : dsd.getDatasetAttributes()) {
            this.datasetAttributes.add(attributeBean.getId());
        }
        for (AttributeBean attributeBean : dsd.getDimensionGroupAttributes()) {
            this.seriesAttributes.add(attributeBean.getId());
        }
        for (AttributeBean attributeBean : dsd.getObservationAttributes()) {
            this.observationAttributes.add(attributeBean.getId());
        }
        this.primaryMeasureConcept = dsd.getPrimaryMeasure().getId();
        if (dsd.getTimeDimension() == null) {
            throw new SdmxNotImplementedException("The DSD: " + dsd.getId() + " has no time dimension. This is unsupported!");
        }
        this.timeConcept = dsd.getTimeDimension().getId();
        for (GroupBean groupBean : dsd.getGroups()) {
            String groupId = groupBean.getId();
            this.groups.add(groupId);
            HashSet<String> groupAttributes = new HashSet<String>();
            for (AttributeBean attributeBean : dsd.getGroupAttributes(groupId, true)) {
                groupAttributes.add(attributeBean.getId());
            }
            this.groupAttributeConcepts.put(groupId, groupAttributes);
            ArrayList<String> groups = new ArrayList<String>();
            this.populateGroupConcepts(groupBean, groups);
            this.groupConcepts.put(groupId, groups);
        }
    }

    @Override
    protected Keyable processSeriesNode() {
        this.keyValues.clear();
        this.attributeValues.clear();
        TIME_FORMAT timeFormat = null;
        String timeValue = null;
        for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
            String attributeId = this.getComponentId(this.parser.getAttributeLocalName(i));
            String attributeValue = this.parser.getAttributeValue(i);
            if (attributeId.equals(this.timeConcept)) {
                timeValue = attributeValue;
                timeFormat = DateUtil.getTimeFormatOfDate((String)timeValue);
                continue;
            }
            if (this.dimensionConcepts.contains(attributeId)) {
                this.keyValues.put(attributeId, attributeValue);
                continue;
            }
            if (this.seriesAttributes.contains(attributeId)) {
                this.attributeValues.put(attributeId, attributeValue);
                continue;
            }
            if (this.datasetPosition != DATASET_POSITION.OBSERAVTION_AS_SERIES || this.observationAttributes.contains(attributeId) || attributeId.equals(this.primaryMeasureConcept) || attributeId.equals(this.timeConcept)) continue;
            throw new SdmxSemmanticException("Unknown concept reported at series : " + attributeId);
        }
        ArrayList<KeyValueImpl> key = new ArrayList<KeyValueImpl>();
        for (String dimensionConcept : this.dimensionConcepts) {
            String conceptValue = null;
            conceptValue = this.keyValues.containsKey(dimensionConcept) ? this.keyValues.get(dimensionConcept) : this.rolledUpAttributes.get(dimensionConcept);
            if (conceptValue == null && this.datasetHeaderBean.getAction() != DATASET_ACTION.DELETE) {
                if (!this.isTimeSeries() && this.getCrossSectionConcept().equals(dimensionConcept)) continue;
                throw new SdmxSemmanticException("Missing series key value for concept: " + dimensionConcept);
            }
            KeyValueImpl kv = new KeyValueImpl(conceptValue, dimensionConcept);
            key.add(kv);
        }
        ArrayList<KeyValue> attributes = new ArrayList<KeyValue>();
        try {
            this.processAttributes(this.seriesAttributes, attributes);
        }
        catch (SdmxException e) {
            throw new SdmxException((Throwable)e, "Error while procesing series attributes");
        }
        this.keyValues.clear();
        this.attributeValues.clear();
        if (this.isTimeSeries() && this.datasetPosition == DATASET_POSITION.SERIES) {
            try {
                while (this.runAheadParser.hasNext()) {
                    int event = this.runAheadParser.next();
                    if (event == 1) {
                        if (!this.runAheadParser.getLocalName().equals("Obs")) continue;
                        this.processObservation(this.runAheadParser);
                        timeFormat = DateUtil.getTimeFormatOfDate((String)this.obsTime);
                    } else if (event != 2 || !this.runAheadParser.getLocalName().equals("Series")) continue;
                    break;
                }
            }
            catch (XMLStreamException ex) {
                throw new RuntimeException(ex);
            }
        }
        this.currentKey = this.isTimeSeries() ? new KeyableImpl(this.currentDataflow, this.currentDsd, key, attributes, timeFormat, new AnnotationBean[0]) : new KeyableImpl(this.currentDataflow, this.currentDsd, key, attributes, timeFormat, this.getCrossSectionConcept(), timeValue, new AnnotationBean[0]);
        if (this.datasetPosition == DATASET_POSITION.OBSERAVTION_AS_SERIES) {
            this.currentObs = this.processObsNode(this.parser);
            timeFormat = this.currentObs.getObsTimeFormat();
        }
        this.attributeValues.clear();
        return this.currentKey;
    }

    @Override
    protected Keyable processGroupNode() {
        this.keyValues.clear();
        this.attributeValues.clear();
        for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
            String attributeName = this.getComponentId(this.parser.getAttributeLocalName(i));
            String attributeValue = this.parser.getAttributeValue(i);
            String namespace = this.parser.getAttributePrefix(i);
            if (namespace != null && namespace.equals("xsi") && attributeName.equals("type")) {
                if (attributeValue.contains(":")) {
                    this.groupId = attributeValue.split(":")[1];
                    continue;
                }
                this.groupId = attributeValue;
                continue;
            }
            if (this.dimensionConcepts.contains(attributeName)) {
                this.keyValues.put(attributeName, attributeValue);
                continue;
            }
            this.attributeValues.put(attributeName, attributeValue);
        }
        ArrayList<KeyValueImpl> key = new ArrayList<KeyValueImpl>();
        ArrayList<KeyValue> attributes = new ArrayList<KeyValue>();
        if (!this.groupConcepts.containsKey(this.groupId)) {
            throw new SdmxSemmanticException("Data Structure '" + this.currentDsd + "' does not contain group '" + this.groupId + "'");
        }
        for (String groupConcept : this.groupConcepts.get(this.groupId)) {
            String conceptValue = null;
            conceptValue = this.keyValues.containsKey(groupConcept) ? this.keyValues.get(groupConcept) : this.rolledUpAttributes.get(groupConcept);
            if (conceptValue == null) {
                throw new IllegalArgumentException("No value found in data for group '" + this.groupId + "' and concept '" + groupConcept + "'.  ");
            }
            KeyValueImpl kv = new KeyValueImpl(conceptValue, groupConcept);
            key.add(kv);
        }
        try {
            this.processAttributes(this.groupAttributeConcepts.get(this.groupId), attributes);
        }
        catch (SdmxSemmanticException e) {
            throw new SdmxSemmanticException((Throwable)e, "Error while procesing group attributes for group '" + this.groupId + "' ");
        }
        this.keyValues.clear();
        this.attributeValues.clear();
        this.currentKey = new KeyableImpl(this.currentDataflow, this.currentDsd, key, attributes, this.groupId, new AnnotationBean[0]);
        return this.currentKey;
    }

    @Override
    protected Observation processObsNode(XMLStreamReader parser) {
        this.clearObsInformation();
        this.processObservation(parser);
        try {
            if (this.isTimeSeries()) {
                ObservationImpl observationImpl = new ObservationImpl(this.currentKey, this.obsTime, this.obsValue, this.attributes, new AnnotationBean[0]);
                return observationImpl;
            }
            ObservationImpl observationImpl = new ObservationImpl(this.currentKey, this.currentKey.getObsTime(), this.obsValue, this.attributes, this.crossSection, new AnnotationBean[0]);
            return observationImpl;
        }
        catch (Throwable th) {
            if (this.currentKey != null) {
                throw new SdmxSemmanticException(th, "Error while processing observation for key " + this.currentKey);
            }
            throw new SdmxSemmanticException(th, "Error while processing observation");
        }
        finally {
            this.attributes.clear();
        }
    }

    private void processObservation(XMLStreamReader parser) {
        this.clearObsInformation();
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            String attributeId = this.getComponentId(parser.getAttributeLocalName(i));
            String attributeValue = parser.getAttributeValue(i);
            if (!this.isTimeSeries() && attributeId.equals(this.getCrossSectionConcept())) {
                this.crossSection = new KeyValueImpl(attributeValue, attributeId);
                continue;
            }
            if (this.observationAttributes.contains(attributeId)) {
                this.attributeValues.put(attributeId, attributeValue);
                continue;
            }
            if (attributeId.equals(this.primaryMeasureConcept)) {
                this.obsValue = attributeValue;
                continue;
            }
            if (!attributeId.equals(this.timeConcept)) continue;
            this.obsTime = attributeValue;
        }
        try {
            this.processAttributes(this.observationAttributes, this.attributes);
        }
        catch (SdmxSemmanticException e) {
            throw new SdmxSemmanticException((Throwable)e, "Error while procesing observation attributes");
        }
        try {
            if (!this.isTimeSeries() && this.crossSection == null) {
                throw new SdmxSemmanticException("Error while processing observation for series '" + this.currentKey + "' , missing required concept '" + this.getCrossSectionConcept() + "'");
            }
        }
        catch (Throwable th) {
            if (this.currentKey != null) {
                throw new SdmxSemmanticException(th, "Error while processing observation for key " + this.currentKey);
            }
            throw new SdmxSemmanticException(th, "Error while processing observation");
        }
        this.attributeValues.clear();
    }

    private void clearObsInformation() {
        this.attributeValues.clear();
        this.obsTime = null;
        this.obsValue = null;
        this.attributes = new ArrayList<KeyValue>();
        this.crossSection = null;
    }

    private void processAttributes(Set<String> attributeConcepts, List<KeyValue> attributes) {
        for (String attributeConcept : attributeConcepts) {
            String conceptValue = null;
            conceptValue = this.attributeValues.containsKey(attributeConcept) ? this.attributeValues.get(attributeConcept) : this.rolledUpAttributes.get(attributeConcept);
            if (conceptValue == null) continue;
            KeyValueImpl kv = new KeyValueImpl(conceptValue, attributeConcept);
            attributes.add((KeyValue)kv);
        }
        if (this.attributeValues.keySet().size() != attributes.size()) {
            for (String attribute : this.attributeValues.keySet()) {
                if (attributeConcepts.contains(attribute)) continue;
                throw new SdmxSemmanticException("Unknown attribute '" + attribute + "' reported in the data.  This attribute is not defined by the data structure definition");
            }
        }
    }

    public static enum MOVE_TO {
        SERIES,
        GROUP,
        KEYABLE;

    }
}

