/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.engine.reader;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.sdmxsource.sdmx.api.constants.DATASET_POSITION;
import org.sdmxsource.sdmx.api.constants.DIMENSION_AT_OBSERVATION;
import org.sdmxsource.sdmx.api.engine.DataReaderEngine;
import org.sdmxsource.sdmx.api.exception.SdmxNotImplementedException;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ProvisionAgreementBean;
import org.sdmxsource.sdmx.api.model.data.Keyable;
import org.sdmxsource.sdmx.api.model.data.Observation;
import org.sdmxsource.sdmx.api.model.header.DatasetHeaderBean;
import org.sdmxsource.sdmx.api.model.header.DatasetStructureReferenceBean;
import org.sdmxsource.sdmx.api.model.header.HeaderBean;
import org.sdmxsource.sdmx.api.util.ReadableDataLocation;
import org.sdmxsource.sdmx.sdmxbeans.model.header.DatasetStructureReferenceBeanImpl;
import org.sdmxsource.util.io.StreamUtil;

public abstract class AbstractDataReaderEngine
implements DataReaderEngine,
Serializable {
    private static final long serialVersionUID = 3424676029992787805L;
    protected ReadableDataLocation dataLocation;
    private int datasetIndex = -1;
    private int keyableIndex = -1;
    private int obsIndex = -1;
    protected boolean hasNext = true;
    protected boolean hasNextObs = true;
    protected boolean hasNextDataset = true;
    protected DatasetHeaderBean datasetHeaderBean;
    protected DataStructureBean currentDsd;
    protected DataflowBean currentDataflow;
    protected ProvisionAgreementBean currentProvisionAgreement;
    protected DataflowBean defaultDataflow;
    protected DataStructureBean defaultDsd;
    protected SdmxBeanRetrievalManager beanRetrieval;
    protected Observation currentObs;
    protected Keyable currentKey;
    protected HeaderBean headerBean;
    protected DATASET_POSITION datasetPosition;

    public AbstractDataReaderEngine(ReadableDataLocation dataLocation, SdmxBeanRetrievalManager beanRetrieval, DataStructureBean defaultDsd, DataflowBean dataflowBean) {
        this.dataLocation = dataLocation;
        this.beanRetrieval = beanRetrieval;
        this.defaultDsd = defaultDsd;
        this.defaultDataflow = dataflowBean;
        if (beanRetrieval == null && defaultDsd == null) {
            throw new IllegalArgumentException("AbstractDataReaderEngine expects either a SdmxBeanRetrievalManager or a DataStructureBean to be able to interpret the structures");
        }
    }

    public void copyToOutputStream(OutputStream outputStream) {
        StreamUtil.copyStream((InputStream)this.dataLocation.getInputStream(), (OutputStream)outputStream);
    }

    public HeaderBean getHeader() {
        return this.headerBean;
    }

    public int getDatasetPosition() {
        return this.datasetIndex;
    }

    public DatasetHeaderBean getCurrentDatasetHeaderBean() {
        return this.datasetHeaderBean;
    }

    public DataflowBean getDataFlow() {
        return this.currentDataflow;
    }

    public ProvisionAgreementBean getProvisionAgreement() {
        return this.currentProvisionAgreement;
    }

    public boolean moveNextDataset() {
        this.currentKey = null;
        this.hasNextObs = true;
        this.obsIndex = -1;
        this.keyableIndex = -1;
        boolean moveSuccessful = this.moveNextDatasetInternal();
        if (moveSuccessful) {
            ++this.datasetIndex;
            this.determineCurrentDataStructure();
        }
        return moveSuccessful;
    }

    public DataStructureBean getDataStructure() {
        return this.currentDsd;
    }

    private void setCurrentDataflow(DataflowBean currentDataflow) {
        this.currentDataflow = currentDataflow;
        if (this.datasetHeaderBean.getDataStructureReference() == null) {
            DatasetStructureReferenceBeanImpl dsRefBean = new DatasetStructureReferenceBeanImpl(currentDataflow.asReference());
            this.datasetHeaderBean = this.datasetHeaderBean.modifyDataStructureReference((DatasetStructureReferenceBean)dsRefBean);
        }
        if (this.defaultDsd != null && this.defaultDsd.getUrn().equals(currentDataflow.getDataStructureRef().getTargetUrn())) {
            this.setCurrentDsd(this.defaultDsd);
        } else if (this.beanRetrieval != null) {
            this.setCurrentDsd((DataStructureBean)this.beanRetrieval.getMaintainableBean(DataStructureBean.class, currentDataflow.getDataStructureRef().getMaintainableReference()));
        }
    }

    protected void setCurrentDsd(DataStructureBean currentDsd) {
        this.currentDsd = currentDsd;
        if (this.datasetHeaderBean.getDataStructureReference() == null) {
            DatasetStructureReferenceBeanImpl dsRefBean = new DatasetStructureReferenceBeanImpl(currentDsd.asReference());
            this.datasetHeaderBean = this.datasetHeaderBean.modifyDataStructureReference((DatasetStructureReferenceBean)dsRefBean);
        }
    }

    private void setCurrentDsd(MaintainableRefBean dsdRef) {
        DataStructureBean dsd = (DataStructureBean)this.beanRetrieval.getMaintainableBean(DataStructureBean.class, dsdRef);
        if (dsd == null) {
            throw new RuntimeException("Can not read dataset, the data set references the DSD '" + dsdRef + "' which could not be resolved");
        }
        this.setCurrentDsd(dsd);
    }

    private void determineCurrentDataStructure() {
        this.currentDsd = null;
        this.currentDataflow = null;
        this.currentProvisionAgreement = null;
        DatasetStructureReferenceBean dsStructRef = null;
        if (this.datasetHeaderBean != null && (dsStructRef = this.datasetHeaderBean.getDataStructureReference()) == null && this.headerBean != null && this.headerBean.getStructures().size() == 1) {
            dsStructRef = (DatasetStructureReferenceBean)this.headerBean.getStructures().get(0);
        }
        if (dsStructRef != null) {
            StructureReferenceBean sRef = dsStructRef.getStructureReference();
            String errorString = sRef.getMaintainableReference().toString();
            switch (sRef.getTargetReference()) {
                case DSD: {
                    if (this.defaultDsd != null && sRef.isMatch((MaintainableBean)this.defaultDsd)) {
                        this.setCurrentDsd(this.defaultDsd);
                        break;
                    }
                    if (this.beanRetrieval == null) break;
                    this.setCurrentDsd(sRef.getMaintainableReference());
                    break;
                }
                case DATAFLOW: {
                    if (this.beanRetrieval != null) {
                        this.currentDataflow = (DataflowBean)this.beanRetrieval.getMaintainableBean(DataflowBean.class, sRef.getMaintainableReference());
                        if (this.currentDataflow == null) {
                            throw new RuntimeException("Could not read dataset, the data set references dataflow '" + errorString + "' which could not be resolved");
                        }
                        this.setCurrentDsd(this.currentDataflow.getDataStructureRef().getMaintainableReference());
                        break;
                    }
                    this.setCurrentDsd(this.defaultDsd);
                    this.currentDataflow = this.defaultDataflow;
                    break;
                }
                case PROVISION_AGREEMENT: {
                    if (this.beanRetrieval == null) break;
                    this.currentProvisionAgreement = (ProvisionAgreementBean)this.beanRetrieval.getMaintainableBean(ProvisionAgreementBean.class, sRef.getMaintainableReference());
                    if (this.currentProvisionAgreement == null) {
                        throw new RuntimeException("Could not read dataset, the data set references provision '" + errorString + "' which could not be resolved");
                    }
                    this.currentDataflow = (DataflowBean)this.beanRetrieval.getMaintainableBean(DataflowBean.class, this.currentProvisionAgreement.getStructureUseage().getMaintainableReference());
                    if (this.currentDataflow == null) {
                        throw new RuntimeException("Could not read dataset, the data set references dataflow '" + errorString + "' which could not be resolved");
                    }
                    this.setCurrentDsd(this.currentDataflow.getDataStructureRef().getMaintainableReference());
                    break;
                }
                default: {
                    throw new SdmxNotImplementedException("Can not write dataset for strucutre of type: " + sRef);
                }
            }
            if (this.currentDsd == null) {
                throw new RuntimeException("Can not read dataset, the data set references the DSD '" + errorString + "' which could not be resolved");
            }
        } else {
            if (this.defaultDsd == null) {
                throw new RuntimeException("Can not read dataset, the data set does no reference any data structures, and there was no default data structure definition provided");
            }
            if (this.defaultDataflow != null) {
                this.setCurrentDataflow(this.defaultDataflow);
            } else {
                this.setCurrentDsd(this.defaultDsd);
            }
        }
    }

    public final boolean moveNextKeyable() {
        if (this.datasetIndex == -1) {
            this.moveNextDataset();
        }
        this.currentKey = null;
        if (!this.hasNext) {
            return false;
        }
        this.hasNextObs = true;
        this.obsIndex = -1;
        ++this.keyableIndex;
        return this.moveNextKeyableInternal();
    }

    public final boolean moveNextObservation() {
        this.currentObs = null;
        if (!this.hasNext && !this.hasNextObs) {
            return false;
        }
        ++this.obsIndex;
        if (this.currentKey == null) {
            this.getCurrentKey();
        }
        this.hasNextObs = this.moveNextObservationInternal();
        return this.hasNextObs;
    }

    public final Observation getCurrentObservation() {
        if (this.currentObs != null) {
            return this.currentObs;
        }
        if (this.obsIndex < 0) {
            return null;
        }
        this.currentObs = this.lazyLoadObservation();
        return this.currentObs;
    }

    public final Keyable getCurrentKey() {
        if (this.currentKey != null) {
            return this.currentKey;
        }
        if (this.keyableIndex < 0) {
            return null;
        }
        this.currentKey = this.lazyLoadKey();
        return this.currentKey;
    }

    protected abstract Observation lazyLoadObservation();

    protected abstract Keyable lazyLoadKey();

    protected abstract boolean moveNextDatasetInternal();

    protected abstract boolean moveNextKeyableInternal();

    protected abstract boolean moveNextObservationInternal();

    public int getKeyablePosition() {
        return this.keyableIndex;
    }

    public int getObsPosition() {
        return this.obsIndex;
    }

    public boolean isTimeSeries() {
        return this.getCrossSectionConcept().equals(DIMENSION_AT_OBSERVATION.TIME.getVal()) || this.getCrossSectionConcept().equals(DIMENSION_AT_OBSERVATION.ALL.getVal());
    }

    public String getCrossSectionConcept() {
        if (this.datasetHeaderBean == null) {
            return "TIME_PERIOD";
        }
        return this.datasetHeaderBean.getDataStructureReference().getDimensionAtObservation();
    }

    public void reset() {
        this.hasNext = true;
        this.keyableIndex = -1;
        this.datasetIndex = -1;
        this.obsIndex = -1;
        this.currentObs = null;
        this.currentKey = null;
    }
}

