/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.engine.impl;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import org.sdmxsource.sdmx.api.constants.SDMX_SCHEMA;
import org.sdmxsource.sdmx.api.engine.SchemaWriterEngine;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.DataStructureSuperBean;
import org.sdmxsource.util.io.StreamUtil;

public class GenericSchemaWriterEngine
implements SchemaWriterEngine {
    private SDMX_SCHEMA schemaVersion;

    public GenericSchemaWriterEngine(SDMX_SCHEMA schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public void generateSchema(OutputStream out, DataStructureSuperBean dsd, String targetNamespace, Map<String, Set<String>> constraintsMap) {
        this.copyToStream(out);
    }

    public void generateCrossSectionalSchema(OutputStream out, DataStructureSuperBean dsd, String targetNamespace, String crossSectionalDimensionId, Map<String, Set<String>> constraintsMap) {
        this.copyToStream(out);
    }

    private void copyToStream(OutputStream out) {
        FileInputStream is;
        try {
            switch (this.schemaVersion) {
                case VERSION_ONE: {
                    is = new FileInputStream("resources/xsd/v2_0/SDMXMessage.xsd");
                    break;
                }
                case VERSION_TWO: {
                    is = new FileInputStream("resources/xsd/v2_0/SDMXMessage.xsd");
                    break;
                }
                case VERSION_TWO_POINT_ONE: {
                    is = new FileInputStream("resources/xsd/v2_0/SDMXMessage.xsd");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Generic format not supported in version : " + this.schemaVersion);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        StreamUtil.copyStream((InputStream)is, (OutputStream)out);
    }
}

