/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.engine.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sdmxsource.sdmx.api.engine.DataReaderEngine;
import org.sdmxsource.sdmx.api.model.data.KeyValue;
import org.sdmxsource.sdmx.api.model.data.Keyable;
import org.sdmxsource.sdmx.api.model.data.Observation;
import org.sdmxsource.sdmx.dataparser.engine.FixedConceptEngine;
import org.sdmxsource.sdmx.sdmxbeans.model.data.KeyValueImpl;
import org.springframework.stereotype.Service;

@Service
public class FixedConceptEngineImpl
implements FixedConceptEngine {
    @Override
    public List<KeyValue> getFixedConcepts(DataReaderEngine dre, boolean includeObs, boolean includeAttributes) {
        dre.reset();
        HashMap<String, String> conceptMap = new HashMap<String, String>();
        HashSet<String> skipConcepts = new HashSet<String>();
        while (dre.moveNextKeyable()) {
            Keyable key = dre.getCurrentKey();
            if (includeAttributes) {
                this.processKeyValues(key.getAttributes(), conceptMap, skipConcepts);
            }
            this.processKeyValues(key.getKey(), conceptMap, skipConcepts);
            if (!includeObs) continue;
            while (dre.moveNextObservation()) {
                Observation obs = dre.getCurrentObservation();
                if (includeAttributes) {
                    this.processKeyValues(obs.getAttributes(), conceptMap, skipConcepts);
                }
                if (!obs.isCrossSection()) continue;
                this.processKeyValue(obs.getCrossSectionalValue(), conceptMap, skipConcepts);
            }
        }
        ArrayList<KeyValue> fixedKeyValues = new ArrayList<KeyValue>();
        for (String fixedConcept : conceptMap.keySet()) {
            fixedKeyValues.add((KeyValue)new KeyValueImpl((String)conceptMap.get(fixedConcept), fixedConcept));
        }
        return fixedKeyValues;
    }

    private void processKeyValues(List<KeyValue> kvs, Map<String, String> conceptMap, Set<String> skipConcepts) {
        for (KeyValue kv : kvs) {
            this.processKeyValue(kv, conceptMap, skipConcepts);
        }
    }

    private void processKeyValue(KeyValue kv, Map<String, String> conceptMap, Set<String> skipConcepts) {
        String currentConcept = kv.getConcept();
        if (skipConcepts.contains(currentConcept)) {
            return;
        }
        if (!conceptMap.containsKey(currentConcept)) {
            conceptMap.put(currentConcept, kv.getCode());
            return;
        }
        if (!conceptMap.get(currentConcept).equals(kv.getCode())) {
            conceptMap.remove(currentConcept);
            skipConcepts.add(currentConcept);
        }
    }
}

