/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.engine.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.engine.DataReaderEngine;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxSuperBeanRetrievalManager;
import org.sdmxsource.sdmx.api.model.beans.base.TextFormatBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.data.KeyValue;
import org.sdmxsource.sdmx.api.model.data.Keyable;
import org.sdmxsource.sdmx.api.model.data.Observation;
import org.sdmxsource.sdmx.api.model.superbeans.base.ComponentSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.codelist.CodeSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.codelist.CodelistSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.AttributeSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.DataStructureSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.DimensionSuperBean;
import org.sdmxsource.sdmx.dataparser.engine.impl.AbstractDataValidationEngine;
import org.sdmxsource.sdmx.util.beans.UrnUtil;
import org.sdmxsource.sdmx.util.date.DateUtil;
import org.sdmxsource.util.ObjectUtil;

public class DeepDataValidationEngine
extends AbstractDataValidationEngine {
    private SdmxSuperBeanRetrievalManager superBeanRetrievalManager;
    private DataStructureSuperBean dsdSuperBean;
    private Map<String, AttributeSuperBean> seriesAttributes = new HashMap<String, AttributeSuperBean>();
    private Map<String, AttributeSuperBean> obsAttributes = new HashMap<String, AttributeSuperBean>();
    private Map<String, DimensionSuperBean> dimensionMap = new HashMap<String, DimensionSuperBean>();

    public DeepDataValidationEngine(DataReaderEngine dataReaderEngine, SdmxSuperBeanRetrievalManager superBeanRetrievalManager) {
        super(dataReaderEngine);
        this.superBeanRetrievalManager = superBeanRetrievalManager;
    }

    @Override
    protected void setDsd(DataStructureBean dsd) {
        super.setDsd(dsd);
        this.dsdSuperBean = this.superBeanRetrievalManager.getDataStructureSuperBean(dsd.asReference().getMaintainableReference());
        for (DimensionSuperBean dimension : this.dsdSuperBean.getDimensions()) {
            if (dimension.isMeasureDimension() || dimension.isTimeDimension()) continue;
            this.dimensionMap.put(dimension.getId(), dimension);
            ++this.dimSize;
        }
        for (AttributeSuperBean att : this.dsdSuperBean.getSeriesAttributes()) {
            if (!this.isTimeSeries && att.getDimensionReferences().contains(this.dimensionAtObservation)) {
                this.obsAttributes.put(att.getId(), att);
                continue;
            }
            this.seriesAttributes.put(att.getId(), att);
        }
        for (AttributeSuperBean att : this.dsdSuperBean.getObservationAttributes()) {
            this.obsAttributes.put(att.getId(), att);
        }
    }

    @Override
    protected void validateObservation(Observation obs) {
        super.validateObservation(obs);
        this.validateTextFormat(this.dsdSuperBean.getPrimaryMeasure().getTextFormat(), obs.getObservationValue());
        for (KeyValue kv : obs.getAttributes()) {
            AttributeSuperBean attribute = this.obsAttributes.get(kv.getConcept());
            if (attribute == null) {
                throw new SdmxSemmanticException("DSD observation attribute not found : " + kv.getConcept());
            }
            if (!attribute.isMandatory() && !ObjectUtil.validString((String[])new String[]{kv.getCode()})) continue;
            this.validateComponent(kv, (ComponentSuperBean)attribute);
        }
    }

    @Override
    protected void validateSeriesKey(Keyable keyable) {
        try {
            if (keyable.getKey().size() != this.dimSize) {
                throw new SdmxSemmanticException("Dataset key unexpected size.  Got '" + keyable.getKey().size() + "', expected '" + this.dimSize + "' ");
            }
            for (KeyValue kv : keyable.getKey()) {
                DimensionSuperBean dimension = this.dimensionMap.get(kv.getConcept());
                if (dimension == null) {
                    throw new SdmxSemmanticException("DSD series key component not found : " + kv.getConcept());
                }
                this.validateComponent(kv, (ComponentSuperBean)dimension);
            }
            for (KeyValue kv : keyable.getAttributes()) {
                AttributeSuperBean attribute = this.seriesAttributes.get(kv.getConcept());
                if (attribute == null) {
                    throw new SdmxSemmanticException("DSD series attribute not found : " + kv.getConcept());
                }
                this.validateComponent(kv, (ComponentSuperBean)attribute);
            }
        }
        catch (SdmxSemmanticException e) {
            if (keyable.isSeries()) {
                throw new SdmxSemmanticException((Throwable)e, "Error while processing series key: " + keyable.toString());
            }
            throw new SdmxSemmanticException((Throwable)e, "Error while processing group key: " + keyable.toString());
        }
    }

    private void validateComponent(KeyValue kv, ComponentSuperBean component) {
        if (component.getTextFormat() != null) {
            this.validateTextFormat(component.getTextFormat(), kv.getCode());
        }
        this.validateCode(kv, component);
    }

    private void validateTextFormat(TextFormatBean textFormat, String value) {
        Date dte;
        if (textFormat == null) {
            return;
        }
        switch (textFormat.getTextType()) {
            case DOUBLE: {
                try {
                    Double.parseDouble(value);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new SdmxSemmanticException("Value '" + value + "' is not of expected type 'Double'");
                }
            }
            case BIG_INTEGER: {
                try {
                    new BigInteger(value);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new SdmxSemmanticException("Value '" + value + "' is not of expected type 'Big Integer'");
                }
            }
            case INTEGER: {
                try {
                    new Integer(value);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new SdmxSemmanticException("Value '" + value + "' is not of expected type 'Integer'");
                }
            }
            case LONG: {
                try {
                    new Long(value);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new SdmxSemmanticException("Value '" + value + "' is not of expected type 'Long'");
                }
            }
            case SHORT: {
                try {
                    new Short(value);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new SdmxSemmanticException("Value '" + value + "' is not of expected type 'Short'");
                }
            }
            case DECIMAL: {
                try {
                    new BigDecimal(value);
                    break;
                }
                catch (SdmxSemmanticException e) {
                    throw new SdmxSemmanticException("Value '" + value + "' is not of expected type 'Decimal'");
                }
            }
            case FLOAT: {
                try {
                    new Float(value);
                    break;
                }
                catch (SdmxSemmanticException e) {
                    throw new SdmxSemmanticException("Value '" + value + "' is not of expected type 'Float'");
                }
            }
            case BOOLEAN: {
                if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) break;
                throw new SdmxSemmanticException("Value '" + value + "' is not of expected type 'Boolean'");
            }
            case DATE: {
                try {
                    DateUtil.getTimeFormatOfDate((String)value);
                    break;
                }
                catch (SdmxSemmanticException e) {
                    throw new SdmxSemmanticException("Value '" + value + "' is not of expected type 'Date'");
                }
            }
            case DATE_TIME: {
                try {
                    DateUtil.getTimeFormatOfDate((String)value);
                    break;
                }
                catch (SdmxSemmanticException e) {
                    throw new SdmxSemmanticException("Value '" + value + "' is not of expected type 'Date'");
                }
            }
            case YEAR: {
                try {
                    if (value.length() != 4) {
                        throw new SdmxSemmanticException("Value '" + value + "' is not of expected type 'Year', expected year length of 4");
                    }
                    new Integer(value);
                    break;
                }
                catch (SdmxSemmanticException e) {
                    throw new SdmxSemmanticException("Value '" + value + "' is not of expected type 'Year'");
                }
            }
            case TIME: {
                try {
                    DateUtil.getTimeFormatOfDate((String)value);
                    break;
                }
                catch (SdmxSemmanticException e) {
                    throw new SdmxSemmanticException("Value '" + value + "' is not of expected type 'Date'");
                }
            }
            case IDENTIFIABLE_REFERENCE: {
                try {
                    SDMX_STRUCTURE_TYPE targetStructure = UrnUtil.getIdentifiableType((String)value);
                    UrnUtil.validateURN((String)value, (SDMX_STRUCTURE_TYPE)targetStructure);
                    break;
                }
                catch (SdmxSemmanticException e) {
                    throw new SdmxSemmanticException((Throwable)e, "Value '" + value + "' is not of expected type 'Identifiable Reference' a valid URN is expected");
                }
            }
            case URI: {
                try {
                    new URI(value);
                    break;
                }
                catch (URISyntaxException e) {
                    throw new SdmxSemmanticException((Throwable)e, "Value '" + value + "' is not of expected type 'URI'");
                }
            }
        }
        if (textFormat.getDecimals() != null) {
            try {
                Double valAsDouble = Double.parseDouble(value);
                int num = this.getNumberOfDecimalPlace(valAsDouble);
                if (num > textFormat.getDecimals().intValue()) {
                    throw new SdmxSemmanticException("Value '" + value + "' exceeds the number of allowed decimal places of " + textFormat.getDecimals().toString());
                }
            }
            catch (NumberFormatException e) {
                throw new SdmxSemmanticException("Value '" + value + "' expected to be numerical");
            }
        }
        if (textFormat.getMinLength() != null && value.length() < textFormat.getMinLength().intValue()) {
            throw new SdmxSemmanticException("Value '" + value + "' is shorter then the minimuim allowed length of '" + textFormat.getMinLength().toString() + "'");
        }
        if (textFormat.getMaxLength() != null && value.length() > textFormat.getMaxLength().intValue()) {
            throw new SdmxSemmanticException("Value '" + value + "' is greater then the maximuim allowed length of '" + textFormat.getMaxLength().toString() + "'");
        }
        if (textFormat.getStartValue() != null) {
            BigDecimal valueAsDecimal = this.parseBigDecimal(value);
            if (valueAsDecimal.compareTo(textFormat.getStartValue()) < 0) {
                throw new SdmxSemmanticException("Value '" + value + "' is less then the specified start value of " + textFormat.getStartValue().toPlainString());
            }
            if (textFormat.getInterval() != null && valueAsDecimal.subtract(textFormat.getStartValue()).remainder(textFormat.getInterval()).compareTo(BigDecimal.ZERO) != 0) {
                throw new SdmxSemmanticException("Value '" + value + "' do not fit the allowed intervals starting from " + textFormat.getStartValue().toPlainString() + " and increasing by " + textFormat.getInterval().toPlainString());
            }
        }
        if (textFormat.getEndValue() != null && this.parseBigDecimal(value).compareTo(textFormat.getEndValue()) > 0) {
            throw new SdmxSemmanticException("Value '" + value + "' is greater then the specified end value of " + textFormat.getEndValue().toPlainString());
        }
        if (textFormat.getMinValue() != null && this.parseBigDecimal(value).compareTo(textFormat.getMinValue()) < 0) {
            throw new SdmxSemmanticException("Value '" + value + "' is less then the specified min value of " + textFormat.getMinValue().toPlainString());
        }
        if (textFormat.getMaxValue() != null && this.parseBigDecimal(value).compareTo(textFormat.getMaxValue()) > 0) {
            throw new SdmxSemmanticException("Value '" + value + "' is greater then the specified end value of " + textFormat.getMaxValue().toPlainString());
        }
        if (textFormat.getStartTime() != null) {
            try {
                dte = DateUtil.formatDate((Object)value, (boolean)true);
                if (dte.before(textFormat.getStartTime().getDate())) {
                    throw new SdmxSemmanticException("Value '" + value + "' is before the allowed start time of " + textFormat.getStartTime().getDateInSdmxFormat());
                }
            }
            catch (NumberFormatException e) {
                throw new SdmxSemmanticException("Value '" + value + "' is not of expected type 'Date'");
            }
        }
        if (textFormat.getEndTime() != null) {
            try {
                dte = DateUtil.formatDate((Object)value, (boolean)true);
                if (dte.after(textFormat.getEndTime().getDate())) {
                    throw new SdmxSemmanticException("Value '" + value + "' is after the allowed start time of " + textFormat.getStartTime().getDateInSdmxFormat());
                }
            }
            catch (NumberFormatException e) {
                throw new SdmxSemmanticException("Value '" + value + "' is not of expected type 'Date'");
            }
        }
    }

    private BigDecimal parseBigDecimal(String value) {
        try {
            return new BigDecimal(value);
        }
        catch (NumberFormatException e) {
            throw new SdmxSemmanticException("Value '" + value + "' expected to be numerical");
        }
    }

    private int getNumberOfDecimalPlace(double value) {
        if ((double)Math.round(value) == value) {
            return 0;
        }
        String s = Double.toString(value);
        System.out.println(s);
        int index = s.indexOf(46);
        if (index < 0) {
            return 0;
        }
        return s.length() - 1 - index;
    }

    private void validateCode(KeyValue kv, ComponentSuperBean component) {
        CodelistSuperBean codelist = component.getCodelist(true);
        if (codelist != null) {
            if (!ObjectUtil.validString((String[])new String[]{kv.getCode()})) {
                throw new SdmxSemmanticException("No value reported for concept : " + kv.getConcept());
            }
            CodeSuperBean code = codelist.getCodeByValue(kv.getCode());
            if (code == null) {
                throw new SdmxSemmanticException("No code '" + kv.getCode() + "' found in codelist : " + codelist.getUrn());
            }
        }
    }
}

