/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.rconnector.client;

import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import javax.xml.ws.EndpointReference;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class JaxRSEndpointReference {
    private static final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private static final String addressLocalName = "Address";
    String address;

    JaxRSEndpointReference(EndpointReference reference) {
        this(JaxRSEndpointReference.serialise(reference));
    }

    JaxRSEndpointReference(String reference) {
        try {
            Document document = factory.newDocumentBuilder().parse(new InputSource(new StringReader(reference)));
            NodeList addresses = document.getElementsByTagNameNS("*", addressLocalName);
            if (addresses.getLength() == 0) {
                throw new RuntimeException("reference does not contain an address");
            }
            this.address = addresses.item(0).getTextContent();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("reference is not a gCore reference", e);
        }
    }

    public String toString() {
        return this.address;
    }

    private static String serialise(EndpointReference reference) {
        StringWriter writer = new StringWriter();
        reference.writeTo((Result)new StreamResult(writer));
        return writer.toString();
    }

    static {
        factory.setNamespaceAware(true);
    }
}

