/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.tdwx.server.datasource.util;

import java.io.IOException;
import java.io.Writer;
import java.util.Date;

public class GridJSonWriter {
    protected JGridSonWriterState state;
    protected boolean dataDeclared = false;
    protected boolean totalLengthDeclared = false;
    protected boolean offsetDeclared = false;
    protected Writer writer;
    protected boolean firstField = true;
    protected boolean firstRow = true;
    protected boolean firstColumn = true;
    protected int rowsCount = 0;
    protected int fieldsCount;

    public GridJSonWriter(Writer writer) throws IOException {
        this.writer = writer;
        writer.append('{');
        this.state = JGridSonWriterState.READY;
    }

    protected void checkState(JGridSonWriterState expectedState) {
        if (this.state != expectedState) {
            throw new IllegalStateException("Writer in state " + (Object)((Object)this.state) + " instead of " + (Object)((Object)expectedState));
        }
    }

    protected void checkFirstField() throws IOException {
        if (!this.firstField) {
            this.writer.append(',');
        } else {
            this.firstField = false;
        }
    }

    public void startData(String dataField) throws IOException {
        this.checkState(JGridSonWriterState.READY);
        if (this.dataDeclared) {
            throw new IllegalStateException("Data field already declared");
        }
        this.state = JGridSonWriterState.DATA;
        this.checkFirstField();
        this.writer.append('\"');
        this.writer.append(dataField);
        this.writer.append("\":[");
        this.firstRow = true;
    }

    public void startRow() throws IOException {
        this.checkState(JGridSonWriterState.DATA);
        this.state = JGridSonWriterState.INROW;
        this.fieldsCount = 0;
        this.firstColumn = true;
        if (!this.firstRow) {
            this.writer.append(',');
        } else {
            this.firstRow = false;
        }
        this.writer.append('{');
    }

    protected void addKey(String key) throws IOException {
        this.appendQuoted(key);
        this.writer.append(':');
    }

    protected void addValueKey(String key) throws IOException {
        this.checkState(JGridSonWriterState.INROW);
        if (this.firstColumn) {
            this.firstColumn = false;
        } else {
            this.writer.append(',');
        }
        this.addKey(key);
        ++this.fieldsCount;
    }

    public void addValue(String id, Boolean value) throws IOException {
        this.addValueKey(id);
        if (value == null) {
            this.writer.append("null");
        } else {
            this.writer.append(value != false ? "true" : "false");
        }
    }

    public void addValue(String id, Date value) throws IOException {
        this.addValueKey(id);
        this.writer.append(value == null ? "null" : String.valueOf(value.getTime()));
    }

    public void addValue(String id, Double value) throws IOException {
        this.addValueKey(id);
        this.writer.append(value == null ? "null" : String.valueOf(value));
    }

    public void addValue(String id, Long value) throws IOException {
        this.addValueKey(id);
        this.writer.append(value == null ? "null" : String.valueOf(value));
    }

    public void addValue(String id, String value) throws IOException {
        this.addValueKey(id);
        if (value == null) {
            this.writer.append("null");
        } else {
            this.appendQuoted(value);
        }
    }

    public void endRow() throws IOException {
        this.checkState(JGridSonWriterState.INROW);
        this.state = JGridSonWriterState.DATA;
        ++this.rowsCount;
        this.writer.append('}');
    }

    public void endData() throws IOException {
        this.checkState(JGridSonWriterState.DATA);
        this.state = JGridSonWriterState.READY;
        this.writer.append("]");
        this.dataDeclared = true;
    }

    public void setTotalLength(String totalLengthField, int length) throws IOException {
        this.checkState(JGridSonWriterState.READY);
        if (this.totalLengthDeclared) {
            throw new IllegalStateException("Total length field already declared");
        }
        this.checkFirstField();
        this.addKey(totalLengthField);
        this.writer.append(String.valueOf(length));
        this.totalLengthDeclared = true;
    }

    public void setOffset(String offsetField, int offset) throws IOException {
        this.checkState(JGridSonWriterState.READY);
        if (this.offsetDeclared) {
            throw new IllegalStateException("Offset field already declared");
        }
        this.checkFirstField();
        this.addKey(offsetField);
        this.writer.append(String.valueOf(offset));
        this.offsetDeclared = true;
    }

    public void close() throws IOException {
        this.checkState(JGridSonWriterState.READY);
        if (!this.dataDeclared) {
            throw new IllegalStateException("No data field adeclared");
        }
        if (!this.totalLengthDeclared) {
            throw new IllegalStateException("No total length field declared");
        }
        if (!this.offsetDeclared) {
            throw new IllegalStateException("No offset field declared");
        }
        this.state = JGridSonWriterState.CLOSED;
        this.writer.append('}');
    }

    protected void appendQuoted(String value) throws IOException {
        if (value == null || value.length() == 0) {
            this.writer.append("\"\"");
        } else {
            char c = '\u0000';
            int len = value.length();
            this.writer.append('\"');
            int i = 0;
            while (i < len) {
                char b = c;
                c = value.charAt(i);
                switch (c) {
                    case '\"': 
                    case '\\': {
                        this.writer.append('\\');
                        this.writer.append(c);
                        break;
                    }
                    case '/': {
                        if (b == '<') {
                            this.writer.append('\\');
                        }
                        this.writer.append(c);
                        break;
                    }
                    case '\b': {
                        this.writer.append("\\b");
                        break;
                    }
                    case '\t': {
                        this.writer.append("\\t");
                        break;
                    }
                    case '\n': {
                        this.writer.append("\\n");
                        break;
                    }
                    case '\f': {
                        this.writer.append("\\f");
                        break;
                    }
                    case '\r': {
                        this.writer.append("\\r");
                        break;
                    }
                    default: {
                        if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                            String t = "000" + Integer.toHexString(c);
                            this.writer.append("\\u" + t.substring(t.length() - 4));
                            break;
                        }
                        this.writer.append(c);
                    }
                }
                ++i;
            }
            this.writer.append('\"');
        }
    }

    protected static enum JGridSonWriterState {
        READY,
        DATA,
        INROW,
        CLOSED;

    }
}

