/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.tdwx.server.datasource.util;

import java.util.Date;

public class GridJSonBuilder {
    protected JGridSonWriterState state;
    protected boolean rowsDeclared;
    protected boolean totalLengthDeclared;
    protected boolean offsetDeclared;
    protected StringBuilder json;
    protected boolean firstField;
    protected boolean firstRow;
    protected boolean firstColumn;
    protected int rowsCount;
    protected int fieldsCount;

    public GridJSonBuilder() {
        this.clean();
    }

    protected void resetState() {
        this.state = JGridSonWriterState.DATA;
        this.rowsDeclared = false;
        this.totalLengthDeclared = false;
        this.offsetDeclared = false;
    }

    public void clean() {
        this.json = new StringBuilder();
        this.json.append('{');
        this.firstField = true;
        this.firstRow = true;
        this.firstColumn = true;
        this.rowsCount = 0;
        this.fieldsCount = 0;
        this.resetState();
    }

    protected void checkState(JGridSonWriterState expectedState) {
        if (this.state != expectedState) {
            throw new IllegalStateException("Writer in state " + (Object)((Object)this.state) + " instead of " + (Object)((Object)expectedState));
        }
    }

    protected void checkFirstField() {
        if (!this.firstField) {
            this.json.append(',');
        } else {
            this.firstField = false;
        }
    }

    public void startRows(String dataField) {
        this.checkState(JGridSonWriterState.DATA);
        if (this.rowsDeclared) {
            throw new IllegalStateException("Data field already declared");
        }
        this.state = JGridSonWriterState.ROWS;
        this.checkFirstField();
        this.json.append("\"");
        this.json.append(dataField);
        this.json.append("\":[");
        this.firstRow = true;
    }

    public void startRow() {
        this.checkState(JGridSonWriterState.ROWS);
        this.state = JGridSonWriterState.ROW;
        this.fieldsCount = 0;
        this.firstColumn = true;
        if (!this.firstRow) {
            this.json.append(',');
        } else {
            this.firstRow = false;
        }
        this.json.append('{');
    }

    protected void addKey(String key) {
        this.appendQuoted(key);
        this.json.append(':');
    }

    protected void addValueKey(String key) {
        this.checkState(JGridSonWriterState.ROW);
        if (this.firstColumn) {
            this.firstColumn = false;
        } else {
            this.json.append(',');
        }
        this.addKey(key);
        ++this.fieldsCount;
    }

    public void addValue(String id, Date value) {
        this.addValueKey(id);
        this.json.append(value == null ? "null" : Long.valueOf(value.getTime()));
    }

    public void addValue(String id, Boolean value) {
        this.addValueKey(id);
        if (value == null) {
            this.json.append("null");
        } else {
            this.json.append(value != false ? "true" : "false");
        }
    }

    public void addValue(String id, Double value) {
        this.addValueKey(id);
        this.json.append(value == null ? "null" : value);
    }

    public void addValue(String id, Long value) {
        this.addValueKey(id);
        this.json.append(value == null ? "null" : value);
    }

    public void addValue(String id, Integer value) {
        this.addValueKey(id);
        this.json.append(value == null ? "null" : value);
    }

    public void addValue(String id, String value) {
        this.addValueKey(id);
        if (value == null) {
            this.json.append("null");
        } else {
            this.appendQuoted(value);
        }
    }

    public void endRow() {
        this.checkState(JGridSonWriterState.ROW);
        this.state = JGridSonWriterState.ROWS;
        ++this.rowsCount;
        this.json.append('}');
    }

    public void endRows() {
        this.checkState(JGridSonWriterState.ROWS);
        this.state = JGridSonWriterState.DATA;
        this.json.append("]");
        this.rowsDeclared = true;
    }

    public void setTotalLength(String totalLengthField, int length) {
        this.checkState(JGridSonWriterState.DATA);
        if (this.totalLengthDeclared) {
            throw new IllegalStateException("Total length field already declared");
        }
        this.checkFirstField();
        this.addKey(totalLengthField);
        this.json.append(length);
        this.totalLengthDeclared = true;
    }

    public void setOffset(String offsetField, int offset) {
        this.checkState(JGridSonWriterState.DATA);
        if (this.offsetDeclared) {
            throw new IllegalStateException("Offset field already declared");
        }
        this.checkFirstField();
        this.addKey(offsetField);
        this.json.append(offset);
        this.offsetDeclared = true;
    }

    public void close() {
        this.checkState(JGridSonWriterState.DATA);
        if (!this.rowsDeclared) {
            throw new IllegalStateException("No rows field adeclared");
        }
        if (!this.totalLengthDeclared) {
            throw new IllegalStateException("No total length field declared");
        }
        if (!this.offsetDeclared) {
            throw new IllegalStateException("No offset field declared");
        }
        this.state = JGridSonWriterState.CLOSED;
        this.json.append("}");
    }

    public String toString() {
        this.checkState(JGridSonWriterState.CLOSED);
        return this.json.toString();
    }

    protected void appendQuoted(String value) {
        if (value == null || value.length() == 0) {
            this.json.append("\"\"");
        } else {
            char c = '\u0000';
            int len = value.length();
            this.json.append('\"');
            int i = 0;
            while (i < len) {
                char b = c;
                c = value.charAt(i);
                switch (c) {
                    case '\"': 
                    case '\\': {
                        this.json.append('\\');
                        this.json.append(c);
                        break;
                    }
                    case '/': {
                        if (b == '<') {
                            this.json.append('\\');
                        }
                        this.json.append(c);
                        break;
                    }
                    case '\b': {
                        this.json.append("\\b");
                        break;
                    }
                    case '\t': {
                        this.json.append("\\t");
                        break;
                    }
                    case '\n': {
                        this.json.append("\\n");
                        break;
                    }
                    case '\f': {
                        this.json.append("\\f");
                        break;
                    }
                    case '\r': {
                        this.json.append("\\r");
                        break;
                    }
                    default: {
                        if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                            String t = "000" + Integer.toHexString(c);
                            this.json.append("\\u" + t.substring(t.length() - 4));
                            break;
                        }
                        this.json.append(c);
                    }
                }
                ++i;
            }
            this.json.append('\"');
        }
    }

    protected static enum JGridSonWriterState {
        DATA,
        ROWS,
        ROW,
        CLOSED;

    }
}

