/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.tdwx.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import javax.servlet.http.HttpSession;
import org.gcube.portlets.user.tdwx.client.rpc.TabularDataXService;
import org.gcube.portlets.user.tdwx.client.rpc.TabularDataXServiceException;
import org.gcube.portlets.user.tdwx.server.datasource.DataSourceX;
import org.gcube.portlets.user.tdwx.server.datasource.DataSourceXException;
import org.gcube.portlets.user.tdwx.server.util.SessionUtil;
import org.gcube.portlets.user.tdwx.shared.ColumnsReorderingConfig;
import org.gcube.portlets.user.tdwx.shared.model.TableDefinition;
import org.gcube.portlets.user.tdwx.shared.model.TableId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabularDataXServiceImpl
extends RemoteServiceServlet
implements TabularDataXService {
    private static final long serialVersionUID = 193560783723693864L;
    protected static Logger logger = LoggerFactory.getLogger(TabularDataXServiceImpl.class);

    protected DataSourceX getDataSource(int tdSessionId) {
        HttpSession httpSession = this.getThreadLocalRequest().getSession();
        return SessionUtil.getDataSource(httpSession, tdSessionId);
    }

    @Override
    public TableDefinition openTable(int tdSessionId, TableId tableId) throws TabularDataXServiceException {
        logger.debug("openTable tdSessionId: " + tdSessionId + " tableId: " + tableId);
        try {
            this.closeCurrentTable(tdSessionId, true);
            HttpSession httpSession = this.getThreadLocalRequest().getSession();
            DataSourceX dataSource = SessionUtil.openDataSource(httpSession, tableId);
            SessionUtil.setDataSource(httpSession, tdSessionId, dataSource);
            logger.debug("Open table get table definition");
            return dataSource.getTableDefinition();
        }
        catch (Exception e) {
            logger.error("An error occurred opening the specified table " + tableId + " in session " + tdSessionId, (Throwable)e);
            throw new TabularDataXServiceException("An error occurred opening the specified table: " + e.getMessage());
        }
    }

    @Override
    public TableDefinition getCurrentTableDefinition(int tdSessionId) throws TabularDataXServiceException {
        logger.debug("getCurrentTableDefinition tdSessionId: " + tdSessionId);
        try {
            DataSourceX dataSource = this.getDataSource(tdSessionId);
            logger.debug("Service get current table definition");
            return dataSource.getTableDefinition();
        }
        catch (Exception e) {
            logger.error("An error occurred retrieving the table definition", (Throwable)e);
            throw new TabularDataXServiceException("An error occurred retrieving the table definition: " + e.getMessage());
        }
    }

    @Override
    public TableDefinition setCurrentTableColumnsReordering(int tdSessionId, ColumnsReorderingConfig columnReorderingConfig) throws TabularDataXServiceException {
        logger.debug("setCurrentTableColumnsReordering tdSessionId: " + tdSessionId);
        try {
            DataSourceX dataSource = this.getDataSource(tdSessionId);
            logger.debug("Service get current table definition");
            TableDefinition tableDefinition = dataSource.setColumnReordering(columnReorderingConfig);
            return tableDefinition;
        }
        catch (Exception e) {
            logger.error("An error occurred setting columns reordering", (Throwable)e);
            throw new TabularDataXServiceException("An error occurred setting columns reordering: " + e.getMessage());
        }
    }

    @Override
    public TableDefinition getTableDefinition(TableId id) throws TabularDataXServiceException {
        logger.debug("getTableDefinition TableId: " + id);
        try {
            HttpSession httpSession = this.getThreadLocalRequest().getSession();
            DataSourceX dataSource = SessionUtil.openDataSource(httpSession, id);
            logger.debug("Service get table definition");
            return dataSource.getTableDefinition();
        }
        catch (Exception e) {
            logger.error("An error occurred getting the table definition", (Throwable)e);
            throw new TabularDataXServiceException("An error occurred getting the table definition: " + e.getMessage());
        }
    }

    @Override
    public void closeTable(int tdSessionId) throws TabularDataXServiceException {
        try {
            this.closeCurrentTable(tdSessionId, false);
        }
        catch (DataSourceXException e) {
            logger.error("An error occurred closing the current table", (Throwable)e);
            throw new TabularDataXServiceException("An error occurred closing the current table: " + e.getMessage());
        }
    }

    protected void closeCurrentTable(int tdSessionId, boolean silent) throws DataSourceXException {
        block2: {
            try {
                HttpSession httpSession = this.getThreadLocalRequest().getSession();
                SessionUtil.closeDataSource(httpSession, tdSessionId);
            }
            catch (DataSourceXException e) {
                if (silent) break block2;
                throw e;
            }
        }
    }
}

