/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.tdwx.client.filter;

import com.google.gwt.user.client.ui.Widget;
import com.sencha.gxt.core.client.ValueProvider;
import com.sencha.gxt.core.client.dom.XDOM;
import com.sencha.gxt.core.client.util.Util;
import com.sencha.gxt.data.shared.loader.BooleanFilterHandler;
import com.sencha.gxt.data.shared.loader.FilterConfig;
import com.sencha.gxt.data.shared.loader.FilterConfigBean;
import com.sencha.gxt.data.shared.loader.FilterHandler;
import com.sencha.gxt.widget.core.client.event.CheckChangeEvent;
import com.sencha.gxt.widget.core.client.grid.filters.Filter;
import com.sencha.gxt.widget.core.client.menu.CheckMenuItem;
import java.util.List;

public class ExtendedBooleanFilter<M>
extends Filter<M, Boolean> {
    private CheckMenuItem yesItem;
    private CheckMenuItem noItem;
    private BooleanFilterMessages messages = new DefaultBooleanFilterMessages();
    private CheckChangeEvent.CheckChangeHandler<CheckMenuItem> handler = new CheckChangeEvent.CheckChangeHandler<CheckMenuItem>(){

        public void onCheckChange(CheckChangeEvent<CheckMenuItem> event) {
            ExtendedBooleanFilter.this.fireUpdate();
        }
    };

    public ExtendedBooleanFilter(ValueProvider<? super M, Boolean> valueProvider) {
        super(valueProvider);
        this.setHandler((FilterHandler)new BooleanFilterHandler());
        this.yesItem = new CheckMenuItem();
        this.yesItem.addCheckChangeHandler(this.handler);
        this.yesItem.setGroup(XDOM.getUniqueId());
        this.noItem = new CheckMenuItem();
        this.noItem.addCheckChangeHandler(this.handler);
        this.noItem.setGroup(this.yesItem.getGroup());
        this.menu.add((Widget)this.yesItem);
        this.menu.add((Widget)this.noItem);
        this.setMessages(this.messages);
    }

    public List<FilterConfig> getFilterConfig() {
        FilterConfigBean config = new FilterConfigBean();
        config.setType("boolean");
        config.setValue(this.getHandler().convertToString((Object)((Boolean)this.getValue())));
        return Util.createList((Object[])new FilterConfig[]{config});
    }

    public BooleanFilterMessages getMessages() {
        return this.messages;
    }

    public Object getValue() {
        return this.yesItem.isChecked();
    }

    public boolean isActive() {
        return super.isActive();
    }

    public void setMessages(BooleanFilterMessages messages) {
        this.messages = messages;
        this.yesItem.setText(this.getMessages().yesText());
        this.noItem.setText(this.getMessages().noText());
    }

    protected Class<Boolean> getType() {
        return Boolean.class;
    }

    protected boolean isActivatable() {
        return super.isActivatable();
    }

    protected boolean validateModel(M model) {
        Boolean val = (Boolean)this.getValueProvider().getValue(model);
        return this.getValue().equals(val == null ? Boolean.FALSE : val);
    }

    public static interface BooleanFilterMessages {
        public String noText();

        public String yesText();
    }

    public class DefaultBooleanFilterMessages
    implements BooleanFilterMessages {
        @Override
        public String noText() {
            return "false";
        }

        @Override
        public String yesText() {
            return "true";
        }
    }
}

