package org.gcube.portlets.user.occurrencemanagement.shared;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;

import com.extjs.gxt.ui.client.data.BaseModelData;

/**
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 *
 */
public class JobOccurrencesModel extends BaseModelData implements Serializable {



	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	public static final String JOBINDENTIFIER = "jobIdentifier";
	public static final String JOBNAME = "Name";
	public static final String STARTTIME = "Start Time";
	public static final String STATUS = "Status";
	public static final String ENDTIME = "End Time";
	
	
	public static final String DESCRIPTION = "Description";
	public static final String COMPUTATION = "Computation";
	
	public static final String ELABORATIONTYPE = "Type";
	
	public static final String OCCURRENCEMODEL = "OccurrenceModel";

	public static final String PERCENTAGE = "Pecentage";
	public static final String ADDRESS = "Address";

	public static final String STATUSPROGESSBAR = "Status Progress";

	public static final String COMPUTATIONID = "Computation id";
	
	public static final String RESOURCETYPE = "Resource type";
	
	//TODO: temp added for serialization
	public ElaborationStatus el;
	public ComputationModel cl;
	public ResourceType rt;
	
	public JobOccurrencesModel(){
	}

	private JobOccurrencesModel(String jobIdentifier, String jobName) {
		set(JOBINDENTIFIER, jobIdentifier);
		set(JOBNAME, jobName);
	}

	
	/**
	 * Used to retrieve computation status
	 * @param jobIdentifier
	 * @param jobName
	 * @param type
	 * @param state
	 * @param computationModel
	 * @param startTime
	 * @param endTime
	 */
	public JobOccurrencesModel(String jobIdentifier, String jobName, ElaborationType type, ElaborationStatus state, ComputationModel computationModel, Date startTime, Date endTime) {
		this(jobIdentifier,jobName, type, state, "", startTime,computationModel.getId());
		set(JOBINDENTIFIER, jobIdentifier);
		set(STATUS, state);
		set(STARTTIME, startTime);
		set(COMPUTATION, computationModel);
		set(ENDTIME, endTime);
		set(COMPUTATIONID, computationModel.getId());
		
	}
	
	
	/**
	 * Used to retrieve table from store
	 * @param jobIdentifier
	 * @param jobName
	 * @param type
	 * @param state
	 * @param computationModel
	 * @param startTime
	 * @param endTime
	 */
	public JobOccurrencesModel(String jobIdentifier, String jobName, String description, Date startTime, Date endTime) {
		this(jobIdentifier,jobName);
		set(DESCRIPTION, description);
		set(STARTTIME, startTime);
		set(ENDTIME, endTime);
		
	}
	
	/**
	 * Used to retrieve occurrences list completed
	 * 
	 * @param jobIdentifier
	 * @param jobName
	 * @param state
	 * @param description
	 * @param startTime
	 */
	public JobOccurrencesModel(String jobIdentifier, String jobName, ElaborationType type, ElaborationStatus state, String description, Date startTime, String operationId) {
		this(jobIdentifier,jobName);
		set(JOBINDENTIFIER, jobIdentifier);
		set(ELABORATIONTYPE,type);
		set(STATUS, state);
		set(STARTTIME, startTime);
		set(DESCRIPTION, description);
		set(COMPUTATIONID, operationId);
	}
	
	
	/**
	 * Used to retrieve occurrences list completed
	 * 
	 * @param jobIdentifier
	 * @param jobName
	 * @param state
	 * @param description
	 * @param startTime
	 */
	public JobOccurrencesModel(String jobIdentifier, String jobName, ElaborationType type, ElaborationStatus state, String description, Date startTime, String operationId, ResourceType resourceType) {
		this(jobIdentifier,jobName);
		set(JOBINDENTIFIER, jobIdentifier);
		set(ELABORATIONTYPE,type);
		set(STATUS, state);
		set(STARTTIME, startTime);
		set(DESCRIPTION, description);
		set(COMPUTATIONID, operationId);
		set(RESOURCETYPE, resourceType);
	}
	
	public String getAddress() {
		return get(ADDRESS);
	}
	
	public ResourceType getResourceType(){
		return get(RESOURCETYPE);
	}
	
	public String getOperationId() {
		return get(COMPUTATIONID);
	}
	
	public String getDescription(){
		return get(DESCRIPTION);
	}
	
	public ComputationModel getComputation(){
		return (ComputationModel) get(COMPUTATION);
	}
	
	public ElaborationStatus getDownloadState() {
		return (ElaborationStatus) get(STATUS);
	}

	public Date getEndTime() {
		return (Date) get(ENDTIME);
	}
	
	public String getIdentifier() {
		return get(JOBINDENTIFIER);
	}

	public String getName() {
		return get(JOBNAME);
	}
	
	public Float getPercentage() {
		return (Float) get(PERCENTAGE);
	}

	public Date getStartTime() {
		return (Date) get(STARTTIME);
	}
	
	public ElaborationType getType() {
		return (ElaborationType) get(ELABORATIONTYPE);
	}

	public void setEndTime(Date endTime) {
		set(ENDTIME, endTime);
	}

	public static Comparator<JobOccurrencesModel> COMPARATOR = new Comparator<JobOccurrencesModel>() {
 
	    public int compare(JobOccurrencesModel mod1, JobOccurrencesModel mod2) {
 
	      String name1 = mod1.getName().toLowerCase();
	      String name2 = mod2.getName().toLowerCase();
 
	      //ascending order
	      return name1.compareTo(name2);
 
	      //descending order
	      //return name1.compareTo(fruitName1);
	    }
 
	};

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("JobOccurrencesModel [getAddress()=");
		builder.append(getAddress());
		builder.append(", getResourceType()=");
		builder.append(getResourceType());
		builder.append(", getOperationId()=");
		builder.append(getOperationId());
		builder.append(", getDescription()=");
		builder.append(getDescription());
		builder.append(", getComputation()=");
		builder.append(getComputation());
		builder.append(", getDownloadState()=");
		builder.append(getDownloadState());
		builder.append(", getEndTime()=");
		builder.append(getEndTime());
		builder.append(", getIdentifier()=");
		builder.append(getIdentifier());
		builder.append(", getName()=");
		builder.append(getName());
		builder.append(", getPercentage()=");
		builder.append(getPercentage());
		builder.append(", getStartTime()=");
		builder.append(getStartTime());
		builder.append(", getType()=");
		builder.append(getType());
		builder.append("]");
		return builder.toString();
	}
}
