/**
 * 
 */
package org.gcube.portlets.user.occurrencemanagement.client.statistical.form;



import org.gcube.portlets.user.occurrencemanagement.client.OccurrenceApplicationController;
import org.gcube.portlets.user.occurrencemanagement.client.resources.Resources;
import org.gcube.portlets.user.occurrencemanagement.client.rpc.OccurrenceManagementServiceAsync;

import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.WindowEvent;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;

/**
 * @author ceras
 * 
 */

/*
 * HSPEN, Half-degree Species Environmental Envelope HCAF, Half-degree Cells
 * Authority File HSPEC, Half-degree Species Assignment OCCURRENCE, MINMAXLAT,
 * TRAININGSET, TESTSET, GENERIC, CLUSTER
 */

public class ColumnSelector extends Dialog {

	private OccurrenceManagementServiceAsync service = OccurrenceApplicationController.occurrenceManagementService;

	/**
	 * 
	 */
	public ColumnSelector(final OccurrenceManagementServiceAsync service) {
		super();

		this.service = service;

		this.setBodyBorder(false);
		this.setButtons(Dialog.OKCANCEL);
		this.setIcon(Resources.folderExplore());
		this.setHeading("Table Explorer");
		this.setWidth(640);
		this.setHeight(480);
		this.setHideOnButtonClick(true);
		this.setModal(true);

		this.setLayout(new FitLayout());
		this.setBodyStyle("border: none;background: none");

	}

	protected void onRender(com.google.gwt.user.client.Element parent, int pos) {
		super.onRender(parent, pos);

		this.addListener(Events.Hide, new Listener<WindowEvent>() {
			public void handleEvent(WindowEvent be) {
				if (be.getButtonClicked() == ColumnSelector.this.getButtonById("ok")) {
					fireSelection("puppa");
				}
			}
		});

	};

	/**
	 * @param tableItem
	 */
	public void fireSelection(String columnName) {
		System.out.println("selected column " + columnName);
	}

}
