/**
 * 
 */
package org.gcube.portlets.user.occurrencemanagement.client.event;

import java.util.List;

import org.gcube.portlets.user.occurrencemanagement.shared.ElaborationType;
import org.gcube.portlets.user.occurrencemanagement.shared.JobOccurrencesModel;

import com.google.gwt.event.shared.GwtEvent;


/**
 * @author Francesco Mangiacrapa francesco.mangiacrapa@isti.cnr.it
 *
 */
public class LoadListOccurrencesEvent extends GwtEvent<LoadListOccurrencesEventHandler> {
	
	public static final GwtEvent.Type<LoadListOccurrencesEventHandler> TYPE = new Type<LoadListOccurrencesEventHandler>();
	private ElaborationType loadType;
	private List<JobOccurrencesModel> listData;

	@Override
	public Type<LoadListOccurrencesEventHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	protected void dispatch(LoadListOccurrencesEventHandler handler) {
		handler.onLoadListOccurrences(this);	
	}
	
	public LoadListOccurrencesEvent(ElaborationType type, List<JobOccurrencesModel> result) {
		this.loadType = type;
		this.listData = result;
	}

	public ElaborationType getLoadType() {
		return loadType;
	}

	public List<JobOccurrencesModel> getListData() {
		return listData;
	}
}
